/*
 * Decompiled with CFR 0.152.
 */
package io.rtron.main.project;

import io.rtron.io.files.FileIdentifier;
import io.rtron.io.files.Path;
import io.rtron.main.project.Project;
import io.rtron.model.AbstractModel;
import io.rtron.model.citygml.CitygmlModel;
import io.rtron.model.opendrive.OpendriveModel;
import io.rtron.model.roadspaces.RoadspacesModel;
import io.rtron.readerwriter.citygml.CitygmlWriter;
import io.rtron.readerwriter.citygml.configuration.CitygmlWriterConfiguration;
import io.rtron.readerwriter.citygml.configuration.CitygmlWriterConfigurationBuilder;
import io.rtron.readerwriter.opendrive.OpendriveReader;
import io.rtron.readerwriter.opendrive.configuration.OpendriveReaderConfiguration;
import io.rtron.readerwriter.opendrive.configuration.OpendriveReaderConfigurationBuilder;
import io.rtron.transformer.opendrive2roadspaces.Opendrive2RoadspacesTransformer;
import io.rtron.transformer.opendrive2roadspaces.configuration.Opendrive2RoadspacesConfiguration;
import io.rtron.transformer.opendrive2roadspaces.configuration.Opendrive2RoadspacesConfigurationBuilder;
import io.rtron.transformer.roadspaces2citygml.Roadspaces2CitygmlTransformer;
import io.rtron.transformer.roadspaces2citygml.configuration.Roadspaces2CitygmlConfiguration;
import io.rtron.transformer.roadspaces2citygml.configuration.Roadspaces2CitygmlConfigurationBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J)\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0019\b\u0002\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b\u00a2\u0006\u0002\b\u001eJ)\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0019\b\u0002\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001d0\u001b\u00a2\u0006\u0002\b\u001eJ)\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 2\u0019\b\u0002\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001d0\u001b\u00a2\u0006\u0002\b\u001eJ)\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020$2\u0019\b\u0002\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001d0\u001b\u00a2\u0006\u0002\b\u001eR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lio/rtron/main/project/Project;", "", "projectId", "", "inputFilePath", "Lio/rtron/io/files/Path;", "outputDirectoryPath", "(Ljava/lang/String;Lio/rtron/io/files/Path;Lio/rtron/io/files/Path;)V", "concurrentProcessing", "", "getConcurrentProcessing", "()Z", "setConcurrentProcessing", "(Z)V", "inputFileIdentifier", "Lio/rtron/io/files/FileIdentifier;", "getInputFileIdentifier", "()Lio/rtron/io/files/FileIdentifier;", "getInputFilePath", "()Lio/rtron/io/files/Path;", "getOutputDirectoryPath", "getProjectId", "()Ljava/lang/String;", "readOpendriveModel", "Lio/rtron/model/opendrive/OpendriveModel;", "filePath", "setup", "Lkotlin/Function1;", "Lio/rtron/readerwriter/opendrive/configuration/OpendriveReaderConfigurationBuilder;", "", "Lkotlin/ExtensionFunctionType;", "transformOpendrive2Roadspaces", "Lio/rtron/model/roadspaces/RoadspacesModel;", "opendriveModel", "Lio/rtron/transformer/opendrive2roadspaces/configuration/Opendrive2RoadspacesConfigurationBuilder;", "transformRoadspaces2Citygml", "Lio/rtron/model/citygml/CitygmlModel;", "roadspacesModel", "Lio/rtron/transformer/roadspaces2citygml/configuration/Roadspaces2CitygmlConfigurationBuilder;", "writeCitygmlModel", "citygmlModel", "Lio/rtron/readerwriter/citygml/configuration/CitygmlWriterConfigurationBuilder;", "rtron-main"})
public final class Project {
    @NotNull
    private final String projectId;
    @NotNull
    private final Path inputFilePath;
    @NotNull
    private final Path outputDirectoryPath;
    @NotNull
    private final FileIdentifier inputFileIdentifier;
    private boolean concurrentProcessing;

    public Project(@NotNull String projectId, @NotNull Path inputFilePath, @NotNull Path outputDirectoryPath) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)inputFilePath, (String)"inputFilePath");
        Intrinsics.checkNotNullParameter((Object)outputDirectoryPath, (String)"outputDirectoryPath");
        this.projectId = projectId;
        this.inputFilePath = inputFilePath;
        this.outputDirectoryPath = outputDirectoryPath;
        this.outputDirectoryPath.createDirectory();
        this.inputFileIdentifier = FileIdentifier.Companion.of(this.inputFilePath);
    }

    @NotNull
    public final String getProjectId() {
        return this.projectId;
    }

    @NotNull
    public final Path getInputFilePath() {
        return this.inputFilePath;
    }

    @NotNull
    public final Path getOutputDirectoryPath() {
        return this.outputDirectoryPath;
    }

    @NotNull
    public final FileIdentifier getInputFileIdentifier() {
        return this.inputFileIdentifier;
    }

    public final boolean getConcurrentProcessing() {
        return this.concurrentProcessing;
    }

    public final void setConcurrentProcessing(boolean bl) {
        this.concurrentProcessing = bl;
    }

    @NotNull
    public final OpendriveModel readOpendriveModel(@NotNull Path filePath, @NotNull Function1<? super OpendriveReaderConfigurationBuilder, Unit> setup) {
        OpendriveReaderConfigurationBuilder builder;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        OpendriveReaderConfigurationBuilder opendriveReaderConfigurationBuilder = builder = new OpendriveReaderConfigurationBuilder(this.projectId);
        boolean bl = false;
        boolean bl2 = false;
        setup.invoke((Object)opendriveReaderConfigurationBuilder);
        OpendriveReaderConfiguration configuration = opendriveReaderConfigurationBuilder.build();
        return new OpendriveReader(configuration).read(filePath);
    }

    public static /* synthetic */ OpendriveModel readOpendriveModel$default(Project project, Path path, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = readOpendriveModel.1.INSTANCE;
        }
        return project.readOpendriveModel(path, (Function1<? super OpendriveReaderConfigurationBuilder, Unit>)function1);
    }

    @NotNull
    public final RoadspacesModel transformOpendrive2Roadspaces(@NotNull OpendriveModel opendriveModel, @NotNull Function1<? super Opendrive2RoadspacesConfigurationBuilder, Unit> setup) {
        Opendrive2RoadspacesConfigurationBuilder builder;
        Intrinsics.checkNotNullParameter((Object)opendriveModel, (String)"opendriveModel");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        Opendrive2RoadspacesConfigurationBuilder opendrive2RoadspacesConfigurationBuilder = builder = new Opendrive2RoadspacesConfigurationBuilder(this.projectId, this.inputFileIdentifier, this.concurrentProcessing);
        boolean bl = false;
        boolean bl2 = false;
        setup.invoke((Object)opendrive2RoadspacesConfigurationBuilder);
        Opendrive2RoadspacesConfiguration configuration = opendrive2RoadspacesConfigurationBuilder.build();
        return new Opendrive2RoadspacesTransformer(configuration).transform(opendriveModel);
    }

    public static /* synthetic */ RoadspacesModel transformOpendrive2Roadspaces$default(Project project, OpendriveModel opendriveModel, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = transformOpendrive2Roadspaces.1.INSTANCE;
        }
        return project.transformOpendrive2Roadspaces(opendriveModel, (Function1<? super Opendrive2RoadspacesConfigurationBuilder, Unit>)function1);
    }

    @NotNull
    public final CitygmlModel transformRoadspaces2Citygml(@NotNull RoadspacesModel roadspacesModel, @NotNull Function1<? super Roadspaces2CitygmlConfigurationBuilder, Unit> setup) {
        Roadspaces2CitygmlConfigurationBuilder builder;
        Intrinsics.checkNotNullParameter((Object)roadspacesModel, (String)"roadspacesModel");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        Roadspaces2CitygmlConfigurationBuilder roadspaces2CitygmlConfigurationBuilder = builder = new Roadspaces2CitygmlConfigurationBuilder(this.projectId, this.inputFileIdentifier, this.concurrentProcessing);
        boolean bl = false;
        boolean bl2 = false;
        setup.invoke((Object)roadspaces2CitygmlConfigurationBuilder);
        Roadspaces2CitygmlConfiguration configuration = roadspaces2CitygmlConfigurationBuilder.build();
        return new Roadspaces2CitygmlTransformer(configuration).transform(roadspacesModel);
    }

    public static /* synthetic */ CitygmlModel transformRoadspaces2Citygml$default(Project project, RoadspacesModel roadspacesModel, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = transformRoadspaces2Citygml.1.INSTANCE;
        }
        return project.transformRoadspaces2Citygml(roadspacesModel, (Function1<? super Roadspaces2CitygmlConfigurationBuilder, Unit>)function1);
    }

    public final void writeCitygmlModel(@NotNull CitygmlModel citygmlModel, @NotNull Function1<? super CitygmlWriterConfigurationBuilder, Unit> setup) {
        CitygmlWriterConfigurationBuilder builder;
        Intrinsics.checkNotNullParameter((Object)citygmlModel, (String)"citygmlModel");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        CitygmlWriterConfigurationBuilder citygmlWriterConfigurationBuilder = builder = new CitygmlWriterConfigurationBuilder(this.projectId);
        boolean bl = false;
        boolean bl2 = false;
        setup.invoke((Object)citygmlWriterConfigurationBuilder);
        CitygmlWriterConfiguration configuration = citygmlWriterConfigurationBuilder.build();
        new CitygmlWriter(configuration).write((AbstractModel)citygmlModel, this.outputDirectoryPath);
    }

    public static /* synthetic */ void writeCitygmlModel$default(Project project, CitygmlModel citygmlModel, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = writeCitygmlModel.1.INSTANCE;
        }
        project.writeCitygmlModel(citygmlModel, (Function1<? super CitygmlWriterConfigurationBuilder, Unit>)function1);
    }
}

