/*
 * Decompiled with CFR 0.152.
 */
package io.rtron.io.files;

import io.rtron.io.files.File;
import io.rtron.io.files.FileIdentifierInterface;
import io.rtron.io.files.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lio/rtron/io/files/FileIdentifier;", "Lio/rtron/io/files/FileIdentifierInterface;", "fileName", "", "fileExtension", "filePath", "Lio/rtron/io/files/Path;", "fileHashSha256", "(Ljava/lang/String;Ljava/lang/String;Lio/rtron/io/files/Path;Ljava/lang/String;)V", "getFileExtension", "()Ljava/lang/String;", "getFileHashSha256", "getFileName", "getFilePath", "()Lio/rtron/io/files/Path;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "rtron-io"})
public final class FileIdentifier
implements FileIdentifierInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileName;
    @NotNull
    private final String fileExtension;
    @NotNull
    private final Path filePath;
    @NotNull
    private final String fileHashSha256;

    public FileIdentifier(@NotNull String fileName2, @NotNull String fileExtension, @NotNull Path filePath, @NotNull String fileHashSha256) {
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)fileHashSha256, (String)"fileHashSha256");
        this.fileName = fileName2;
        this.fileExtension = fileExtension;
        this.filePath = filePath;
        this.fileHashSha256 = fileHashSha256;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    @NotNull
    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    @NotNull
    public String getFileHashSha256() {
        return this.fileHashSha256;
    }

    @NotNull
    public final String component1() {
        return this.getFileName();
    }

    @NotNull
    public final String component2() {
        return this.getFileExtension();
    }

    @NotNull
    public final Path component3() {
        return this.getFilePath();
    }

    @NotNull
    public final String component4() {
        return this.getFileHashSha256();
    }

    @NotNull
    public final FileIdentifier copy(@NotNull String fileName2, @NotNull String fileExtension, @NotNull Path filePath, @NotNull String fileHashSha256) {
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)fileHashSha256, (String)"fileHashSha256");
        return new FileIdentifier(fileName2, fileExtension, filePath, fileHashSha256);
    }

    public static /* synthetic */ FileIdentifier copy$default(FileIdentifier fileIdentifier, String string, String string2, Path path, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = fileIdentifier.getFileName();
        }
        if ((n & 2) != 0) {
            string2 = fileIdentifier.getFileExtension();
        }
        if ((n & 4) != 0) {
            path = fileIdentifier.getFilePath();
        }
        if ((n & 8) != 0) {
            string3 = fileIdentifier.getFileHashSha256();
        }
        return fileIdentifier.copy(string, string2, path, string3);
    }

    @NotNull
    public String toString() {
        return "FileIdentifier(fileName=" + this.getFileName() + ", fileExtension=" + this.getFileExtension() + ", filePath=" + this.getFilePath() + ", fileHashSha256=" + this.getFileHashSha256() + ')';
    }

    public int hashCode() {
        int result = this.getFileName().hashCode();
        result = result * 31 + this.getFileExtension().hashCode();
        result = result * 31 + this.getFilePath().hashCode();
        result = result * 31 + this.getFileHashSha256().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileIdentifier)) {
            return false;
        }
        FileIdentifier fileIdentifier = (FileIdentifier)other;
        if (!Intrinsics.areEqual((Object)this.getFileName(), (Object)fileIdentifier.getFileName())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getFileExtension(), (Object)fileIdentifier.getFileExtension())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getFilePath(), (Object)fileIdentifier.getFilePath())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getFileHashSha256(), (Object)fileIdentifier.getFileHashSha256());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/rtron/io/files/FileIdentifier$Companion;", "", "()V", "of", "Lio/rtron/io/files/FileIdentifier;", "file", "Lio/rtron/io/files/File;", "path", "Lio/rtron/io/files/Path;", "rtron-io"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileIdentifier of(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.of(new File(path));
        }

        @NotNull
        public final FileIdentifier of(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getNameWithoutExtension();
            String string2 = file.getExtension();
            Path path = file.getPath();
            String string3 = file.getHashSha256();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.hashSha256");
            return new FileIdentifier(string, string2, path, string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

