/*
 * Decompiled with CFR 0.152.
 */
package io.rtron.io.files;

import com.google.common.hash.Hashing;
import io.rtron.io.files.Path;
import io.rtron.std.date.DateTime;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010*\u001a\u00020\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR!\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\r\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\r\u001a\u0004\b\u001a\u0010\u0018R!\u0010\u001c\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\r\u0012\u0004\b\u001d\u0010\u0011\u001a\u0004\b\u001e\u0010\u0013R!\u0010 \u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\r\u0012\u0004\b!\u0010\u0011\u001a\u0004\b\"\u0010\u0013R\u0011\u0010$\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0018R\u0011\u0010&\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lio/rtron/io/files/File;", "", "path", "Lio/rtron/io/files/Path;", "(Lio/rtron/io/files/Path;)V", "_file", "Ljava/io/File;", "attributes", "Ljava/nio/file/attribute/BasicFileAttributes;", "kotlin.jvm.PlatformType", "getAttributes", "()Ljava/nio/file/attribute/BasicFileAttributes;", "attributes$delegate", "Lkotlin/Lazy;", "creationTime", "Lio/rtron/std/date/DateTime;", "getCreationTime$annotations", "()V", "getCreationTime", "()Lio/rtron/std/date/DateTime;", "creationTime$delegate", "extension", "", "getExtension", "()Ljava/lang/String;", "hashSha256", "getHashSha256", "hashSha256$delegate", "lastAccessTime", "getLastAccessTime$annotations", "getLastAccessTime", "lastAccessTime$delegate", "lastModified", "getLastModified$annotations", "getLastModified", "lastModified$delegate", "name", "getName", "nameWithoutExtension", "getNameWithoutExtension", "getPath", "()Lio/rtron/io/files/Path;", "readText", "rtron-io"})
public final class File {
    @NotNull
    private final Path path;
    @NotNull
    private final java.io.File _file;
    @NotNull
    private final String name;
    @NotNull
    private final String nameWithoutExtension;
    @NotNull
    private final String extension;
    @NotNull
    private final Lazy hashSha256$delegate;
    @NotNull
    private final Lazy attributes$delegate;
    @NotNull
    private final Lazy creationTime$delegate;
    @NotNull
    private final Lazy lastAccessTime$delegate;
    @NotNull
    private final Lazy lastModified$delegate;

    public File(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this._file = new java.io.File(this.path.toString());
        String string = this._file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"_file.name");
        this.name = string;
        this.nameWithoutExtension = FilesKt.getNameWithoutExtension((java.io.File)this._file);
        this.extension = FilesKt.getExtension((java.io.File)this._file);
        this.hashSha256$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ File this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string;
                try {
                    string = com.google.common.io.Files.asByteSource((java.io.File)File.access$get_file$p(this.this$0)).hash(Hashing.sha256()).toString();
                }
                catch (Exception e) {
                    string = "";
                }
                return string;
            }
        }));
        this.attributes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BasicFileAttributes>(this){
            final /* synthetic */ File this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final BasicFileAttributes invoke() {
                return Files.readAttributes(this.this$0.getPath().toPathN(), BasicFileAttributes.class, new LinkOption[0]);
            }
        }));
        this.creationTime$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DateTime>(this){
            final /* synthetic */ File this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DateTime invoke() {
                FileTime fileTime = File.access$getAttributes(this.this$0).creationTime();
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"attributes.creationTime()");
                return DateTime.Companion.of(fileTime);
            }
        }));
        this.lastAccessTime$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DateTime>(this){
            final /* synthetic */ File this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DateTime invoke() {
                FileTime fileTime = File.access$getAttributes(this.this$0).lastAccessTime();
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"attributes.lastAccessTime()");
                return DateTime.Companion.of(fileTime);
            }
        }));
        this.lastModified$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DateTime>(this){
            final /* synthetic */ File this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DateTime invoke() {
                FileTime fileTime = File.access$getAttributes(this.this$0).lastModifiedTime();
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"attributes.lastModifiedTime()");
                return DateTime.Companion.of(fileTime);
            }
        }));
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getNameWithoutExtension() {
        return this.nameWithoutExtension;
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    @NotNull
    public final String getHashSha256() {
        Lazy lazy = this.hashSha256$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final BasicFileAttributes getAttributes() {
        Lazy lazy = this.attributes$delegate;
        boolean bl = false;
        return (BasicFileAttributes)lazy.getValue();
    }

    @NotNull
    public final DateTime getCreationTime() {
        Lazy lazy = this.creationTime$delegate;
        boolean bl = false;
        return (DateTime)lazy.getValue();
    }

    public static /* synthetic */ void getCreationTime$annotations() {
    }

    @NotNull
    public final DateTime getLastAccessTime() {
        Lazy lazy = this.lastAccessTime$delegate;
        boolean bl = false;
        return (DateTime)lazy.getValue();
    }

    public static /* synthetic */ void getLastAccessTime$annotations() {
    }

    @NotNull
    public final DateTime getLastModified() {
        Lazy lazy = this.lastModified$delegate;
        boolean bl = false;
        return (DateTime)lazy.getValue();
    }

    public static /* synthetic */ void getLastModified$annotations() {
    }

    @NotNull
    public final String readText() {
        return FilesKt.readText$default((java.io.File)this._file, null, (int)1, null);
    }

    public static final /* synthetic */ java.io.File access$get_file$p(File $this) {
        return $this._file;
    }

    public static final /* synthetic */ BasicFileAttributes access$getAttributes(File $this) {
        return $this.getAttributes();
    }
}

