/*
 * Decompiled with CFR 0.152.
 */
package io.rouz.grpc.kotlin;

import com.google.common.base.Strings;
import com.google.common.html.HtmlEscapers;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import com.salesforce.jprotoc.ProtocPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GrpcKotlinGenerator
extends Generator {
    private static final int METHOD_NUMBER_OF_PATHS = 4;
    private static final String CLASS_SUFFIX = "GrpcKt";
    private static final String SERVICE_JAVA_DOC_PREFIX = "    ";
    private static final String METHOD_JAVA_DOC_PREFIX = "        ";

    public static void main(String[] args) {
        ProtocPlugin.generate((Generator)new GrpcKotlinGenerator());
    }

    public Stream<PluginProtos.CodeGeneratorResponse.File> generate(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        ProtoTypeMap typeMap = ProtoTypeMap.of((Collection)request.getProtoFileList());
        List<DescriptorProtos.FileDescriptorProto> protosToGenerate = request.getProtoFileList().stream().filter(protoFile -> request.getFileToGenerateList().contains((Object)protoFile.getName())).collect(Collectors.toList());
        List<Context> services = this.findServices(protosToGenerate, typeMap);
        List<PluginProtos.CodeGeneratorResponse.File> files = this.generateFiles(services);
        return files.stream();
    }

    private List<Context> findServices(List<DescriptorProtos.FileDescriptorProto> protos, ProtoTypeMap typeMap) {
        ArrayList<Context> contexts = new ArrayList<Context>();
        protos.forEach(fileProto -> {
            List locations = fileProto.getSourceCodeInfo().getLocationList();
            locations.stream().filter(location -> location.getPathCount() == 2 && location.getPath(0) == 6).forEach(location -> {
                int serviceNumber = location.getPath(1);
                Context context = this.context(fileProto.getService(serviceNumber), typeMap, locations, serviceNumber);
                context.javaDoc = this.getJavaDoc(this.getComments((DescriptorProtos.SourceCodeInfo.Location)location), SERVICE_JAVA_DOC_PREFIX);
                context.protoName = fileProto.getName();
                context.packageName = this.extractPackageName((DescriptorProtos.FileDescriptorProto)fileProto);
                contexts.add(context);
            });
        });
        return contexts;
    }

    private String extractPackageName(DescriptorProtos.FileDescriptorProto proto) {
        String javaPackage;
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options != null && !Strings.isNullOrEmpty((String)(javaPackage = options.getJavaPackage()))) {
            return javaPackage;
        }
        return Strings.nullToEmpty((String)proto.getPackage());
    }

    private Context context(DescriptorProtos.ServiceDescriptorProto serviceProto, ProtoTypeMap protoTypeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int serviceNumber) {
        Context context = new Context();
        context.fileName = serviceProto.getName() + CLASS_SUFFIX + ".kt";
        context.className = serviceProto.getName() + CLASS_SUFFIX;
        context.serviceName = serviceProto.getName();
        context.deprecated = serviceProto.getOptions() != null && serviceProto.getOptions().getDeprecated();
        locations.stream().filter(location -> location.getPathCount() == 4 && location.getPath(0) == 6 && location.getPath(1) == serviceNumber && location.getPath(2) == 2).forEach(location -> {
            int methodNumber = location.getPath(3);
            MethodContext methodContext = this.methodContext(serviceProto.getMethod(methodNumber), protoTypeMap);
            methodContext.methodNumber = methodNumber;
            methodContext.javaDoc = this.getJavaDoc(this.getComments((DescriptorProtos.SourceCodeInfo.Location)location), METHOD_JAVA_DOC_PREFIX);
            context.methods.add(methodContext);
        });
        return context;
    }

    private MethodContext methodContext(DescriptorProtos.MethodDescriptorProto methodProto, ProtoTypeMap typeMap) {
        MethodContext methodContext = new MethodContext();
        methodContext.methodName = this.lowerCaseFirst(methodProto.getName());
        methodContext.inputType = typeMap.toJavaTypeName(methodProto.getInputType());
        methodContext.outputType = typeMap.toJavaTypeName(methodProto.getOutputType());
        methodContext.deprecated = methodProto.getOptions() != null && methodProto.getOptions().getDeprecated();
        methodContext.isManyInput = methodProto.getClientStreaming();
        methodContext.isManyOutput = methodProto.getServerStreaming();
        if (!methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.grpcCallsMethodName = "asyncUnaryCall";
        }
        if (!methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.grpcCallsMethodName = "asyncServerStreamingCall";
        }
        if (methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.grpcCallsMethodName = "asyncClientStreamingCall";
        }
        if (methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.grpcCallsMethodName = "asyncBidiStreamingCall";
        }
        return methodContext;
    }

    private String lowerCaseFirst(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private List<PluginProtos.CodeGeneratorResponse.File> generateFiles(List<Context> services) {
        return services.stream().map(this::buildFile).collect(Collectors.toList());
    }

    private PluginProtos.CodeGeneratorResponse.File buildFile(Context context) {
        String content = this.applyTemplate("KtStub.mustache", context);
        return PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.absoluteFileName(context)).setContent(content).build();
    }

    private String absoluteFileName(Context ctx) {
        String dir = ctx.packageName.replace('.', '/');
        if (Strings.isNullOrEmpty((String)dir)) {
            return ctx.fileName;
        }
        return dir + "/" + ctx.fileName;
    }

    private String getComments(DescriptorProtos.SourceCodeInfo.Location location) {
        return location.getLeadingComments().isEmpty() ? location.getTrailingComments() : location.getLeadingComments();
    }

    private String getJavaDoc(String comments, String prefix) {
        if (!comments.isEmpty()) {
            StringBuilder builder = new StringBuilder("/**\n").append(prefix).append(" * <pre>\n");
            Arrays.stream(HtmlEscapers.htmlEscaper().escape(comments).split("\n")).forEach(line -> builder.append(prefix).append(" * ").append((String)line).append("\n"));
            builder.append(prefix).append(" * <pre>\n").append(prefix).append(" */");
            return builder.toString();
        }
        return null;
    }

    private class MethodContext {
        public String methodName;
        public String inputType;
        public String outputType;
        public boolean deprecated;
        public boolean isManyInput;
        public boolean isManyOutput;
        public String grpcCallsMethodName;
        public int methodNumber;
        public String javaDoc;

        private MethodContext() {
        }

        public String methodNameUpperUnderscore() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.methodName.length(); ++i) {
                char c = this.methodName.charAt(i);
                s.append(Character.toUpperCase(c));
                if (i >= this.methodName.length() - 1 || !Character.isLowerCase(c) || !Character.isUpperCase(this.methodName.charAt(i + 1))) continue;
                s.append('_');
            }
            return s.toString();
        }

        public String methodNamePascalCase() {
            return String.valueOf(Character.toUpperCase(this.methodName.charAt(0))) + this.methodName.substring(1);
        }
    }

    private class Context {
        public String fileName;
        public String protoName;
        public String packageName;
        public String className;
        public String serviceName;
        public boolean deprecated;
        public String javaDoc;
        public List<MethodContext> methods = new ArrayList<MethodContext>();

        private Context() {
        }
    }
}

