package io.rouz.grpc.examples.chat

import io.rouz.grpc.examples.chat.ChatServiceGrpc.*

import io.grpc.*
import io.grpc.stub.*
import io.rouz.grpc.*

import kotlin.coroutines.*
import kotlinx.coroutines.*
import kotlinx.coroutines.channels.*



@javax.annotation.Generated(
    value = ["by gRPC Kotlin generator"],
    comments = "Source: chat.proto"
)
abstract class ChatServiceImplBase(
    coroutineContext: CoroutineContext = Dispatchers.Default
) : BindableService, CoroutineScope {

    private val _coroutineContext: CoroutineContext = coroutineContext

    override val coroutineContext: CoroutineContext
        get() = ContextCoroutineContextElement() + _coroutineContext

    
    
    
    open suspend fun chat(requests: ReceiveChannel<io.rouz.grpc.examples.chat.ChatMessage>): ReceiveChannel<io.rouz.grpc.examples.chat.ChatMessageFromService> {
        throw unimplemented(getChatMethod()).asRuntimeException()
    }

    internal fun chatInternal(
        responseObserver: StreamObserver<io.rouz.grpc.examples.chat.ChatMessageFromService>
    ): StreamObserver<io.rouz.grpc.examples.chat.ChatMessage> {
        val requests = StreamObserverChannel<io.rouz.grpc.examples.chat.ChatMessage>()
        launch {
            tryCatchingStatus(responseObserver) {
                val responses = chat(requests)
                for (response in responses) {
                    onNext(response)
                }
            }
        }
        return requests
    }
    
    
    
    open suspend fun getNames(request: com.google.protobuf.Empty): io.rouz.grpc.examples.chat.ChatRoom {
        throw unimplemented(getGetNamesMethod()).asRuntimeException()
    }

    internal fun getNamesInternal(
        request: com.google.protobuf.Empty,
        responseObserver: StreamObserver<io.rouz.grpc.examples.chat.ChatRoom>
    ) {
        launch {
            tryCatchingStatus(responseObserver) {
                val response = getNames(request)
                onNext(response)
            }
        }
    }

    override fun bindService(): ServerServiceDefinition {
        return ServerServiceDefinition.builder(getServiceDescriptor())
            .addMethod(
                getChatMethod(),
                ServerCalls.asyncBidiStreamingCall(
                    MethodHandlers(METHODID_CHAT)
                )
            )
            .addMethod(
                getGetNamesMethod(),
                ServerCalls.asyncUnaryCall(
                    MethodHandlers(METHODID_GET_NAMES)
                )
            )
            .build()
    }

    private fun unimplemented(methodDescriptor: MethodDescriptor<*, *>): Status {
        return Status.UNIMPLEMENTED
            .withDescription("Method ${methodDescriptor.fullMethodName} is unimplemented")
    }

    private fun <E> handleException(t: Throwable?, responseObserver: StreamObserver<E>) {
        when (t) {
            null -> return
            is CancellationException -> handleException(t.cause, responseObserver)
            is StatusException, is StatusRuntimeException -> responseObserver.onError(t)
            is RuntimeException -> {
                responseObserver.onError(Status.UNKNOWN.asRuntimeException())
                throw t
            }
            is Exception -> {
                responseObserver.onError(Status.UNKNOWN.asException())
                throw t
            }
            else -> {
                responseObserver.onError(Status.INTERNAL.asException())
                throw t
            }
        }
    }

    private suspend fun <E> tryCatchingStatus(responseObserver: StreamObserver<E>, body: suspend StreamObserver<E>.() -> Unit) {
        try {
            responseObserver.body()
            responseObserver.onCompleted()
        } catch (t: Throwable) {
            handleException(t, responseObserver)
        }
    }

    private val METHODID_CHAT = 0
    private val METHODID_GET_NAMES = 1

    private inner class MethodHandlers<Req, Resp> internal constructor(
        private val methodId: Int
    ) : ServerCalls.UnaryMethod<Req, Resp>,
        ServerCalls.ServerStreamingMethod<Req, Resp>,
        ServerCalls.ClientStreamingMethod<Req, Resp>,
        ServerCalls.BidiStreamingMethod<Req, Resp> {

        @Suppress("UNCHECKED_CAST")
        override fun invoke(request: Req, responseObserver: StreamObserver<Resp>) {
            when (methodId) {
                METHODID_GET_NAMES ->
                    this@ChatServiceImplBase.getNamesInternal(
                        request as com.google.protobuf.Empty,
                        responseObserver as StreamObserver<io.rouz.grpc.examples.chat.ChatRoom>
                    )
                else -> throw AssertionError()
            }
        }

        @Suppress("UNCHECKED_CAST")
        override fun invoke(responseObserver: StreamObserver<Resp>): StreamObserver<Req> {
            when (methodId) {
                METHODID_CHAT ->
                    return this@ChatServiceImplBase.chatInternal(
                        responseObserver as StreamObserver<io.rouz.grpc.examples.chat.ChatMessageFromService>
                    ) as StreamObserver<Req>
                else -> throw AssertionError()
            }
        }
    }
}
