package io.rouz.flo.dsl

import io.rouz.flo.Task
import io.rouz.flo.TaskBuilder
import io.rouz.flo.TaskContext.Value
import io.rouz.flo._

import _root_.scala.collection.JavaConversions
import _root_.scala.reflect.ClassTag

import io.rouz.flo.dsl.Util._

private[dsl] class Builder0[Z: ClassTag](val name: String, val args: Any*) extends TaskBuilder0[Z] { self =>

  private val cls = implicitly[ClassTag[Z]].runtimeClass.asInstanceOf[Class[Z]]
  private val builder = Task
      .named(name, args.asInstanceOf[Seq[AnyRef]]:_*)
      .ofType(cls)

  override def process(fn: => Z): Task[Z] =
    builder.process(f0(fn))

  override def processWithContext(fn: (TaskContext) => Value[Z]): Task[Z] =
    builder.processWithContext(f1(fn))

  override def in[A1](task: => Task[A1]): TaskBuilder1[A1, Z] = new Builder1[A1, Z] {
    type J1 = A1
    val c1: J1 => A1 = identity
    val builder = self.builder.in(fn(task))
  }

  override def ins[A1](tasks: => List[Task[A1]]) = new Builder1[List[A1], Z] {
    type J1 = java.util.List[A1]
    val c1: J1 => List[A1] = JavaConversions.iterableAsScalaIterable(_).toList
    val builder = self.builder.ins(javaList(tasks))
  }
}

private[dsl] trait Builder1[A1, Z] extends TaskBuilder1[A1, Z] {
  self =>

  type J1
  val c1: J1 => A1
  val builder: TaskBuilder.TaskBuilder1[J1, Z]

  override def process(fn: (A1) => Z): Task[Z] =
    builder.process(f1(
      (a1) => fn(c1(a1))
    ))

  override def processWithContext(fn: (TaskContext) => (A1) => Value[Z]): Task[Z] =
    builder.processWithContext(f2(
      (tc, a1) => fn(tc)(c1(a1))
    ))

  override def in[A2](task: => Task[A2]): TaskBuilder2[A1, A2, Z] =
    new Builder2[A1, A2, Z] {
      type J2 = A2
      val c2: J2 => A2 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A2](tasks: => List[Task[A2]]): TaskBuilder2[A1, List[A2], Z] =
    new Builder2[A1, List[A2], Z] {
      type J2 = java.util.List[A2]
      val c2: J2 => List[A2] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder2[A1, A2, Z] extends TaskBuilder2[A1, A2, Z] {
  self =>

  // previous builder
  val p: Builder1[A1,Z]

  type J2
  val c2: J2 => A2
  val builder: TaskBuilder.TaskBuilder2[p.J1, J2, Z]

  override def process(fn: (A1, A2) => Z): Task[Z] =
    builder.process(f2(
      (a1, a2) => fn(p.c1(a1), c2(a2))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2) => Value[Z]): Task[Z] =
    builder.processWithContext(f3(
      (tc, a1, a2) => fn(tc)(p.c1(a1), c2(a2))
    ))

  override def in[A3](task: => Task[A3]): TaskBuilder3[A1, A2, A3, Z] =
    new Builder3[A1, A2, A3, Z] {
      type J3 = A3
      val c3: J3 => A3 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A3](tasks: => List[Task[A3]]): TaskBuilder3[A1, A2, List[A3], Z] =
    new Builder3[A1, A2, List[A3], Z] {
      type J3 = java.util.List[A3]
      val c3: J3 => List[A3] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder3[A1, A2, A3, Z] extends TaskBuilder3[A1, A2, A3, Z] {
  self =>

  // previous builder
  val p: Builder2[A1, A2,Z]

  type J3
  val c3: J3 => A3
  val builder: TaskBuilder.TaskBuilder3[p.p.J1, p.J2, J3, Z]

  override def process(fn: (A1, A2, A3) => Z): Task[Z] =
    builder.process(f3(
      (a1, a2, a3) => fn(p.p.c1(a1), p.c2(a2), c3(a3))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3) => Value[Z]): Task[Z] =
    builder.processWithContext(f4(
      (tc, a1, a2, a3) => fn(tc)(p.p.c1(a1), p.c2(a2), c3(a3))
    ))

  override def in[A4](task: => Task[A4]): TaskBuilder4[A1, A2, A3, A4, Z] =
    new Builder4[A1, A2, A3, A4, Z] {
      type J4 = A4
      val c4: J4 => A4 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A4](tasks: => List[Task[A4]]): TaskBuilder4[A1, A2, A3, List[A4], Z] =
    new Builder4[A1, A2, A3, List[A4], Z] {
      type J4 = java.util.List[A4]
      val c4: J4 => List[A4] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder4[A1, A2, A3, A4, Z] extends TaskBuilder4[A1, A2, A3, A4, Z] {
  self =>

  // previous builder
  val p: Builder3[A1, A2, A3,Z]

  type J4
  val c4: J4 => A4
  val builder: TaskBuilder.TaskBuilder4[p.p.p.J1, p.p.J2, p.J3, J4, Z]

  override def process(fn: (A1, A2, A3, A4) => Z): Task[Z] =
    builder.process(f4(
      (a1, a2, a3, a4) => fn(p.p.p.c1(a1), p.p.c2(a2), p.c3(a3), c4(a4))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4) => Value[Z]): Task[Z] =
    builder.processWithContext(f5(
      (tc, a1, a2, a3, a4) => fn(tc)(p.p.p.c1(a1), p.p.c2(a2), p.c3(a3), c4(a4))
    ))

  override def in[A5](task: => Task[A5]): TaskBuilder5[A1, A2, A3, A4, A5, Z] =
    new Builder5[A1, A2, A3, A4, A5, Z] {
      type J5 = A5
      val c5: J5 => A5 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A5](tasks: => List[Task[A5]]): TaskBuilder5[A1, A2, A3, A4, List[A5], Z] =
    new Builder5[A1, A2, A3, A4, List[A5], Z] {
      type J5 = java.util.List[A5]
      val c5: J5 => List[A5] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder5[A1, A2, A3, A4, A5, Z] extends TaskBuilder5[A1, A2, A3, A4, A5, Z] {
  self =>

  // previous builder
  val p: Builder4[A1, A2, A3, A4,Z]

  type J5
  val c5: J5 => A5
  val builder: TaskBuilder.TaskBuilder5[p.p.p.p.J1, p.p.p.J2, p.p.J3, p.J4, J5, Z]

  override def process(fn: (A1, A2, A3, A4, A5) => Z): Task[Z] =
    builder.process(f5(
      (a1, a2, a3, a4, a5) => fn(p.p.p.p.c1(a1), p.p.p.c2(a2), p.p.c3(a3), p.c4(a4), c5(a5))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5) => Value[Z]): Task[Z] =
    builder.processWithContext(f6(
      (tc, a1, a2, a3, a4, a5) => fn(tc)(p.p.p.p.c1(a1), p.p.p.c2(a2), p.p.c3(a3), p.c4(a4), c5(a5))
    ))

  override def in[A6](task: => Task[A6]): TaskBuilder6[A1, A2, A3, A4, A5, A6, Z] =
    new Builder6[A1, A2, A3, A4, A5, A6, Z] {
      type J6 = A6
      val c6: J6 => A6 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A6](tasks: => List[Task[A6]]): TaskBuilder6[A1, A2, A3, A4, A5, List[A6], Z] =
    new Builder6[A1, A2, A3, A4, A5, List[A6], Z] {
      type J6 = java.util.List[A6]
      val c6: J6 => List[A6] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder6[A1, A2, A3, A4, A5, A6, Z] extends TaskBuilder6[A1, A2, A3, A4, A5, A6, Z] {
  self =>

  // previous builder
  val p: Builder5[A1, A2, A3, A4, A5,Z]

  type J6
  val c6: J6 => A6
  val builder: TaskBuilder.TaskBuilder6[p.p.p.p.p.J1, p.p.p.p.J2, p.p.p.J3, p.p.J4, p.J5, J6, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6) => Z): Task[Z] =
    builder.process(f6(
      (a1, a2, a3, a4, a5, a6) => fn(p.p.p.p.p.c1(a1), p.p.p.p.c2(a2), p.p.p.c3(a3), p.p.c4(a4), p.c5(a5), c6(a6))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6) => Value[Z]): Task[Z] =
    builder.processWithContext(f7(
      (tc, a1, a2, a3, a4, a5, a6) => fn(tc)(p.p.p.p.p.c1(a1), p.p.p.p.c2(a2), p.p.p.c3(a3), p.p.c4(a4), p.c5(a5), c6(a6))
    ))

  override def in[A7](task: => Task[A7]): TaskBuilder7[A1, A2, A3, A4, A5, A6, A7, Z] =
    new Builder7[A1, A2, A3, A4, A5, A6, A7, Z] {
      type J7 = A7
      val c7: J7 => A7 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A7](tasks: => List[Task[A7]]): TaskBuilder7[A1, A2, A3, A4, A5, A6, List[A7], Z] =
    new Builder7[A1, A2, A3, A4, A5, A6, List[A7], Z] {
      type J7 = java.util.List[A7]
      val c7: J7 => List[A7] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder7[A1, A2, A3, A4, A5, A6, A7, Z] extends TaskBuilder7[A1, A2, A3, A4, A5, A6, A7, Z] {
  self =>

  // previous builder
  val p: Builder6[A1, A2, A3, A4, A5, A6,Z]

  type J7
  val c7: J7 => A7
  val builder: TaskBuilder.TaskBuilder7[p.p.p.p.p.p.J1, p.p.p.p.p.J2, p.p.p.p.J3, p.p.p.J4, p.p.J5, p.J6, J7, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7) => Z): Task[Z] =
    builder.process(f7(
      (a1, a2, a3, a4, a5, a6, a7) => fn(p.p.p.p.p.p.c1(a1), p.p.p.p.p.c2(a2), p.p.p.p.c3(a3), p.p.p.c4(a4), p.p.c5(a5), p.c6(a6), c7(a7))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7) => Value[Z]): Task[Z] =
    builder.processWithContext(f8(
      (tc, a1, a2, a3, a4, a5, a6, a7) => fn(tc)(p.p.p.p.p.p.c1(a1), p.p.p.p.p.c2(a2), p.p.p.p.c3(a3), p.p.p.c4(a4), p.p.c5(a5), p.c6(a6), c7(a7))
    ))

  override def in[A8](task: => Task[A8]): TaskBuilder8[A1, A2, A3, A4, A5, A6, A7, A8, Z] =
    new Builder8[A1, A2, A3, A4, A5, A6, A7, A8, Z] {
      type J8 = A8
      val c8: J8 => A8 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A8](tasks: => List[Task[A8]]): TaskBuilder8[A1, A2, A3, A4, A5, A6, A7, List[A8], Z] =
    new Builder8[A1, A2, A3, A4, A5, A6, A7, List[A8], Z] {
      type J8 = java.util.List[A8]
      val c8: J8 => List[A8] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder8[A1, A2, A3, A4, A5, A6, A7, A8, Z] extends TaskBuilder8[A1, A2, A3, A4, A5, A6, A7, A8, Z] {
  self =>

  // previous builder
  val p: Builder7[A1, A2, A3, A4, A5, A6, A7,Z]

  type J8
  val c8: J8 => A8
  val builder: TaskBuilder.TaskBuilder8[p.p.p.p.p.p.p.J1, p.p.p.p.p.p.J2, p.p.p.p.p.J3, p.p.p.p.J4, p.p.p.J5, p.p.J6, p.J7, J8, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7, A8) => Z): Task[Z] =
    builder.process(f8(
      (a1, a2, a3, a4, a5, a6, a7, a8) => fn(p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.c2(a2), p.p.p.p.p.c3(a3), p.p.p.p.c4(a4), p.p.p.c5(a5), p.p.c6(a6), p.c7(a7), c8(a8))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7, A8) => Value[Z]): Task[Z] =
    builder.processWithContext(f9(
      (tc, a1, a2, a3, a4, a5, a6, a7, a8) => fn(tc)(p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.c2(a2), p.p.p.p.p.c3(a3), p.p.p.p.c4(a4), p.p.p.c5(a5), p.p.c6(a6), p.c7(a7), c8(a8))
    ))

  override def in[A9](task: => Task[A9]): TaskBuilder9[A1, A2, A3, A4, A5, A6, A7, A8, A9, Z] =
    new Builder9[A1, A2, A3, A4, A5, A6, A7, A8, A9, Z] {
      type J9 = A9
      val c9: J9 => A9 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A9](tasks: => List[Task[A9]]): TaskBuilder9[A1, A2, A3, A4, A5, A6, A7, A8, List[A9], Z] =
    new Builder9[A1, A2, A3, A4, A5, A6, A7, A8, List[A9], Z] {
      type J9 = java.util.List[A9]
      val c9: J9 => List[A9] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder9[A1, A2, A3, A4, A5, A6, A7, A8, A9, Z] extends TaskBuilder9[A1, A2, A3, A4, A5, A6, A7, A8, A9, Z] {
  self =>

  // previous builder
  val p: Builder8[A1, A2, A3, A4, A5, A6, A7, A8,Z]

  type J9
  val c9: J9 => A9
  val builder: TaskBuilder.TaskBuilder9[p.p.p.p.p.p.p.p.J1, p.p.p.p.p.p.p.J2, p.p.p.p.p.p.J3, p.p.p.p.p.J4, p.p.p.p.J5, p.p.p.J6, p.p.J7, p.J8, J9, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7, A8, A9) => Z): Task[Z] =
    builder.process(f9(
      (a1, a2, a3, a4, a5, a6, a7, a8, a9) => fn(p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.c3(a3), p.p.p.p.p.c4(a4), p.p.p.p.c5(a5), p.p.p.c6(a6), p.p.c7(a7), p.c8(a8), c9(a9))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7, A8, A9) => Value[Z]): Task[Z] =
    builder.processWithContext(f10(
      (tc, a1, a2, a3, a4, a5, a6, a7, a8, a9) => fn(tc)(p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.c3(a3), p.p.p.p.p.c4(a4), p.p.p.p.c5(a5), p.p.p.c6(a6), p.p.c7(a7), p.c8(a8), c9(a9))
    ))

  override def in[A10](task: => Task[A10]): TaskBuilder10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Z] =
    new Builder10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Z] {
      type J10 = A10
      val c10: J10 => A10 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A10](tasks: => List[Task[A10]]): TaskBuilder10[A1, A2, A3, A4, A5, A6, A7, A8, A9, List[A10], Z] =
    new Builder10[A1, A2, A3, A4, A5, A6, A7, A8, A9, List[A10], Z] {
      type J10 = java.util.List[A10]
      val c10: J10 => List[A10] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Z] extends TaskBuilder10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, Z] {
  self =>

  // previous builder
  val p: Builder9[A1, A2, A3, A4, A5, A6, A7, A8, A9,Z]

  type J10
  val c10: J10 => A10
  val builder: TaskBuilder.TaskBuilder10[p.p.p.p.p.p.p.p.p.J1, p.p.p.p.p.p.p.p.J2, p.p.p.p.p.p.p.J3, p.p.p.p.p.p.J4, p.p.p.p.p.J5, p.p.p.p.J6, p.p.p.J7, p.p.J8, p.J9, J10, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) => Z): Task[Z] =
    builder.process(f10(
      (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) => fn(p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.c4(a4), p.p.p.p.p.c5(a5), p.p.p.p.c6(a6), p.p.p.c7(a7), p.p.c8(a8), p.c9(a9), c10(a10))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10) => Value[Z]): Task[Z] =
    builder.processWithContext(f11(
      (tc, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10) => fn(tc)(p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.c4(a4), p.p.p.p.p.c5(a5), p.p.p.p.c6(a6), p.p.p.c7(a7), p.p.c8(a8), p.c9(a9), c10(a10))
    ))

  override def in[A11](task: => Task[A11]): TaskBuilder11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Z] =
    new Builder11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Z] {
      type J11 = A11
      val c11: J11 => A11 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A11](tasks: => List[Task[A11]]): TaskBuilder11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, List[A11], Z] =
    new Builder11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, List[A11], Z] {
      type J11 = java.util.List[A11]
      val c11: J11 => List[A11] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Z] extends TaskBuilder11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, Z] {
  self =>

  // previous builder
  val p: Builder10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10,Z]

  type J11
  val c11: J11 => A11
  val builder: TaskBuilder.TaskBuilder11[p.p.p.p.p.p.p.p.p.p.J1, p.p.p.p.p.p.p.p.p.J2, p.p.p.p.p.p.p.p.J3, p.p.p.p.p.p.p.J4, p.p.p.p.p.p.J5, p.p.p.p.p.J6, p.p.p.p.J7, p.p.p.J8, p.p.J9, p.J10, J11, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) => Z): Task[Z] =
    builder.process(f11(
      (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11) => fn(p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.c5(a5), p.p.p.p.p.c6(a6), p.p.p.p.c7(a7), p.p.p.c8(a8), p.p.c9(a9), p.c10(a10), c11(a11))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11) => Value[Z]): Task[Z] =
    builder.processWithContext(f12(
      (tc, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11) => fn(tc)(p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.c5(a5), p.p.p.p.p.c6(a6), p.p.p.p.c7(a7), p.p.p.c8(a8), p.p.c9(a9), p.c10(a10), c11(a11))
    ))

  override def in[A12](task: => Task[A12]): TaskBuilder12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Z] =
    new Builder12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Z] {
      type J12 = A12
      val c12: J12 => A12 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A12](tasks: => List[Task[A12]]): TaskBuilder12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, List[A12], Z] =
    new Builder12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, List[A12], Z] {
      type J12 = java.util.List[A12]
      val c12: J12 => List[A12] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Z] extends TaskBuilder12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, Z] {
  self =>

  // previous builder
  val p: Builder11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11,Z]

  type J12
  val c12: J12 => A12
  val builder: TaskBuilder.TaskBuilder12[p.p.p.p.p.p.p.p.p.p.p.J1, p.p.p.p.p.p.p.p.p.p.J2, p.p.p.p.p.p.p.p.p.J3, p.p.p.p.p.p.p.p.J4, p.p.p.p.p.p.p.J5, p.p.p.p.p.p.J6, p.p.p.p.p.J7, p.p.p.p.J8, p.p.p.J9, p.p.J10, p.J11, J12, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) => Z): Task[Z] =
    builder.process(f12(
      (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12) => fn(p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.c6(a6), p.p.p.p.p.c7(a7), p.p.p.p.c8(a8), p.p.p.c9(a9), p.p.c10(a10), p.c11(a11), c12(a12))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12) => Value[Z]): Task[Z] =
    builder.processWithContext(f13(
      (tc, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12) => fn(tc)(p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.c6(a6), p.p.p.p.p.c7(a7), p.p.p.p.c8(a8), p.p.p.c9(a9), p.p.c10(a10), p.c11(a11), c12(a12))
    ))

  override def in[A13](task: => Task[A13]): TaskBuilder13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Z] =
    new Builder13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Z] {
      type J13 = A13
      val c13: J13 => A13 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A13](tasks: => List[Task[A13]]): TaskBuilder13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, List[A13], Z] =
    new Builder13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, List[A13], Z] {
      type J13 = java.util.List[A13]
      val c13: J13 => List[A13] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Z] extends TaskBuilder13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, Z] {
  self =>

  // previous builder
  val p: Builder12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12,Z]

  type J13
  val c13: J13 => A13
  val builder: TaskBuilder.TaskBuilder13[p.p.p.p.p.p.p.p.p.p.p.p.J1, p.p.p.p.p.p.p.p.p.p.p.J2, p.p.p.p.p.p.p.p.p.p.J3, p.p.p.p.p.p.p.p.p.J4, p.p.p.p.p.p.p.p.J5, p.p.p.p.p.p.p.J6, p.p.p.p.p.p.J7, p.p.p.p.p.J8, p.p.p.p.J9, p.p.p.J10, p.p.J11, p.J12, J13, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) => Z): Task[Z] =
    builder.process(f13(
      (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13) => fn(p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.c7(a7), p.p.p.p.p.c8(a8), p.p.p.p.c9(a9), p.p.p.c10(a10), p.p.c11(a11), p.c12(a12), c13(a13))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13) => Value[Z]): Task[Z] =
    builder.processWithContext(f14(
      (tc, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13) => fn(tc)(p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.c7(a7), p.p.p.p.p.c8(a8), p.p.p.p.c9(a9), p.p.p.c10(a10), p.p.c11(a11), p.c12(a12), c13(a13))
    ))

  override def in[A14](task: => Task[A14]): TaskBuilder14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Z] =
    new Builder14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Z] {
      type J14 = A14
      val c14: J14 => A14 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A14](tasks: => List[Task[A14]]): TaskBuilder14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, List[A14], Z] =
    new Builder14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, List[A14], Z] {
      type J14 = java.util.List[A14]
      val c14: J14 => List[A14] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Z] extends TaskBuilder14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, Z] {
  self =>

  // previous builder
  val p: Builder13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13,Z]

  type J14
  val c14: J14 => A14
  val builder: TaskBuilder.TaskBuilder14[p.p.p.p.p.p.p.p.p.p.p.p.p.J1, p.p.p.p.p.p.p.p.p.p.p.p.J2, p.p.p.p.p.p.p.p.p.p.p.J3, p.p.p.p.p.p.p.p.p.p.J4, p.p.p.p.p.p.p.p.p.J5, p.p.p.p.p.p.p.p.J6, p.p.p.p.p.p.p.J7, p.p.p.p.p.p.J8, p.p.p.p.p.J9, p.p.p.p.J10, p.p.p.J11, p.p.J12, p.J13, J14, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) => Z): Task[Z] =
    builder.process(f14(
      (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14) => fn(p.p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.p.c7(a7), p.p.p.p.p.p.c8(a8), p.p.p.p.p.c9(a9), p.p.p.p.c10(a10), p.p.p.c11(a11), p.p.c12(a12), p.c13(a13), c14(a14))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14) => Value[Z]): Task[Z] =
    builder.processWithContext(f15(
      (tc, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14) => fn(tc)(p.p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.p.c7(a7), p.p.p.p.p.p.c8(a8), p.p.p.p.p.c9(a9), p.p.p.p.c10(a10), p.p.p.c11(a11), p.p.c12(a12), p.c13(a13), c14(a14))
    ))

  override def in[A15](task: => Task[A15]): TaskBuilder15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Z] =
    new Builder15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Z] {
      type J15 = A15
      val c15: J15 => A15 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A15](tasks: => List[Task[A15]]): TaskBuilder15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, List[A15], Z] =
    new Builder15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, List[A15], Z] {
      type J15 = java.util.List[A15]
      val c15: J15 => List[A15] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Z] extends TaskBuilder15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, Z] {
  self =>

  // previous builder
  val p: Builder14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14,Z]

  type J15
  val c15: J15 => A15
  val builder: TaskBuilder.TaskBuilder15[p.p.p.p.p.p.p.p.p.p.p.p.p.p.J1, p.p.p.p.p.p.p.p.p.p.p.p.p.J2, p.p.p.p.p.p.p.p.p.p.p.p.J3, p.p.p.p.p.p.p.p.p.p.p.J4, p.p.p.p.p.p.p.p.p.p.J5, p.p.p.p.p.p.p.p.p.J6, p.p.p.p.p.p.p.p.J7, p.p.p.p.p.p.p.J8, p.p.p.p.p.p.J9, p.p.p.p.p.J10, p.p.p.p.J11, p.p.p.J12, p.p.J13, p.J14, J15, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) => Z): Task[Z] =
    builder.process(f15(
      (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15) => fn(p.p.p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.p.p.c7(a7), p.p.p.p.p.p.p.c8(a8), p.p.p.p.p.p.c9(a9), p.p.p.p.p.c10(a10), p.p.p.p.c11(a11), p.p.p.c12(a12), p.p.c13(a13), p.c14(a14), c15(a15))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15) => Value[Z]): Task[Z] =
    builder.processWithContext(f16(
      (tc, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15) => fn(tc)(p.p.p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.p.p.c7(a7), p.p.p.p.p.p.p.c8(a8), p.p.p.p.p.p.c9(a9), p.p.p.p.p.c10(a10), p.p.p.p.c11(a11), p.p.p.c12(a12), p.p.c13(a13), p.c14(a14), c15(a15))
    ))

  override def in[A16](task: => Task[A16]): TaskBuilder16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Z] =
    new Builder16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Z] {
      type J16 = A16
      val c16: J16 => A16 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A16](tasks: => List[Task[A16]]): TaskBuilder16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, List[A16], Z] =
    new Builder16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, List[A16], Z] {
      type J16 = java.util.List[A16]
      val c16: J16 => List[A16] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Z] extends TaskBuilder16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, Z] {
  self =>

  // previous builder
  val p: Builder15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15,Z]

  type J16
  val c16: J16 => A16
  val builder: TaskBuilder.TaskBuilder16[p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.J1, p.p.p.p.p.p.p.p.p.p.p.p.p.p.J2, p.p.p.p.p.p.p.p.p.p.p.p.p.J3, p.p.p.p.p.p.p.p.p.p.p.p.J4, p.p.p.p.p.p.p.p.p.p.p.J5, p.p.p.p.p.p.p.p.p.p.J6, p.p.p.p.p.p.p.p.p.J7, p.p.p.p.p.p.p.p.J8, p.p.p.p.p.p.p.J9, p.p.p.p.p.p.J10, p.p.p.p.p.J11, p.p.p.p.J12, p.p.p.J13, p.p.J14, p.J15, J16, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) => Z): Task[Z] =
    builder.process(f16(
      (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16) => fn(p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.p.p.p.c7(a7), p.p.p.p.p.p.p.p.c8(a8), p.p.p.p.p.p.p.c9(a9), p.p.p.p.p.p.c10(a10), p.p.p.p.p.c11(a11), p.p.p.p.c12(a12), p.p.p.c13(a13), p.p.c14(a14), p.c15(a15), c16(a16))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16) => Value[Z]): Task[Z] =
    builder.processWithContext(f17(
      (tc, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16) => fn(tc)(p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.p.p.p.c7(a7), p.p.p.p.p.p.p.p.c8(a8), p.p.p.p.p.p.p.c9(a9), p.p.p.p.p.p.c10(a10), p.p.p.p.p.c11(a11), p.p.p.p.c12(a12), p.p.p.c13(a13), p.p.c14(a14), p.c15(a15), c16(a16))
    ))

  override def in[A17](task: => Task[A17]): TaskBuilder17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, Z] =
    new Builder17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, Z] {
      type J17 = A17
      val c17: J17 => A17 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A17](tasks: => List[Task[A17]]): TaskBuilder17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, List[A17], Z] =
    new Builder17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, List[A17], Z] {
      type J17 = java.util.List[A17]
      val c17: J17 => List[A17] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, Z] extends TaskBuilder17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, Z] {
  self =>

  // previous builder
  val p: Builder16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16,Z]

  type J17
  val c17: J17 => A17
  val builder: TaskBuilder.TaskBuilder17[p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.J1, p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.J2, p.p.p.p.p.p.p.p.p.p.p.p.p.p.J3, p.p.p.p.p.p.p.p.p.p.p.p.p.J4, p.p.p.p.p.p.p.p.p.p.p.p.J5, p.p.p.p.p.p.p.p.p.p.p.J6, p.p.p.p.p.p.p.p.p.p.J7, p.p.p.p.p.p.p.p.p.J8, p.p.p.p.p.p.p.p.J9, p.p.p.p.p.p.p.J10, p.p.p.p.p.p.J11, p.p.p.p.p.J12, p.p.p.p.J13, p.p.p.J14, p.p.J15, p.J16, J17, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) => Z): Task[Z] =
    builder.process(f17(
      (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17) => fn(p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.p.p.p.p.c7(a7), p.p.p.p.p.p.p.p.p.c8(a8), p.p.p.p.p.p.p.p.c9(a9), p.p.p.p.p.p.p.c10(a10), p.p.p.p.p.p.c11(a11), p.p.p.p.p.c12(a12), p.p.p.p.c13(a13), p.p.p.c14(a14), p.p.c15(a15), p.c16(a16), c17(a17))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17) => Value[Z]): Task[Z] =
    builder.processWithContext(f18(
      (tc, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17) => fn(tc)(p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.p.p.p.p.c7(a7), p.p.p.p.p.p.p.p.p.c8(a8), p.p.p.p.p.p.p.p.c9(a9), p.p.p.p.p.p.p.c10(a10), p.p.p.p.p.p.c11(a11), p.p.p.p.p.c12(a12), p.p.p.p.c13(a13), p.p.p.c14(a14), p.p.c15(a15), p.c16(a16), c17(a17))
    ))

  override def in[A18](task: => Task[A18]): TaskBuilder18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, Z] =
    new Builder18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, Z] {
      type J18 = A18
      val c18: J18 => A18 = identity
      val p: self.type = self
      val builder = self.builder.in(fn(task))
    }

  override def ins[A18](tasks: => List[Task[A18]]): TaskBuilder18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, List[A18], Z] =
    new Builder18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, List[A18], Z] {
      type J18 = java.util.List[A18]
      val c18: J18 => List[A18] = JavaConversions.iterableAsScalaIterable(_).toList
      val p: self.type = self
      val builder = self.builder.ins(javaList(tasks))
    }
}

private[dsl] trait Builder18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, Z] extends TaskBuilder18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, Z] {
  self =>

  // previous builder
  val p: Builder17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17,Z]

  type J18
  val c18: J18 => A18
  val builder: TaskBuilder.TaskBuilder18[p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.J1, p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.J2, p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.J3, p.p.p.p.p.p.p.p.p.p.p.p.p.p.J4, p.p.p.p.p.p.p.p.p.p.p.p.p.J5, p.p.p.p.p.p.p.p.p.p.p.p.J6, p.p.p.p.p.p.p.p.p.p.p.J7, p.p.p.p.p.p.p.p.p.p.J8, p.p.p.p.p.p.p.p.p.J9, p.p.p.p.p.p.p.p.J10, p.p.p.p.p.p.p.J11, p.p.p.p.p.p.J12, p.p.p.p.p.J13, p.p.p.p.J14, p.p.p.J15, p.p.J16, p.J17, J18, Z]

  override def process(fn: (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) => Z): Task[Z] =
    builder.process(f18(
      (a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18) => fn(p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.p.p.p.p.p.c7(a7), p.p.p.p.p.p.p.p.p.p.c8(a8), p.p.p.p.p.p.p.p.p.c9(a9), p.p.p.p.p.p.p.p.c10(a10), p.p.p.p.p.p.p.c11(a11), p.p.p.p.p.p.c12(a12), p.p.p.p.p.c13(a13), p.p.p.p.c14(a14), p.p.p.c15(a15), p.p.c16(a16), p.c17(a17), c18(a18))
    ))

  override def processWithContext(fn: (TaskContext) => (A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18) => Value[Z]): Task[Z] =
    builder.processWithContext(f19(
      (tc, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18) => fn(tc)(p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c1(a1), p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c2(a2), p.p.p.p.p.p.p.p.p.p.p.p.p.p.p.c3(a3), p.p.p.p.p.p.p.p.p.p.p.p.p.p.c4(a4), p.p.p.p.p.p.p.p.p.p.p.p.p.c5(a5), p.p.p.p.p.p.p.p.p.p.p.p.c6(a6), p.p.p.p.p.p.p.p.p.p.p.c7(a7), p.p.p.p.p.p.p.p.p.p.c8(a8), p.p.p.p.p.p.p.p.p.c9(a9), p.p.p.p.p.p.p.p.c10(a10), p.p.p.p.p.p.p.c11(a11), p.p.p.p.p.p.c12(a12), p.p.p.p.p.c13(a13), p.p.p.p.c14(a14), p.p.p.c15(a15), p.p.c16(a16), p.c17(a17), c18(a18))
    ))
}
