package io.rouz.flo.dsl

import io.rouz.flo.Task
import io.rouz.flo.TaskBuilder._
import io.rouz.flo.TaskContext.Value
import io.rouz.flo._

import _root_.scala.collection.JavaConversions
import _root_.scala.reflect.ClassTag

object FloTask {
  def named[Z: ClassTag](name: String, args: Any*): TaskBuilder0[Z] = new Builder0(name, args:_*)
}

trait TaskBuilder0[Z] {
  def process(fn: => Z): Task[Z]
  def processWithContext(fn: TaskContext => Value[Z]): Task[Z]
  def in[A](task: => Task[A]): TaskBuilder1[A, Z]
  def ins[A](tasks: => List[Task[A]]): TaskBuilder1[List[A], Z]

  def ->(fn: => Z): Task[Z] = process(fn)
  def └>(fn: => Z): Task[Z] = process(fn)
  def ->>(fn: TaskContext => Value[Z]): Task[Z] = processWithContext(fn)
  def └>>(fn: TaskContext => Value[Z]): Task[Z] = processWithContext(fn)

  def <[A](task: => Task[A]): TaskBuilder1[A, Z] = in(task)
  def <<[A](tasks: => List[Task[A]]): TaskBuilder1[List[A], Z] = ins(tasks)

  def ┌[A](task: => Task[A]): TaskBuilder1[A, Z] = in(task)
  def ╒[A](tasks: => List[Task[A]]): TaskBuilder1[List[A], Z] = ins(tasks)

  def ┬[A](task: => Task[A]): TaskBuilder1[A, Z] = in(task)
  def ╤[A](tasks: => List[Task[A]]): TaskBuilder1[List[A], Z] = ins(tasks)

  def ├[A](task: => Task[A]): TaskBuilder1[A, Z] = in(task)
  def ╞[A](tasks: => List[Task[A]]): TaskBuilder1[List[A], Z] = ins(tasks)
}

trait TaskBuilder1[A, Z] {
  def process(fn: (A) => Z): Task[Z]
  def └>(fn: (A) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[B](task: => Task[B]): TaskBuilder2[A, B, Z]
  def < [B](task: => Task[B]) = in(task)
  def ├ [B](task: => Task[B]) = in(task)

  def ins[B](tasks: => List[Task[B]]): TaskBuilder2[A, List[B], Z]
  def << [B](tasks: => List[Task[B]]) = ins(tasks)
  def ╞  [B](tasks: => List[Task[B]]) = ins(tasks)
}

trait TaskBuilder2[A, B, Z] {
  def process(fn: (A, B) => Z): Task[Z]
  def └>(fn: (A, B) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[C](task: => Task[C]): TaskBuilder3[A, B, C, Z]
  def < [C](task: => Task[C]) = in(task)
  def ├ [C](task: => Task[C]) = in(task)

  def ins[C](tasks: => List[Task[C]]): TaskBuilder3[A, B, List[C], Z]
  def << [C](tasks: => List[Task[C]]) = ins(tasks)
  def ╞  [C](tasks: => List[Task[C]]) = ins(tasks)
}

trait TaskBuilder3[A, B, C, Z] {
  def process(fn: (A, B, C) => Z): Task[Z]
  def └>(fn: (A, B, C) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[D](task: => Task[D]): TaskBuilder4[A, B, C, D, Z]
  def < [D](task: => Task[D]) = in(task)
  def ├ [D](task: => Task[D]) = in(task)

  def ins[D](tasks: => List[Task[D]]): TaskBuilder4[A, B, C, List[D], Z]
  def << [D](tasks: => List[Task[D]]) = ins(tasks)
  def ╞  [D](tasks: => List[Task[D]]) = ins(tasks)
}

trait TaskBuilder4[A, B, C, D, Z] {
  def process(fn: (A, B, C, D) => Z): Task[Z]
  def └>(fn: (A, B, C, D) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[E](task: => Task[E]): TaskBuilder5[A, B, C, D, E, Z]
  def < [E](task: => Task[E]) = in(task)
  def ├ [E](task: => Task[E]) = in(task)

  def ins[E](tasks: => List[Task[E]]): TaskBuilder5[A, B, C, D, List[E], Z]
  def << [E](tasks: => List[Task[E]]) = ins(tasks)
  def ╞  [E](tasks: => List[Task[E]]) = ins(tasks)
}

trait TaskBuilder5[A, B, C, D, E, Z] {
  def process(fn: (A, B, C, D, E) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[F](task: => Task[F]): TaskBuilder6[A, B, C, D, E, F, Z]
  def < [F](task: => Task[F]) = in(task)
  def ├ [F](task: => Task[F]) = in(task)

  def ins[F](tasks: => List[Task[F]]): TaskBuilder6[A, B, C, D, E, List[F], Z]
  def << [F](tasks: => List[Task[F]]) = ins(tasks)
  def ╞  [F](tasks: => List[Task[F]]) = ins(tasks)
}

trait TaskBuilder6[A, B, C, D, E, F, Z] {
  def process(fn: (A, B, C, D, E, F) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[G](task: => Task[G]): TaskBuilder7[A, B, C, D, E, F, G, Z]
  def < [G](task: => Task[G]) = in(task)
  def ├ [G](task: => Task[G]) = in(task)

  def ins[G](tasks: => List[Task[G]]): TaskBuilder7[A, B, C, D, E, F, List[G], Z]
  def << [G](tasks: => List[Task[G]]) = ins(tasks)
  def ╞  [G](tasks: => List[Task[G]]) = ins(tasks)
}

trait TaskBuilder7[A, B, C, D, E, F, G, Z] {
  def process(fn: (A, B, C, D, E, F, G) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[H](task: => Task[H]): TaskBuilder8[A, B, C, D, E, F, G, H, Z]
  def < [H](task: => Task[H]) = in(task)
  def ├ [H](task: => Task[H]) = in(task)

  def ins[H](tasks: => List[Task[H]]): TaskBuilder8[A, B, C, D, E, F, G, List[H], Z]
  def << [H](tasks: => List[Task[H]]) = ins(tasks)
  def ╞  [H](tasks: => List[Task[H]]) = ins(tasks)
}

trait TaskBuilder8[A, B, C, D, E, F, G, H, Z] {
  def process(fn: (A, B, C, D, E, F, G, H) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G, H) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G, H) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G, H) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[I](task: => Task[I]): TaskBuilder9[A, B, C, D, E, F, G, H, I, Z]
  def < [I](task: => Task[I]) = in(task)
  def ├ [I](task: => Task[I]) = in(task)

  def ins[I](tasks: => List[Task[I]]): TaskBuilder9[A, B, C, D, E, F, G, H, List[I], Z]
  def << [I](tasks: => List[Task[I]]) = ins(tasks)
  def ╞  [I](tasks: => List[Task[I]]) = ins(tasks)
}

trait TaskBuilder9[A, B, C, D, E, F, G, H, I, Z] {
  def process(fn: (A, B, C, D, E, F, G, H, I) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G, H, I) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G, H, I) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G, H, I) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[J](task: => Task[J]): TaskBuilder10[A, B, C, D, E, F, G, H, I, J, Z]
  def < [J](task: => Task[J]) = in(task)
  def ├ [J](task: => Task[J]) = in(task)

  def ins[J](tasks: => List[Task[J]]): TaskBuilder10[A, B, C, D, E, F, G, H, I, List[J], Z]
  def << [J](tasks: => List[Task[J]]) = ins(tasks)
  def ╞  [J](tasks: => List[Task[J]]) = ins(tasks)
}

trait TaskBuilder10[A, B, C, D, E, F, G, H, I, J, Z] {
  def process(fn: (A, B, C, D, E, F, G, H, I, J) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G, H, I, J) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[K](task: => Task[K]): TaskBuilder11[A, B, C, D, E, F, G, H, I, J, K, Z]
  def < [K](task: => Task[K]) = in(task)
  def ├ [K](task: => Task[K]) = in(task)

  def ins[K](tasks: => List[Task[K]]): TaskBuilder11[A, B, C, D, E, F, G, H, I, J, List[K], Z]
  def << [K](tasks: => List[Task[K]]) = ins(tasks)
  def ╞  [K](tasks: => List[Task[K]]) = ins(tasks)
}

trait TaskBuilder11[A, B, C, D, E, F, G, H, I, J, K, Z] {
  def process(fn: (A, B, C, D, E, F, G, H, I, J, K) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G, H, I, J, K) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[L](task: => Task[L]): TaskBuilder12[A, B, C, D, E, F, G, H, I, J, K, L, Z]
  def < [L](task: => Task[L]) = in(task)
  def ├ [L](task: => Task[L]) = in(task)

  def ins[L](tasks: => List[Task[L]]): TaskBuilder12[A, B, C, D, E, F, G, H, I, J, K, List[L], Z]
  def << [L](tasks: => List[Task[L]]) = ins(tasks)
  def ╞  [L](tasks: => List[Task[L]]) = ins(tasks)
}

trait TaskBuilder12[A, B, C, D, E, F, G, H, I, J, K, L, Z] {
  def process(fn: (A, B, C, D, E, F, G, H, I, J, K, L) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G, H, I, J, K, L) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[M](task: => Task[M]): TaskBuilder13[A, B, C, D, E, F, G, H, I, J, K, L, M, Z]
  def < [M](task: => Task[M]) = in(task)
  def ├ [M](task: => Task[M]) = in(task)

  def ins[M](tasks: => List[Task[M]]): TaskBuilder13[A, B, C, D, E, F, G, H, I, J, K, L, List[M], Z]
  def << [M](tasks: => List[Task[M]]) = ins(tasks)
  def ╞  [M](tasks: => List[Task[M]]) = ins(tasks)
}

trait TaskBuilder13[A, B, C, D, E, F, G, H, I, J, K, L, M, Z] {
  def process(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[N](task: => Task[N]): TaskBuilder14[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Z]
  def < [N](task: => Task[N]) = in(task)
  def ├ [N](task: => Task[N]) = in(task)

  def ins[N](tasks: => List[Task[N]]): TaskBuilder14[A, B, C, D, E, F, G, H, I, J, K, L, M, List[N], Z]
  def << [N](tasks: => List[Task[N]]) = ins(tasks)
  def ╞  [N](tasks: => List[Task[N]]) = ins(tasks)
}

trait TaskBuilder14[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Z] {
  def process(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M, N) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M, N) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M, N) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M, N) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[O](task: => Task[O]): TaskBuilder15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Z]
  def < [O](task: => Task[O]) = in(task)
  def ├ [O](task: => Task[O]) = in(task)

  def ins[O](tasks: => List[Task[O]]): TaskBuilder15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, List[O], Z]
  def << [O](tasks: => List[Task[O]]) = ins(tasks)
  def ╞  [O](tasks: => List[Task[O]]) = ins(tasks)
}

trait TaskBuilder15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Z] {
  def process(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[P](task: => Task[P]): TaskBuilder16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Z]
  def < [P](task: => Task[P]) = in(task)
  def ├ [P](task: => Task[P]) = in(task)

  def ins[P](tasks: => List[Task[P]]): TaskBuilder16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, List[P], Z]
  def << [P](tasks: => List[Task[P]]) = ins(tasks)
  def ╞  [P](tasks: => List[Task[P]]) = ins(tasks)
}

trait TaskBuilder16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Z] {
  def process(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[Q](task: => Task[Q]): TaskBuilder17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Z]
  def < [Q](task: => Task[Q]) = in(task)
  def ├ [Q](task: => Task[Q]) = in(task)

  def ins[Q](tasks: => List[Task[Q]]): TaskBuilder17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, List[Q], Z]
  def << [Q](tasks: => List[Task[Q]]) = ins(tasks)
  def ╞  [Q](tasks: => List[Task[Q]]) = ins(tasks)
}

trait TaskBuilder17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Z] {
  def process(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q) => Value[Z]): Task[Z] = processWithContext(fn)

  def in[R](task: => Task[R]): TaskBuilder18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Z]
  def < [R](task: => Task[R]) = in(task)
  def ├ [R](task: => Task[R]) = in(task)

  def ins[R](tasks: => List[Task[R]]): TaskBuilder18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, List[R], Z]
  def << [R](tasks: => List[Task[R]]) = ins(tasks)
  def ╞  [R](tasks: => List[Task[R]]) = ins(tasks)
}

trait TaskBuilder18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Z] {
  def process(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R) => Z): Task[Z]
  def └>(fn: (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R) => Z): Task[Z] = process(fn)

  def processWithContext(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R) => Value[Z]): Task[Z]
  def └>>(fn: TaskContext => (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R) => Value[Z]): Task[Z] = processWithContext(fn)
}
