/*
 * Decompiled with CFR 0.152.
 */
package io.rouz.flo.freezer;

import io.rouz.flo.Fn;
import io.rouz.flo.Task;
import io.rouz.flo.TaskContext;
import io.rouz.flo.TaskId;
import io.rouz.flo.Util;
import io.rouz.flo.context.ForwardingTaskContext;
import io.rouz.flo.freezer.PersistingContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EvaluatingContext {
    static final String OUTPUT_SUFFIX = "_out";
    private final Path basePath;
    private final TaskContext delegate;

    public EvaluatingContext(Path basePath, TaskContext delegate) {
        this.basePath = Objects.requireNonNull(basePath);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public <T> TaskContext.Value<T> evaluateTaskFrom(Path persistedTask) {
        Task task = null;
        try {
            task = (Task)PersistingContext.deserialize(persistedTask);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new SpecificEval(task, this.delegate).evaluate(task);
    }

    private Path resolveExistingOutput(TaskId taskId) {
        String fileName = PersistingContext.cleanForFilename(taskId) + OUTPUT_SUFFIX;
        return this.basePath.resolve(fileName);
    }

    private <T> void persist(TaskId taskId, T output) {
        Path outputPath = this.basePath.resolve(PersistingContext.cleanForFilename(taskId) + OUTPUT_SUFFIX);
        try {
            PersistingContext.serialize(output, outputPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class SpecificEval
    extends ForwardingTaskContext {
        private final Task<?> evalTask;

        protected SpecificEval(Task<?> evalTask, TaskContext delegate) {
            super(delegate);
            this.evalTask = evalTask;
        }

        public <T> TaskContext.Value<T> evaluateInternal(Task<T> task, TaskContext context) {
            TaskContext.Promise promise = this.promise();
            TaskId id = task.id();
            Set inputTaskIds = this.evalTask.inputs().stream().map(Task::id).collect(Collectors.toSet());
            if (inputTaskIds.contains(id)) {
                Path inputValuePath = EvaluatingContext.this.resolveExistingOutput(id);
                if (Files.exists(inputValuePath, new LinkOption[0])) {
                    try {
                        Object value = PersistingContext.deserialize(inputValuePath);
                        promise.set(value);
                    }
                    catch (Exception e) {
                        promise.fail((Throwable)e);
                    }
                } else {
                    promise.fail((Throwable)new RuntimeException("Output value for input task " + id + " not found"));
                }
            } else if (!id.equals(this.evalTask.id())) {
                promise.fail((Throwable)new RuntimeException("Evaluation of unexpected task: " + id));
            } else {
                TaskContext.Value tValue = super.evaluateInternal(task, context);
                tValue.consume(v -> EvaluatingContext.this.persist(this.evalTask.id(), v));
                tValue.consume(arg_0 -> ((TaskContext.Promise)promise).set(arg_0));
                tValue.onFail(arg_0 -> ((TaskContext.Promise)promise).fail(arg_0));
            }
            return promise.value();
        }

        public <T> TaskContext.Value<T> invokeProcessFn(TaskId taskId, Fn<TaskContext.Value<T>> processFn) {
            TaskContext.Value tValue = super.invokeProcessFn(taskId, processFn);
            tValue.consume(v -> LOG.info("{} == {}", (Object)Util.colored((TaskId)taskId), v));
            return tValue;
        }
    }
}

