/*
 * Decompiled with CFR 0.152.
 */
package io.rouz.flo.freezer;

import io.rouz.flo.TaskContext;
import io.rouz.flo.context.InstrumentedContext;
import io.rouz.flo.context.MemoizingContext;
import io.rouz.flo.freezer.EvaluatingContext;
import io.rouz.flo.freezer.LoggingListener;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunnerEntrypoint {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRunnerEntrypoint.class);

    public static void main(String[] args) throws InterruptedException {
        if (args.length < 1) {
            LOG.info("Usage: flo-task-runner <persisted-task-file>");
            System.exit(1);
        }
        String file = args[0];
        URI fileUri = URI.create(file);
        Path filePath = Paths.get(fileUri);
        EvaluatingContext evaluatingContext = new EvaluatingContext(filePath.resolveSibling(""), MemoizingContext.composeWith((TaskContext)InstrumentedContext.composeWith((TaskContext)TaskContext.inmem(), (InstrumentedContext.Listener)new LoggingListener())));
        TaskContext.Value value = evaluatingContext.evaluateTaskFrom(filePath);
        CompletableFuture future = new CompletableFuture();
        value.consume(future::complete);
        value.onFail(future::completeExceptionally);
        try {
            future.get(24L, TimeUnit.HOURS);
        }
        catch (ExecutionException | TimeoutException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

