/*
 * Decompiled with CFR 0.152.
 */
package io.rouz.flo.processor;

import io.rouz.flo.processor.Binding;
import io.rouz.flo.processor.CodeGen;
import io.rouz.flo.processor.ProcessorUtil;
import io.rouz.flo.processor.RootTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class TaskBindingProcessor
extends AbstractProcessor {
    static final String ROOT = "@" + RootTask.class.getSimpleName();
    private Types types;
    private Elements element;
    private Filer filer;
    private Messager messager;
    private ProcessorUtil util;
    private CodeGen codeGen;
    private final Map<String, List<Binding>> bindingsByPackage = new HashMap<String, List<Binding>>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.types = processingEnv.getTypeUtils();
        this.element = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.util = new ProcessorUtil(this.types, this.element, this.messager);
        this.codeGen = new CodeGen(this.util);
        this.messager.printMessage(Diagnostic.Kind.NOTE, TaskBindingProcessor.class.getSimpleName() + " loaded");
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotationTypes = new LinkedHashSet<String>();
        annotationTypes.add(RootTask.class.getCanonicalName());
        return annotationTypes;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Processing @" + typeElement.getSimpleName() + " annotation");
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (element.getKind() != ElementKind.METHOD) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "only methods can be annotated with " + ROOT, element);
                    return true;
                }
                Optional<Binding> binding = this.createBinding((ExecutableElement)element);
                binding.ifPresent(this::collectBinding);
            }
        }
        if (!this.bindingsByPackage.isEmpty()) {
            for (List list : this.bindingsByPackage.values()) {
                try {
                    this.codeGen.bindingFactory(list).writeTo(this.filer);
                }
                catch (IOException e) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write source for " + ROOT + " bindings: " + e);
                }
                catch (RuntimeException e) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Error during " + ROOT + " binding generation");
                }
            }
            this.bindingsByPackage.clear();
        }
        return true;
    }

    private void collectBinding(Binding binding) {
        PackageElement bindingPackage = this.element.getPackageOf(binding.method());
        this.bindingsByPackage.computeIfAbsent(bindingPackage.toString(), p -> new ArrayList()).add(binding);
    }

    private Optional<Binding> createBinding(ExecutableElement method) {
        Name name;
        if (!this.validate(method)) {
            return Optional.empty();
        }
        ArrayList<Binding.Argument> args = new ArrayList<Binding.Argument>();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "parameters:");
        for (VariableElement variableElement : method.getParameters()) {
            name = variableElement.getSimpleName();
            TypeMirror type = variableElement.asType();
            args.add(Binding.argument(name, type));
            this.messager.printMessage(Diagnostic.Kind.NOTE, "  name: " + name);
            this.messager.printMessage(Diagnostic.Kind.NOTE, "  type: " + type.toString());
            this.messager.printMessage(Diagnostic.Kind.NOTE, "  ---");
        }
        this.messager.printMessage(Diagnostic.Kind.NOTE, "---");
        TypeElement enclosingClass = this.util.enclosingClass(method);
        TypeMirror typeMirror = method.getReturnType();
        name = method.getSimpleName();
        return Optional.of(Binding.create(method, enclosingClass, typeMirror, name, args));
    }

    private boolean validate(ExecutableElement method) {
        TypeMirror returnType = method.getReturnType();
        Set<Modifier> methodModifiers = method.getModifiers();
        if (!this.types.isAssignable(returnType, this.util.taskWildcard())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ROOT + " annotated method must return a " + this.util.taskWildcard(), method);
            return false;
        }
        if (!methodModifiers.contains((Object)Modifier.STATIC)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ROOT + " annotated method must be static", method);
            return false;
        }
        if (methodModifiers.contains((Object)Modifier.PRIVATE)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ROOT + " annotated method must not be private", method);
            return false;
        }
        if (methodModifiers.contains((Object)Modifier.PROTECTED)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ROOT + " annotated method must not be protected", method);
            return false;
        }
        return true;
    }
}

