/*
 * Decompiled with CFR 0.152.
 */
package io.rouz.flo.processor;

import io.rouz.flo.Task;
import io.rouz.flo.processor.Binding;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class ProcessorUtil {
    final Types types;
    final Elements element;
    final Messager messager;

    ProcessorUtil(Types types, Elements element, Messager messager) {
        this.types = types;
        this.element = element;
        this.messager = messager;
    }

    PackageElement commonPackage(List<Binding> bindings) {
        class RecursiveMap
        extends LinkedHashMap<String, RecursiveMap> {
            RecursiveMap() {
            }
        }
        RecursiveMap packages = new RecursiveMap();
        for (Binding binding : bindings) {
            PackageElement packageElement = this.packageOf(binding.method());
            String[] parts = packageElement.getQualifiedName().toString().split("\\.");
            RecursiveMap node = packages;
            for (String part : parts) {
                node = node.computeIfAbsent(part, p -> new RecursiveMap());
            }
        }
        this.messager.printMessage(Diagnostic.Kind.NOTE, "package tree: " + packages);
        String common = "";
        RecursiveMap node = packages;
        while (node.size() == 1) {
            Map.Entry next = node.entrySet().iterator().next();
            common = common + (common.isEmpty() ? "" : ".") + (String)next.getKey();
            node = (RecursiveMap)next.getValue();
        }
        return this.element.getPackageElement(common);
    }

    DeclaredType taskWildcard() {
        TypeElement task = this.typeElement(Task.class);
        return this.types.getDeclaredType(task, this.types.getWildcardType(null, null));
    }

    DeclaredType mapStringString() {
        TypeElement map = this.typeElement(Map.class);
        TypeElement string = this.typeElement(String.class);
        return this.types.getDeclaredType(map, string.asType(), string.asType());
    }

    DeclaredType typeWithArgs(Class<?> clazz, Class<?> ... args) {
        TypeMirror[] typeArgs = (TypeMirror[])Arrays.asList(args).stream().map(this::typeElement).map(Element::asType).toArray(TypeMirror[]::new);
        return this.typeWithArgs(clazz, typeArgs);
    }

    DeclaredType typeWithArgs(Class<?> clazz, TypeMirror ... args) {
        TypeElement type = this.typeElement(clazz);
        return this.types.getDeclaredType(type, args);
    }

    TypeMirror refresh(TypeMirror typeMirror) {
        return this.element.getTypeElement(typeMirror.toString()).asType();
    }

    TypeMirror typeMirror(Class<?> clazz) {
        return this.typeElement(clazz).asType();
    }

    TypeElement typeElement(Class<?> clazz) {
        return this.element.getTypeElement(clazz.getCanonicalName());
    }

    PackageElement packageOf(Element element) {
        return this.element.getPackageOf(element);
    }

    TypeElement enclosingClass(Element element) {
        if (element.getKind() != ElementKind.CLASS) {
            return this.enclosingClass(element.getEnclosingElement());
        }
        return (TypeElement)element;
    }
}

