/*
 * Decompiled with CFR 0.152.
 */
package io.rouz.flo.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.rouz.flo.TaskConstructor;
import io.rouz.flo.processor.Binding;
import io.rouz.flo.processor.ProcessorUtil;
import io.rouz.flo.processor.TaskBindingProcessor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;

final class CodeGen {
    private static final AnnotationSpec GENERATED_ANNOTATION = AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{TaskBindingProcessor.class.getCanonicalName()}).build();
    private final ProcessorUtil util;

    CodeGen(ProcessorUtil util) {
        this.util = util;
    }

    JavaFile bindingFactory(List<Binding> bindings) {
        Name commonPackage = this.util.commonPackage(bindings).getQualifiedName();
        List taskConstructors = bindings.stream().map(this::taskConstructor).collect(Collectors.toList());
        TypeSpec.Builder factoryClassBuilder = TypeSpec.classBuilder((String)"FloRootTaskFactory").addAnnotation(GENERATED_ANNOTATION).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        bindings.stream().map(Binding::method).map(this.util::enclosingClass).forEachOrdered(arg_0 -> ((TypeSpec.Builder)factoryClassBuilder).addOriginatingElement(arg_0));
        factoryClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("// no instantiation", new Object[0]).build());
        taskConstructors.stream().map(this::taskConstructorStaticConstructor).forEachOrdered(arg_0 -> ((TypeSpec.Builder)factoryClassBuilder).addMethod(arg_0));
        factoryClassBuilder.addMethod(this.optHelper());
        taskConstructors.stream().forEachOrdered(arg_0 -> ((TypeSpec.Builder)factoryClassBuilder).addType(arg_0));
        return JavaFile.builder((String)commonPackage.toString(), (TypeSpec)factoryClassBuilder.build()).skipJavaLangImports(true).build();
    }

    private MethodSpec taskConstructorStaticConstructor(TypeSpec taskConstructor) {
        return MethodSpec.methodBuilder((String)taskConstructor.name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)taskConstructor.superinterfaces.get(0)).addStatement("return new $N()", new Object[]{taskConstructor}).build();
    }

    private TypeSpec taskConstructor(Binding binding) {
        this.util.messager.printMessage(Diagnostic.Kind.NOTE, "Binding " + binding);
        Name enclosingName = binding.enclosingClass().getSimpleName();
        String taskName = CodeGen.capitalize(binding.name());
        DeclaredType taskType = (DeclaredType)binding.returnType();
        TypeMirror taskArg = taskType.getTypeArguments().get(0);
        List<Binding.Argument> arguments = binding.arguments();
        MethodSpec name = MethodSpec.methodBuilder((String)"name").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{enclosingName + "." + binding.name()}).build();
        MethodSpec.Builder createBuilder = MethodSpec.methodBuilder((String)"create").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)taskType)).addParameter(String[].class, "args", new Modifier[0]).varargs().addStatement("final $T parser = parser()", new Object[]{OptionParser.class}).addStatement("final $T parse = parser.parse(args)", new Object[]{OptionSet.class}).addCode("\n", new Object[0]);
        for (Binding.Argument argument : arguments) {
            if (this.util.types.isSameType(this.util.types.getPrimitiveType(TypeKind.BOOLEAN), argument.type())) {
                createBuilder.addStatement("final $T $N = parse.has($S)", new Object[]{argument.type(), argument.name(), argument.name()});
                continue;
            }
            createBuilder.addStatement("final $T $N = ($T) $T.requireNonNull(parse.valueOf($S))", new Object[]{argument.type(), argument.name(), argument.type(), Objects.class, argument.name()});
        }
        String callArgs = arguments.stream().map(Binding.Argument::name).collect(Collectors.joining(", "));
        MethodSpec create = createBuilder.addCode("\n", new Object[0]).addStatement("return $N.$N($L)", new Object[]{enclosingName, binding.name(), callArgs}).build();
        MethodSpec.Builder parserBuilder = MethodSpec.methodBuilder((String)"parser").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(OptionParser.class).addStatement("final $T parser = new $T()", new Object[]{OptionParser.class, OptionParser.class}).addCode("\n", new Object[0]);
        for (Binding.Argument argument : arguments) {
            parserBuilder.addStatement("opt($S, $T.class, parser)", new Object[]{argument.name(), argument.type()});
        }
        parserBuilder.addCode("\n", new Object[0]).addStatement("parser.acceptsAll($T.asList($S, $S)).forHelp()", new Object[]{Arrays.class, "h", "help"}).addCode("\n", new Object[0]).addStatement("return parser", new Object[0]);
        MethodSpec parser = parserBuilder.build();
        return TypeSpec.classBuilder((String)(enclosingName + "_" + taskName)).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addSuperinterface(TypeName.get((TypeMirror)this.util.typeWithArgs(TaskConstructor.class, taskArg))).addMethod(name).addMethod(create).addMethod(parser).build();
    }

    private MethodSpec optHelper() {
        return MethodSpec.methodBuilder((String)"opt").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(TypeName.get(String.class), "name", new Modifier[0]).addParameter(TypeName.get(Class.class), "type", new Modifier[0]).addParameter(TypeName.get(OptionParser.class), "parser", new Modifier[0]).addStatement("final $T isFlag = $T.class.equals(type)", new Object[]{Boolean.TYPE, Boolean.TYPE}).addStatement("final $T spec = (isFlag)\n ? parser.accepts(name, $S)\n : parser.accepts(name)", new Object[]{OptionSpecBuilder.class, "(default: false)"}).addCode("\n", new Object[0]).beginControlFlow("if (!isFlag)", new Object[0]).addStatement("spec.withRequiredArg().ofType(type).describedAs(name).required()", new Object[0]).endControlFlow().build();
    }

    private static String capitalize(Name name) {
        return Character.toUpperCase(name.charAt(0)) + name.toString().substring(1);
    }
}

