/*
 * Decompiled with CFR 0.152.
 */
package io.rouz.flo.gen;

import io.rouz.flo.gen.GenerateTaskBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.trimou.engine.MustacheEngine;
import org.trimou.engine.MustacheEngineBuilder;
import org.trimou.engine.locator.ClassPathTemplateLocator;
import org.trimou.engine.locator.TemplateLocator;
import org.trimou.engine.resolver.MapResolver;
import org.trimou.engine.resolver.ReflectionResolver;
import org.trimou.engine.resolver.Resolver;
import org.trimou.util.ImmutableMap;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ApiGeneratorProcessor
extends AbstractProcessor {
    static final String ANNOTATION = "@" + GenerateTaskBuilder.class.getSimpleName();
    private Types types;
    private Elements elements;
    private Filer filer;
    private Messager messager;
    private MustacheEngine engine;
    private Element processingElement;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.engine = MustacheEngineBuilder.newBuilder().addResolver((Resolver)new MapResolver()).addResolver((Resolver)new ReflectionResolver()).addTemplateLocator((TemplateLocator)ClassPathTemplateLocator.builder((int)1).setClassLoader(this.getClass().getClassLoader()).setSuffix("mustache").build()).build();
        this.messager.printMessage(Diagnostic.Kind.NOTE, ApiGeneratorProcessor.class.getSimpleName() + " loaded");
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotationTypes = new LinkedHashSet<String>();
        annotationTypes.add(GenerateTaskBuilder.class.getCanonicalName());
        return annotationTypes;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (element.getKind() != ElementKind.INTERFACE) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Only interfaces can be annotated with " + ANNOTATION, element);
                    return true;
                }
                this.processingElement = element;
                GenerateTaskBuilder genTaskBuilder = element.getAnnotation(GenerateTaskBuilder.class);
                TypeElement templateElement = (TypeElement)element;
                try {
                    Name packageName = this.elements.getPackageOf(templateElement).getQualifiedName();
                    String interfaceName = templateElement.getSimpleName().toString().replaceAll("Template$", "");
                    this.writeApiInterface(genTaskBuilder, packageName, interfaceName);
                    this.writeApiImplementation(genTaskBuilder, packageName, interfaceName);
                }
                catch (IOException e) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write source for " + ANNOTATION + " bindings: " + e);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Error during " + ANNOTATION + " binding generation");
                }
            }
        }
        return true;
    }

    private void writeApiInterface(GenerateTaskBuilder genTaskBuilder, Name packageName, String interfaceName) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("packageName", packageName);
        data.put("interfaceName", interfaceName);
        data.put("genFn", IntStream.rangeClosed(0, genTaskBuilder.upTo()).mapToObj(this::fn).toArray());
        data.put("genBuilder", IntStream.range(1, genTaskBuilder.upTo()).mapToObj(this::builder).toArray());
        String output = this.engine.getMustache("TaskBuilder").render(data);
        String outputScala = this.engine.getMustache("ScalaApi").render(data);
        if (!genTaskBuilder.scala()) {
            String fileName = packageName + "." + interfaceName;
            JavaFileObject filerSourceFile = this.filer.createSourceFile(fileName, this.processingElement);
            try (Writer writer = filerSourceFile.openWriter();){
                writer.write(output);
            }
        }
        FileObject scalaFile = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, packageName, "ScalaApi.scala", this.processingElement);
        try (Writer writer = scalaFile.openWriter();){
            writer.write(outputScala);
        }
    }

    private void writeApiImplementation(GenerateTaskBuilder genTaskBuilder, Name packageName, String interfaceName) throws IOException {
        String implClassName = interfaceName + "Impl";
        int n = genTaskBuilder.scala() ? genTaskBuilder.upTo() : genTaskBuilder.upTo() - 1;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("packageName", packageName);
        data.put("interfaceName", interfaceName);
        data.put("implClassName", implClassName);
        data.put("genBuilder", IntStream.range(1, n).mapToObj(this::builderImpl).toArray());
        data.put("lastArity", n);
        data.put("lastArityPlus", n + 1);
        data.put("lastTypeArgs", this.typeArgs(n));
        data.put("lastTypeArg", this.letters(n + 1).skip(n).findFirst().get());
        data.put("lastArguments", this.arguments(n));
        String output = this.engine.getMustache("TaskBuilderImpl").render(data);
        String outputScala = this.engine.getMustache("ScalaApiImpl").render(data);
        if (!genTaskBuilder.scala()) {
            String fileName = packageName + "." + implClassName;
            JavaFileObject filerSourceFile = this.filer.createSourceFile(fileName, this.processingElement);
            try (Writer writer = filerSourceFile.openWriter();){
                writer.write(output);
            }
        }
        FileObject scalaFile = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, packageName, "ScalaApiImpl.scala", this.processingElement);
        try (Writer writer = scalaFile.openWriter();){
            writer.write(outputScala);
        }
    }

    private Map<String, Object> builderImpl(int n) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arity", n);
        map.put("arityPlus", n + 1);
        map.put("arityMinus", n - 1);
        map.put("nextArg", this.letters(n + 1).skip(n).findFirst().get());
        map.put("typeArgs", this.typeArgs(n));
        map.put("typeArgsNumA", this.typeArgsNum(n, "A"));
        map.put("typeArgsNumAMinus", this.typeArgsNum(n - 1, "A"));
        map.put("arguments", this.arguments(n));
        map.put("argumentsNum", this.arguments(n, "a"));
        map.put("typeArgsPsJ", this.pSquared(n, "%pJ%n"));
        map.put("argumentsPsConv", this.pSquared(n, "%pc%n(a%n)"));
        return map;
    }

    private Map<String, Object> builder(int n) {
        return ImmutableMap.of((Object)"arity", (Object)n, (Object)"arityPlus", (Object)(n + 1), (Object)"nextArg", (Object)this.letters(n + 1).skip(n).findFirst().get(), (Object)"typeArgs", (Object)this.typeArgs(n), (Object)"typeArgsMinus", (Object)this.typeArgs(n - 1));
    }

    private Map<String, Object> fn(int n) {
        return ImmutableMap.of((Object)"arity", (Object)n, (Object)"typeArgs", (Object)this.typeArgs(n), (Object)"jdkInterface", (Object)this.jdkInterface(n), (Object)"parameters", (Object)this.parameters(n));
    }

    private Stream<String> letters(int n) {
        return IntStream.range(0, n).mapToObj(i -> Character.toString((char)(65 + i)));
    }

    private Stream<String> numbers(int n, String letter) {
        return IntStream.range(1, n + 1).mapToObj(i -> letter + i);
    }

    private String typeArgs(int n) {
        return this.letters(n).collect(Collectors.joining(", "));
    }

    private String typeArgsNum(int n, String letter) {
        return this.numbers(n, letter).collect(Collectors.joining(", "));
    }

    private String parameters(int n) {
        return this.letters(n).map(l -> l + " " + l.toLowerCase()).collect(Collectors.joining(", "));
    }

    private String arguments(int n) {
        return this.letters(n).map(String::toLowerCase).collect(Collectors.joining(", "));
    }

    private String arguments(int n, String letter) {
        return this.numbers(n, letter).collect(Collectors.joining(", "));
    }

    private String pSquared(int n, String template) {
        return IntStream.range(1, n + 1).mapToObj(i -> template.replaceAll("%p", this.repeat("p.", n - i)).replaceAll("%n", Integer.toString(i))).collect(Collectors.joining(", "));
    }

    private String repeat(String str, int n) {
        return IntStream.range(0, n).mapToObj(i -> str).collect(Collectors.joining());
    }

    private String jdkInterface(int n) {
        switch (n) {
            case 0: {
                return "Supplier<Z>, ";
            }
            case 1: {
                return "Function<A, Z>, ";
            }
            case 2: {
                return "BiFunction<A, B, Z>, ";
            }
        }
        return "";
    }
}

