/*
 * Decompiled with CFR 0.152.
 */
package rocketdroid.gradle.dynamic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import rocketdroid.gradle.dynamic.Log;
import rocketdroid.gradle.dynamic.Utils;

public class Repo {
    public static final String ENV_KEY = "ROCKETDROID_REPO";
    public static final String PRODUCTION_REPO = "http://www.rocketdroid.io/repo/";
    public static final long SECONDS = 1000L;
    public static final long CHECK_TIME_DEVELOPMENT = 10000L;
    public static final long CHECK_TIME_PRODUCTION = 21600000L;
    public static final Repo INSTANCE = new Repo(new File(new File(System.getProperty("user.home"), ".rocketdroid"), "libs"), Repo.getRepo(), Repo.getCheckTimeInMs());
    public final File cache;
    public final URI repo;
    public final long checkTimeInMs;

    public static URI getRepo() {
        try {
            URI productionUri = new URL(PRODUCTION_REPO).toURI();
            String repoVar = System.getenv(ENV_KEY);
            if (repoVar == null) {
                return productionUri;
            }
            File mavenRepo = new File(repoVar, "repo");
            if (!mavenRepo.exists()) {
                return productionUri;
            }
            return mavenRepo.toURI();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static long getCheckTimeInMs() {
        return System.getenv(ENV_KEY) != null ? 10000L : 21600000L;
    }

    public Repo(File cache, URI repo, long checkTimeInMs) {
        this.cache = cache;
        this.repo = repo;
        this.checkTimeInMs = checkTimeInMs;
    }

    public File getArtifact(String artifact) {
        this.cache.mkdirs();
        File metaFile = new File(this.cache, artifact + "-metadata.xml");
        File artifactFile = new File(this.cache, artifact + ".jar");
        try {
            if (Repo.updateMetaIfNeeded(artifact, this.repo, metaFile, this.checkTimeInMs)) {
                Repo.downloadArtifact(artifact, this.repo, metaFile, artifactFile);
            }
        }
        catch (IOException e) {
            Log.warn("common/repo", e);
        }
        return artifactFile.exists() ? artifactFile : null;
    }

    public static boolean updateMetaIfNeeded(String artifact, URI repo, File metaFile, long checkTime) throws IOException {
        URI metaUri;
        byte[] after;
        Log.info("common/repo", "update meta for " + artifact + " from " + repo + " to " + metaFile);
        if (metaFile.exists() && System.currentTimeMillis() - metaFile.lastModified() < checkTime) {
            Log.info("common/repo", "less than " + checkTime + " from last meta update");
            return false;
        }
        byte[] before = metaFile.exists() ? Utils.getBytes(metaFile) : null;
        if (!Arrays.equals(before, after = Utils.getUriContent(metaUri = repo.resolve("io/rocketdroid/" + artifact + "/1.0-SNAPSHOT/maven-metadata.xml")))) {
            Utils.dump(after, metaFile);
            return true;
        }
        metaFile.setLastModified(System.currentTimeMillis());
        return false;
    }

    public static void downloadArtifact(String artifact, URI repo, File metaFile, File artifactFile) throws IOException {
        Log.info("common/repo", "download artifact " + artifact + " from " + repo + " to " + artifactFile);
        byte[] metadata = Utils.getBytes(metaFile);
        String timestamp = Repo.between(new String(metadata), "<timestamp>", "</timestamp>");
        String buildNumber = Repo.between(new String(metadata), "<buildNumber>", "</buildNumber>");
        URI artifactUri = repo.resolve("io/rocketdroid/" + artifact + "/1.0-SNAPSHOT/" + artifact + "-1.0-" + timestamp + "-" + buildNumber + ".jar");
        Utils.dump(Utils.getUriContent(artifactUri), artifactFile);
    }

    private static String between(String content, String before, String after) {
        if (!content.contains(before)) {
            return null;
        }
        if (!(content = content.substring(content.indexOf(before) + before.length())).contains(after)) {
            return null;
        }
        content = content.substring(0, content.indexOf(after));
        return content;
    }
}

