/*
 * Decompiled with CFR 0.152.
 */
package rocketdroid.gradle.dynamic;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import rocketdroid.gradle.dynamic.Log;

public class DynamicPlugin
implements Plugin<Project> {
    public final Plugin<Project> innerPlugin;

    public DynamicPlugin(File jar, String className) {
        this.innerPlugin = DynamicPlugin.createInnerPlugin(jar, className);
    }

    private static Plugin<Project> createInnerPlugin(File jar, String className) {
        if (jar == null || !jar.isFile()) {
            return null;
        }
        try {
            URLClassLoader cl = new URLClassLoader(new URL[]{jar.toURI().toURL()}, DynamicPlugin.class.getClassLoader());
            Class<?> clazz = Class.forName(className, true, cl);
            return (Plugin)clazz.newInstance();
        }
        catch (Throwable t) {
            Log.warn("gradle/dynamic", t);
            return null;
        }
    }

    public void apply(Project target) {
        if (this.innerPlugin != null) {
            try {
                this.innerPlugin.apply((Object)target);
            }
            catch (Throwable t) {
                Log.warn("gradle/dynamic", t);
            }
        }
    }
}

