package rocketdroid.gradle.dynamic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class Log {
    private static final Object LOCK = new Object();
    private static final List<String> MSGS = new ArrayList<String>();

    static {
        Thread t = new Thread(new Runnable() {
            @Override
            public void run() {
                while (true) {
                    List<String> toDump;
                    synchronized (LOCK) {
                        toDump = new ArrayList<String>(MSGS);
                        MSGS.clear();
                    }
                    try {
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(new File(new File(System.getProperty("user.home"), ".rocketdroid"), "log.txt"), true)));
                        for (String msg : toDump) {
                            out.println(msg);
                        }
                        out.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }

                    try {
                        Thread.sleep(100);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public static void info(String tag, String msg) {
        log(tag, "INFO", msg);
    }

    public static void info(String tag, Throwable t) {
        log(tag, "INFO", t);
    }

    public static void warn(String tag, String msg) {
        log(tag, "WARN", msg);
    }

    public static void warn(String tag, Throwable t) {
        log(tag, "WARN", t);
    }

    private static void log(String tag, String level, String msg) {
        log(tag, level, System.currentTimeMillis(), msg);
    }

    private static void log(String tag, String level, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String stackTrace = sw.toString();

        long time = System.currentTimeMillis();
        for (String line : stackTrace.split("\\n")) {
            log(tag, level, time, line);
        }
    }

    private static void log(String tag, String level, long time, String msg) {
        synchronized (LOCK) {
            MSGS.add(time + ": [" + tag + "] " + level + " " + msg);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        Exception e = new RuntimeException();
        e.fillInStackTrace();
        info("test/test", e);
        Thread.sleep(1000);
    }
}

