/*
 * Decompiled with CFR 0.152.
 */
package rocketdroid.gradle.dynamic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class Log {
    private static final Object LOCK = new Object();
    private static final List<String> MSGS = new ArrayList<String>();

    public static void info(String tag, String msg) {
        Log.log(tag, "INFO", msg);
    }

    public static void info(String tag, Throwable t) {
        Log.log(tag, "INFO", t);
    }

    public static void warn(String tag, String msg) {
        Log.log(tag, "WARN", msg);
    }

    public static void warn(String tag, Throwable t) {
        Log.log(tag, "WARN", t);
    }

    private static void log(String tag, String level, String msg) {
        Log.log(tag, level, System.currentTimeMillis(), msg);
    }

    private static void log(String tag, String level, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String stackTrace = sw.toString();
        long time = System.currentTimeMillis();
        for (String line : stackTrace.split("\\n")) {
            Log.log(tag, level, time, line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(String tag, String level, long time, String msg) {
        Object object = LOCK;
        synchronized (object) {
            MSGS.add(time + ": [" + tag + "] " + level + " " + msg);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        RuntimeException e = new RuntimeException();
        e.fillInStackTrace();
        Log.info("test/test", e);
        Thread.sleep(1000L);
    }

    static {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    ArrayList toDump;
                    Object object = LOCK;
                    synchronized (object) {
                        toDump = new ArrayList(MSGS);
                        MSGS.clear();
                    }
                    try {
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(new File(new File(System.getProperty("user.home"), ".rocketdroid"), "log.txt"), true)));
                        for (String msg : toDump) {
                            out.println(msg);
                        }
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }
}

