package rocketdroid.gradle.dynamic;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Utils {
    public static byte[] isToBytes(InputStream is) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        int nRead;
        byte[] data = new byte[16384];

        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }

        buffer.flush();

        return buffer.toByteArray();
    }

    public static void dump(byte[] source, File target) throws IOException {
        OutputStream os = new FileOutputStream(target);
        os.write(source);
        os.close();
    }

    public static void dump(ZipFile file, ZipEntry entry, File target) throws IOException {
        dump(getBytesAndClose(file.getInputStream(entry)), target);
    }

    public static byte[] getBytes(File file) throws IOException {
        return getBytesAndClose(new FileInputStream(file));
    }

    public static byte[] getBytesAndClose(InputStream stream) throws IOException {
        byte[] content = Utils.isToBytes(stream);
        stream.close();
        return content;
    }

    public static void addEntry(ZipOutputStream zip, String name, File file) throws IOException {
        ZipEntry e = new ZipEntry(name);
        zip.putNextEntry(e);
        zip.write(getBytes(file));
        zip.closeEntry();
    }

    public static byte[] getUriContent(URI uri) throws IOException {
        InputStream is = uri.toURL().openStream();
        try {
            return Utils.isToBytes(is);
        } catch (IOException e) {
            throw e;
        } finally {
            is.close();
        }
    }
}
