package rocketdroid.gradle.dynamic;

import org.gradle.api.Plugin;
import org.gradle.api.Project;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public class DynamicPlugin implements Plugin<Project> {
    public final Plugin<Project> innerPlugin;

    public DynamicPlugin(File jar, String className) {
        innerPlugin = createInnerPlugin(jar, className);
    }

    private static Plugin<Project> createInnerPlugin(File jar, String className) {
        if (jar == null || !jar.isFile()) return null;
        try {
            ClassLoader cl = new URLClassLoader(new URL[]{jar.toURI().toURL()}, DynamicPlugin.class.getClassLoader());
            Class<?> clazz = Class.forName(className, true, cl);
            return (Plugin<Project>) clazz.newInstance();
        } catch (Throwable t) {
            Log.warn("gradle/dynamic", t);
            return null;
        }
    }

    @Override
    public void apply(Project target) {
        if (innerPlugin != null) {
            try {
                innerPlugin.apply(target);
            } catch (Throwable t) {
                Log.warn("gradle/dynamic", t);
            }
        }
    }
}
