/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat.rpc;

import io.rocketchat.common.data.rpc.RPC;
import io.rocketchat.common.utils.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveChatBasicRPC
extends RPC {
    public static String visitorToken = Utils.generateRandomHexToken(16);
    private static final String GET_INITIAL_DATA = "livechat:getInitialData";
    private static final String REGISTER_GUEST = "livechat:registerGuest";
    private static final String LOGIN = "login";
    private static final String GET_AGENT_DATA = "livechat:getAgentData";
    private static final String CLOSE_CONVERSATION = "livechat:closeByVisitor";
    private static final String SEND_OFFLINE_MESSAGE = "livechat:sendOfflineMessage";

    public static String getInitialData(int integer) {
        return LiveChatBasicRPC.getRemoteMethodObject(integer, GET_INITIAL_DATA, visitorToken).toString();
    }

    public static String registerGuest(int integer, String name, String email, String dept) {
        JSONObject object = new JSONObject();
        try {
            object.put("token", (Object)visitorToken);
            object.put("name", (Object)name);
            object.put("email", (Object)email);
            object.put("department", (Object)dept);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return LiveChatBasicRPC.getRemoteMethodObject(integer, REGISTER_GUEST, object).toString();
    }

    public static String login(int integer, String token) {
        JSONObject object = new JSONObject();
        try {
            object.put("resume", (Object)token);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return LiveChatBasicRPC.getRemoteMethodObject(integer, LOGIN, object).toString();
    }

    public static String getAgentData(int integer, String roomId) {
        return LiveChatBasicRPC.getRemoteMethodObject(integer, GET_AGENT_DATA, roomId).toString();
    }

    public static String closeConversation(int integer, String roomId) {
        return LiveChatBasicRPC.getRemoteMethodObject(integer, CLOSE_CONVERSATION, roomId).toString();
    }

    public static String sendOfflineMessage(int integer, String name, String email, String message) {
        JSONObject object = new JSONObject();
        try {
            object.put("name", (Object)name);
            object.put("email", (Object)email);
            object.put("message", (Object)message);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return LiveChatBasicRPC.getRemoteMethodObject(integer, SEND_OFFLINE_MESSAGE, object).toString();
    }
}

