/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat;

import io.rocketchat.common.data.rpc.RPC;
import io.rocketchat.common.listener.ConnectListener;
import io.rocketchat.common.listener.SubscribeListener;
import io.rocketchat.common.listener.TypingListener;
import io.rocketchat.common.network.Socket;
import io.rocketchat.common.utils.Utils;
import io.rocketchat.livechat.callback.AgentListener;
import io.rocketchat.livechat.callback.AuthListener;
import io.rocketchat.livechat.callback.InitialDataListener;
import io.rocketchat.livechat.callback.LoadHistoryListener;
import io.rocketchat.livechat.callback.MessageListener;
import io.rocketchat.livechat.middleware.LiveChatMiddleware;
import io.rocketchat.livechat.middleware.LiveChatStreamMiddleware;
import io.rocketchat.livechat.rpc.LiveChatBasicRPC;
import io.rocketchat.livechat.rpc.LiveChatHistoryRPC;
import io.rocketchat.livechat.rpc.LiveChatSendMsgRPC;
import io.rocketchat.livechat.rpc.LiveChatSubRPC;
import io.rocketchat.livechat.rpc.LiveChatTypingRPC;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveChatAPI
extends Socket {
    private AtomicInteger integer = new AtomicInteger(1);
    private String sessionId;
    private JSONObject userInfo;
    private ConnectListener connectListener;
    private LiveChatMiddleware liveChatMiddleware = new LiveChatMiddleware();
    private LiveChatStreamMiddleware liveChatStreamMiddleware = new LiveChatStreamMiddleware();

    public LiveChatAPI(String url) {
        super(url);
    }

    public void setConnectListener(ConnectListener connectListener) {
        this.connectListener = connectListener;
    }

    public void getInitialData(InitialDataListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.GET_INITIAL_DATA);
        this.sendDataInBackground(LiveChatBasicRPC.getInitialData(uniqueID));
    }

    public void registerGuest(String name, String email, String dept, AuthListener.RegisterListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.REGISTER);
        this.sendDataInBackground(LiveChatBasicRPC.registerGuest(uniqueID, name, email, dept));
    }

    public void login(String token, AuthListener.LoginListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.LOGIN);
        this.sendDataInBackground(LiveChatBasicRPC.login(uniqueID, token));
    }

    public void sendOfflineMessage(String name, String email, String message) {
        int uniqueID = this.integer.getAndIncrement();
        this.sendDataInBackground(LiveChatBasicRPC.sendOfflineMessage(uniqueID, name, email, message));
    }

    public void sendOfflineMessage(String name, String email, String message, MessageListener.OfflineMessageListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.SEND_OFFLINE_MESSAGE);
        this.sendDataInBackground(LiveChatBasicRPC.sendOfflineMessage(uniqueID, name, email, message));
    }

    private void getChatHistory(String roomID, int limit, Date oldestMessageTimestamp, Date lasttimestamp, LoadHistoryListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.GET_CHAT_HISTORY);
        this.sendDataInBackground(LiveChatHistoryRPC.loadHistory(uniqueID, roomID, oldestMessageTimestamp, limit, lasttimestamp));
    }

    private void getAgentData(String roomId, AgentListener.AgentDataListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.GET_AGENT_DATA);
        this.sendDataInBackground(LiveChatBasicRPC.getAgentData(uniqueID, roomId));
    }

    private void sendMessage(String msgId, String roomID, String message, String token) {
        int uniqueID = this.integer.getAndIncrement();
        this.sendDataInBackground(LiveChatSendMsgRPC.sendMessage(uniqueID, msgId, roomID, message, token));
    }

    private void sendMessage(String msgId, String roomID, String message, String token, MessageListener.MessageAckListener messageAckListener) {
        int uniqueID = this.integer.getAndIncrement();
        this.liveChatMiddleware.createCallback(uniqueID, messageAckListener, LiveChatMiddleware.ListenerType.SEND_MESSAGE);
        this.sendDataInBackground(LiveChatSendMsgRPC.sendMessage(uniqueID, msgId, roomID, message, token));
    }

    private void sendIsTyping(String roomId, String username, Boolean istyping) {
        int uniqueID = this.integer.getAndIncrement();
        this.sendDataInBackground(LiveChatTypingRPC.streamNotifyRoom(uniqueID, roomId, username, istyping));
    }

    private void subscribeRoom(String roomID, Boolean enable, SubscribeListener subscribeListener, MessageListener.SubscriptionListener listener) {
        String uniqueID = Utils.shortUUID();
        this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeListener);
        this.liveChatStreamMiddleware.subscribeRoom(listener);
        this.sendDataInBackground(LiveChatSubRPC.streamRoomMessages(uniqueID, roomID, enable));
    }

    private void subscribeLiveChatRoom(String roomID, Boolean enable, SubscribeListener subscribeListener, AgentListener.AgentConnectListener agentConnectListener) {
        String uniqueID = Utils.shortUUID();
        this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeListener);
        this.liveChatStreamMiddleware.subscribeLiveChatRoom(agentConnectListener);
        this.sendDataInBackground(LiveChatSubRPC.streamLivechatRoom(uniqueID, roomID, enable));
    }

    private void subscribeTyping(String roomID, Boolean enable, SubscribeListener subscribeListener, TypingListener listener) {
        String uniqueID = Utils.shortUUID();
        this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeListener);
        this.liveChatStreamMiddleware.subscribeTyping(listener);
        this.sendDataInBackground(LiveChatSubRPC.subscribeTyping(uniqueID, roomID, enable));
    }

    private void closeConversation(String roomId) {
        int uniqueID = this.integer.getAndIncrement();
        this.sendDataInBackground(LiveChatBasicRPC.closeConversation(uniqueID, roomId));
    }

    public void connect(ConnectListener connectListener) {
        this.createSocket();
        this.connectListener = connectListener;
        super.connectAsync();
    }

    @Override
    protected void onConnected() {
        this.integer.set(1);
        this.sendDataInBackground(LiveChatBasicRPC.ConnectObject());
        super.onConnected();
    }

    @Override
    protected void onTextMessage(String text) throws Exception {
        JSONObject object = new JSONObject(text);
        switch (RPC.parse(object.optString("msg"))) {
            case PING: {
                this.sendDataInBackground("{\"msg\":\"pong\"}");
                break;
            }
            case CONNECTED: {
                this.sessionId = object.optString("session");
                if (this.connectListener == null) break;
                this.connectListener.onConnect(this.sessionId);
                break;
            }
            case ADDED: {
                if (!object.optString("collection").equals("users")) break;
                this.userInfo = object.optJSONObject("fields");
                break;
            }
            case RESULT: {
                this.liveChatMiddleware.processCallback(Long.valueOf(object.optString("id")), object);
                break;
            }
            case READY: {
                this.liveChatStreamMiddleware.processSubSuccess(object);
                break;
            }
            case CHANGED: {
                this.liveChatStreamMiddleware.processCallback(object);
                break;
            }
        }
        super.onTextMessage(text);
    }

    @Override
    protected void onConnectError(Exception websocketException) {
        if (this.connectListener != null) {
            this.connectListener.onConnectError(websocketException);
        }
        super.onConnectError(websocketException);
    }

    @Override
    protected void onDisconnected(boolean closedByServer) {
        if (this.connectListener != null) {
            this.connectListener.onDisconnect(closedByServer);
        }
        super.onDisconnected(closedByServer);
    }

    public ChatRoom createRoom(String userID, String authToken) {
        String userName = null;
        if (this.userInfo != null) {
            userName = this.userInfo.optString("username");
        }
        String visitorToken = LiveChatBasicRPC.visitorToken;
        String roomID = Utils.shortUUID();
        return new ChatRoom(userName, roomID, userID, visitorToken, authToken);
    }

    public ChatRoom createRoom(String s) {
        return new ChatRoom(s);
    }

    public class ChatRoom {
        String userName;
        String roomId;
        String userId;
        String visitorToken;
        String authToken;

        public ChatRoom(String userName, String roomId, String userId, String visitorToken, String authToken) {
            this.userName = userName;
            this.roomId = roomId;
            this.userId = userId;
            this.visitorToken = visitorToken;
            this.authToken = authToken;
        }

        public ChatRoom(String s) {
            try {
                JSONObject object = new JSONObject(s);
                this.userName = object.getString("userName");
                this.roomId = object.getString("roomId");
                this.userId = object.getString("userId");
                this.visitorToken = object.getString("visitorToken");
                this.authToken = object.getString("authToken");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        public void login(AuthListener.LoginListener listener) {
            LiveChatAPI.this.login(this.authToken, listener);
        }

        public void getChatHistory(int limit, Date oldestMessageTimestamp, Date lasttimestamp, LoadHistoryListener listener) {
            LiveChatAPI.this.getChatHistory(this.roomId, limit, oldestMessageTimestamp, lasttimestamp, listener);
        }

        public void getAgentData(AgentListener.AgentDataListener listener) {
            LiveChatAPI.this.getAgentData(this.roomId, listener);
        }

        public String sendMessage(String message) {
            String uuid = Utils.shortUUID();
            LiveChatAPI.this.sendMessage(uuid, this.roomId, message, this.visitorToken);
            return uuid;
        }

        public String sendMessage(String message, MessageListener.MessageAckListener messageAckListener) {
            String uuid = Utils.shortUUID();
            LiveChatAPI.this.sendMessage(uuid, this.roomId, message, this.visitorToken, messageAckListener);
            return uuid;
        }

        public void sendIsTyping(Boolean istyping) {
            LiveChatAPI.this.sendIsTyping(this.roomId, this.userName, istyping);
        }

        public void subscribeRoom(SubscribeListener subscribeListener, MessageListener.SubscriptionListener listener) {
            LiveChatAPI.this.subscribeRoom(this.roomId, false, subscribeListener, listener);
        }

        public void subscribeLiveChatRoom(SubscribeListener subscribeListener, AgentListener.AgentConnectListener agentConnectListener) {
            LiveChatAPI.this.subscribeLiveChatRoom(this.roomId, false, subscribeListener, agentConnectListener);
        }

        public void subscribeTyping(SubscribeListener subscribeListener, TypingListener listener) {
            LiveChatAPI.this.subscribeTyping(this.roomId, false, subscribeListener, listener);
        }

        public void closeConversation() {
            LiveChatAPI.this.closeConversation(this.roomId);
        }

        public String getUserName() {
            return this.userName;
        }

        public String getRoomId() {
            return this.roomId;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getVisitorToken() {
            return this.visitorToken;
        }

        public String getAuthToken() {
            return this.authToken;
        }

        public String toString() {
            return "{\"userName\":\"" + this.userName + '\"' + ",\"roomId\":\"" + this.roomId + '\"' + ",\"userId\":\"" + this.userId + '\"' + ",\"visitorToken\":\"" + this.visitorToken + '\"' + ",\"authToken\":\"" + this.authToken + '\"' + '}';
        }
    }
}

