/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat.middleware;

import io.rocketchat.common.data.model.ErrorObject;
import io.rocketchat.common.listener.Listener;
import io.rocketchat.livechat.callback.AgentListener;
import io.rocketchat.livechat.callback.AuthListener;
import io.rocketchat.livechat.callback.InitialDataListener;
import io.rocketchat.livechat.callback.LoadHistoryListener;
import io.rocketchat.livechat.callback.MessageListener;
import io.rocketchat.livechat.model.AgentObject;
import io.rocketchat.livechat.model.GuestObject;
import io.rocketchat.livechat.model.LiveChatConfigObject;
import io.rocketchat.livechat.model.LiveChatMessage;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class LiveChatMiddleware {
    private ConcurrentHashMap<Long, Object[]> callbacks = new ConcurrentHashMap();

    public void createCallback(long i, Listener listener, ListenerType type) {
        this.callbacks.put(i, new Object[]{listener, type});
    }

    public void processCallback(long i, JSONObject object) {
        if (this.callbacks.containsKey(i)) {
            Object[] objects = this.callbacks.remove(i);
            Listener listener = (Listener)objects[0];
            ListenerType type = (ListenerType)((Object)objects[1]);
            Object result = object.opt("result");
            switch (type) {
                case GET_INITIAL_DATA: {
                    InitialDataListener dataListener = (InitialDataListener)listener;
                    if (result == null) {
                        ErrorObject errorObject = new ErrorObject(object.optJSONObject("error"));
                        dataListener.onInitialData(null, errorObject);
                        break;
                    }
                    LiveChatConfigObject liveChatConfigObject = new LiveChatConfigObject((JSONObject)result);
                    dataListener.onInitialData(liveChatConfigObject, null);
                    break;
                }
                case REGISTER: {
                    AuthListener.RegisterListener registerListener = (AuthListener.RegisterListener)listener;
                    if (result == null) {
                        ErrorObject errorObject = new ErrorObject(object.optJSONObject("error"));
                        registerListener.onRegister(null, errorObject);
                        break;
                    }
                    GuestObject guestObject = new GuestObject((JSONObject)result);
                    registerListener.onRegister(guestObject, null);
                    break;
                }
                case LOGIN: {
                    AuthListener.LoginListener loginListener = (AuthListener.LoginListener)listener;
                    if (result == null) {
                        ErrorObject errorObject = new ErrorObject(object.optJSONObject("error"));
                        loginListener.onLogin(null, errorObject);
                        break;
                    }
                    GuestObject guestObject = new GuestObject((JSONObject)result);
                    loginListener.onLogin(guestObject, null);
                    break;
                }
                case GET_CHAT_HISTORY: {
                    LoadHistoryListener historyListener = (LoadHistoryListener)listener;
                    if (result == null) {
                        ErrorObject errorObject = new ErrorObject(object.optJSONObject("error"));
                        historyListener.onLoadHistory(null, 0, errorObject);
                        break;
                    }
                    ArrayList<LiveChatMessage> list = new ArrayList<LiveChatMessage>();
                    JSONArray array = ((JSONObject)result).optJSONArray("messages");
                    for (int j = 0; j < array.length(); ++j) {
                        list.add(new LiveChatMessage(array.optJSONObject(j)));
                    }
                    int unreadNotLoaded = object.optJSONObject("result").optInt("unreadNotLoaded");
                    historyListener.onLoadHistory(list, unreadNotLoaded, null);
                    break;
                }
                case GET_AGENT_DATA: {
                    AgentListener.AgentDataListener agentDataListener = (AgentListener.AgentDataListener)listener;
                    if (result == null) {
                        ErrorObject errorObject = new ErrorObject(object.optJSONObject("error"));
                        agentDataListener.onAgentData(null, errorObject);
                        break;
                    }
                    AgentObject agentObject = new AgentObject((JSONObject)result);
                    agentDataListener.onAgentData(agentObject, null);
                    break;
                }
                case SEND_MESSAGE: {
                    MessageListener.MessageAckListener messageAckListener = (MessageListener.MessageAckListener)listener;
                    if (result == null) {
                        ErrorObject errorObject = new ErrorObject(object.optJSONObject("error"));
                        messageAckListener.onMessageAck(null, errorObject);
                        break;
                    }
                    LiveChatMessage liveChatMessage = new LiveChatMessage((JSONObject)result);
                    messageAckListener.onMessageAck(liveChatMessage, null);
                    break;
                }
                case SEND_OFFLINE_MESSAGE: {
                    MessageListener.OfflineMessageListener messageListener = (MessageListener.OfflineMessageListener)listener;
                    if (result == null) {
                        ErrorObject errorObject = new ErrorObject(object.optJSONObject("error"));
                        messageListener.onOfflineMesssageSuccess(false, errorObject);
                        break;
                    }
                    messageListener.onOfflineMesssageSuccess((Boolean)result, null);
                }
            }
        }
    }

    public static enum ListenerType {
        GET_INITIAL_DATA,
        REGISTER,
        LOGIN,
        GET_CHAT_HISTORY,
        GET_AGENT_DATA,
        SEND_MESSAGE,
        SEND_OFFLINE_MESSAGE;

    }
}

