/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.core.middleware;

import io.rocketchat.common.listener.Listener;
import io.rocketchat.common.listener.SubscribeListener;
import io.rocketchat.common.listener.TypingListener;
import io.rocketchat.core.callback.MessageListener;
import io.rocketchat.core.model.RocketChatMessage;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class CoreStreamMiddleware {
    private ConcurrentHashMap<String, SubscribeListener> subcallbacks = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<SubType, Listener>> subs = new ConcurrentHashMap();

    public void createSub(String roomId, Listener listener, SubType type) {
        if (listener != null) {
            if (this.subs.containsKey(roomId)) {
                this.subs.get(roomId).put(type, listener);
            } else {
                ConcurrentHashMap<SubType, Listener> map = new ConcurrentHashMap<SubType, Listener>();
                map.put(type, listener);
                this.subs.put(roomId, map);
            }
        }
    }

    public void removeAllSub(String roomId) {
        this.subs.remove(roomId);
    }

    public void removeSub(String roomId, SubType type) {
        if (this.subs.containsKey(roomId)) {
            this.subs.get(roomId).remove((Object)type);
        }
    }

    public void createSubCallback(String subId, SubscribeListener callback) {
        if (callback != null) {
            this.subcallbacks.put(subId, callback);
        }
    }

    public void processCallback(JSONObject object) {
        String s = object.optString("collection");
        JSONArray array = object.optJSONObject("fields").optJSONArray("args");
        String roomId = object.optJSONObject("fields").optString("eventName").replace("/typing", "");
        if (this.subs.containsKey(roomId)) {
            switch (CoreStreamMiddleware.parse(s)) {
                case SUBSCRIBE_ROOM_MESSAGE: {
                    Listener listener = this.subs.get(roomId).get((Object)SubType.SUBSCRIBE_ROOM_MESSAGE);
                    MessageListener.SubscriptionListener subscriptionListener = (MessageListener.SubscriptionListener)listener;
                    RocketChatMessage message = new RocketChatMessage(array.optJSONObject(0));
                    subscriptionListener.onMessage(roomId, message);
                    break;
                }
                case SUBSCRIBE_ROOM_TYPING: {
                    Listener listener = this.subs.get(roomId).get((Object)SubType.SUBSCRIBE_ROOM_TYPING);
                    TypingListener typingListener = (TypingListener)listener;
                    typingListener.onTyping(roomId, array.optString(0), array.optBoolean(1));
                    break;
                }
            }
        }
    }

    public void processSubSuccess(JSONObject subObj) {
        String id;
        if (subObj.optJSONArray("subs") != null && this.subcallbacks.containsKey(id = subObj.optJSONArray("subs").optString(0))) {
            this.subcallbacks.remove(id).onSubscribe(true, id);
        }
    }

    public void processUnsubSuccess(JSONObject unsubObj) {
        String id = unsubObj.optString("id");
        if (this.subcallbacks.containsKey(id)) {
            SubscribeListener subscribeListener = this.subcallbacks.remove(id);
            subscribeListener.onSubscribe(false, id);
        }
    }

    private static SubType parse(String s) {
        if (s.equals("stream-room-messages")) {
            return SubType.SUBSCRIBE_ROOM_MESSAGE;
        }
        if (s.equals("stream-notify-room")) {
            return SubType.SUBSCRIBE_ROOM_TYPING;
        }
        return SubType.OTHER;
    }

    public static enum SubType {
        SUBSCRIBE_ROOM_MESSAGE,
        SUBSCRIBE_ROOM_TYPING,
        OTHER;

    }
}

