/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.core;

import io.rocketchat.common.data.lightdb.DbManager;
import io.rocketchat.common.data.model.Room;
import io.rocketchat.common.data.model.UserObject;
import io.rocketchat.common.data.rpc.RPC;
import io.rocketchat.common.listener.ConnectListener;
import io.rocketchat.common.listener.SimpleListener;
import io.rocketchat.common.listener.SubscribeListener;
import io.rocketchat.common.listener.TypingListener;
import io.rocketchat.common.network.Socket;
import io.rocketchat.common.utils.Utils;
import io.rocketchat.core.callback.AccountListener;
import io.rocketchat.core.callback.EmojiListener;
import io.rocketchat.core.callback.GetSubscriptionListener;
import io.rocketchat.core.callback.HistoryListener;
import io.rocketchat.core.callback.LoginListener;
import io.rocketchat.core.callback.MessageListener;
import io.rocketchat.core.callback.RoomListener;
import io.rocketchat.core.callback.UserListener;
import io.rocketchat.core.factory.ChatRoomFactory;
import io.rocketchat.core.middleware.CoreMiddleware;
import io.rocketchat.core.middleware.CoreStreamMiddleware;
import io.rocketchat.core.model.RocketChatMessage;
import io.rocketchat.core.model.SubscriptionObject;
import io.rocketchat.core.rpc.AccountRPC;
import io.rocketchat.core.rpc.BasicRPC;
import io.rocketchat.core.rpc.ChatHistoryRPC;
import io.rocketchat.core.rpc.CoreSubRPC;
import io.rocketchat.core.rpc.MessageRPC;
import io.rocketchat.core.rpc.PresenceRPC;
import io.rocketchat.core.rpc.RoomRPC;
import io.rocketchat.core.rpc.TypingRPC;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class RocketChatAPI
extends Socket {
    private AtomicInteger integer = new AtomicInteger(1);
    private String sessionId;
    private String userId;
    private CoreMiddleware coreMiddleware = new CoreMiddleware();
    private CoreStreamMiddleware coreStreamMiddleware = new CoreStreamMiddleware();
    private DbManager dbManager = new DbManager();
    private ChatRoomFactory chatRoomFactory = new ChatRoomFactory(this);

    public RocketChatAPI(String url) {
        super(url);
    }

    public String getMyUserName() {
        return this.dbManager.getUser(this.userId).getUserName();
    }

    public String getMyUserId() {
        return this.userId;
    }

    public ChatRoomFactory getChatRoomFactory() {
        return this.chatRoomFactory;
    }

    public DbManager getDbManager() {
        return this.dbManager;
    }

    public void login(String username, String password, LoginListener loginListener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, loginListener, CoreMiddleware.ListenerType.LOGIN);
        this.sendDataInBackground(BasicRPC.login(uniqueID, username, password));
    }

    public void loginUsingToken(String token, LoginListener loginListener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, loginListener, CoreMiddleware.ListenerType.LOGIN);
        this.sendDataInBackground(BasicRPC.loginUsingToken(uniqueID, token));
    }

    public void getPermissions(AccountListener.getPermissionsListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.GET_PERMISSIONS);
        this.sendDataInBackground(AccountRPC.getPermissions(uniqueID, null));
    }

    public void getPublicSettings(AccountListener.getPublicSettingsListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.GET_PUBLIC_SETTINGS);
        this.sendDataInBackground(AccountRPC.getPublicSettings(uniqueID, null));
    }

    public void getUserRoles(UserListener.getUserRoleListener userRoleListener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, userRoleListener, CoreMiddleware.ListenerType.GET_USER_ROLES);
        this.sendDataInBackground(BasicRPC.getUserRoles(uniqueID));
    }

    public void listCustomEmoji(EmojiListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.LIST_CUSTOM_EMOJI);
        this.sendDataInBackground(BasicRPC.listCustomEmoji(uniqueID));
    }

    public void logout(SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.LOGOUT);
        this.sendDataInBackground(BasicRPC.logout(uniqueID));
    }

    public void getSubscriptions(GetSubscriptionListener getSubscriptionListener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, getSubscriptionListener, CoreMiddleware.ListenerType.GET_SUBSCRIPTIONS);
        this.sendDataInBackground(BasicRPC.getSubscriptions(uniqueID));
    }

    public void getRooms(RoomListener.GetRoomListener getRoomListener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, getRoomListener, CoreMiddleware.ListenerType.GET_ROOMS);
        this.sendDataInBackground(BasicRPC.getRooms(uniqueID));
    }

    private void getRoomRoles(String roomId, RoomListener.RoomRolesListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.GET_ROOM_ROLES);
        this.sendDataInBackground(BasicRPC.getRoomRoles(uniqueID, roomId));
    }

    private void getChatHistory(String roomID, int limit, Date oldestMessageTimestamp, Date lasttimestamp, HistoryListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.LOAD_HISTORY);
        this.sendDataInBackground(ChatHistoryRPC.loadHistory(uniqueID, roomID, oldestMessageTimestamp, limit, lasttimestamp));
    }

    private void getRoomMembers(String roomID, Boolean allUsers, RoomListener.GetMembersListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.GET_ROOM_MEMBERS);
        this.sendDataInBackground(RoomRPC.getRoomMembers(uniqueID, roomID, allUsers));
    }

    private void sendIsTyping(String roomId, String username, Boolean istyping) {
        int uniqueID = this.integer.getAndIncrement();
        this.sendDataInBackground(TypingRPC.sendTyping(uniqueID, roomId, username, istyping));
    }

    private void sendMessage(String msgId, String roomID, String message, MessageListener.MessageAckListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.SEND_MESSAGE);
        this.sendDataInBackground(MessageRPC.sendMessage(uniqueID, msgId, roomID, message));
    }

    private void deleteMessage(String msgId, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.MESSAGE_OP);
        this.sendDataInBackground(MessageRPC.deleteMessage(uniqueID, msgId));
    }

    private void updateMessage(String msgId, String roomId, String message, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.MESSAGE_OP);
        this.sendDataInBackground(MessageRPC.updateMessage(uniqueID, msgId, roomId, message));
    }

    private void pinMessage(JSONObject message, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.MESSAGE_OP);
        this.sendDataInBackground(MessageRPC.pinMessage(uniqueID, message));
    }

    private void unpinMessage(JSONObject message, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.MESSAGE_OP);
        this.sendDataInBackground(MessageRPC.unpinMessage(uniqueID, message));
    }

    private void starMessage(String msgId, String roomId, Boolean starred, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.MESSAGE_OP);
        this.sendDataInBackground(MessageRPC.starMessage(uniqueID, msgId, roomId, starred));
    }

    private void setReaction(String emojiId, String msgId, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.MESSAGE_OP);
        this.sendDataInBackground(MessageRPC.setReaction(uniqueID, emojiId, msgId));
    }

    private void searchMessage(String message, String roomId, int limit, MessageListener.SearchMessageListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.SEARCH_MESSAGE);
        this.sendDataInBackground(MessageRPC.searchMessage(uniqueID, message, roomId, limit));
    }

    public void createPublicGroup(String groupName, String[] users, Boolean readOnly, RoomListener.GroupListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.CREATE_GROUP);
        this.sendDataInBackground(RoomRPC.createPublicGroup(uniqueID, groupName, users, readOnly));
    }

    public void createPrivateGroup(String groupName, String[] users, RoomListener.GroupListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.CREATE_GROUP);
        this.sendDataInBackground(RoomRPC.createPrivateGroup(uniqueID, groupName, users));
    }

    private void deleteGroup(String roomId, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.DELETE_GROUP);
        this.sendDataInBackground(RoomRPC.deleteGroup(uniqueID, roomId));
    }

    private void archiveRoom(String roomId, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.ARCHIVE);
        this.sendDataInBackground(RoomRPC.archieveRoom(uniqueID, roomId));
    }

    private void unarchiveRoom(String roomId, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.UNARCHIVE);
        this.sendDataInBackground(RoomRPC.unarchiveRoom(uniqueID, roomId));
    }

    public void joinPublicGroup(String roomId, String joinCode, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.JOIN_PUBLIC_GROUP);
        this.sendDataInBackground(RoomRPC.joinPublicGroup(uniqueID, roomId, joinCode));
    }

    private void leaveGroup(String roomId, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.LEAVE_GROUP);
        this.sendDataInBackground(RoomRPC.leaveGroup(uniqueID, roomId));
    }

    private void hideRoom(String roomId, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.HIDE_ROOM);
        this.sendDataInBackground(RoomRPC.hideRoom(uniqueID, roomId));
    }

    private void openRoom(String roomId, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.OPEN_ROOM);
        this.sendDataInBackground(RoomRPC.openRoom(uniqueID, roomId));
    }

    private void setFavouriteRoom(String roomId, Boolean isFavouriteRoom, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.SET_FAVOURITE_ROOM);
        this.sendDataInBackground(RoomRPC.setFavouriteRoom(uniqueID, roomId, isFavouriteRoom));
    }

    public void setStatus(UserObject.Status s, SimpleListener listener) {
        int uniqueID = this.integer.getAndIncrement();
        this.coreMiddleware.createCallback(uniqueID, listener, CoreMiddleware.ListenerType.SET_STATUS);
        this.sendDataInBackground(PresenceRPC.setDefaultStatus(uniqueID, s));
    }

    public void subscribeActiveUsers(SubscribeListener subscribeListener) {
        String uniqueID = Utils.shortUUID();
        this.coreStreamMiddleware.createSubCallback(uniqueID, subscribeListener);
        this.sendDataInBackground(CoreSubRPC.subscribeActiveUsers(uniqueID));
    }

    public void subscribeUserData(SubscribeListener subscribeListener) {
        String uniqueID = Utils.shortUUID();
        this.coreStreamMiddleware.createSubCallback(uniqueID, subscribeListener);
        this.sendDataInBackground(CoreSubRPC.subscribeUserData(uniqueID));
    }

    private String subscribeRoomMessageEvent(String roomId, Boolean enable, SubscribeListener subscribeListener, MessageListener.SubscriptionListener listener) {
        String uniqueID = Utils.shortUUID();
        this.coreStreamMiddleware.createSubCallback(uniqueID, subscribeListener);
        this.coreStreamMiddleware.createSub(roomId, listener, CoreStreamMiddleware.SubType.SUBSCRIBE_ROOM_MESSAGE);
        this.sendDataInBackground(CoreSubRPC.subscribeRoomMessageEvent(uniqueID, roomId, enable));
        return uniqueID;
    }

    private String subscribeRoomTypingEvent(String roomId, Boolean enable, SubscribeListener subscribeListener, TypingListener listener) {
        String uniqueID = Utils.shortUUID();
        this.coreStreamMiddleware.createSubCallback(uniqueID, subscribeListener);
        this.coreStreamMiddleware.createSub(roomId, listener, CoreStreamMiddleware.SubType.SUBSCRIBE_ROOM_TYPING);
        this.sendDataInBackground(CoreSubRPC.subscribeRoomTypingEvent(uniqueID, roomId, enable));
        return uniqueID;
    }

    private void unsubscribeRoom(String subId, SubscribeListener subscribeListener) {
        this.sendDataInBackground(CoreSubRPC.unsubscribeRoom(subId));
        this.coreStreamMiddleware.createSubCallback(subId, subscribeListener);
    }

    public void connect(ConnectListener connectListener) {
        this.createSocket();
        this.connectivityManager.register(connectListener);
        super.connectAsync();
    }

    @Override
    protected void onConnected() {
        this.integer.set(1);
        this.sendDataInBackground(BasicRPC.ConnectObject());
        super.onConnected();
    }

    @Override
    protected void onTextMessage(String text) throws Exception {
        JSONObject object = new JSONObject(text);
        switch (RPC.parse(object.optString("msg"))) {
            case PING: {
                this.sendDataInBackground("{\"msg\":\"pong\"}");
                break;
            }
            case PONG: {
                this.sendPingFrames();
                break;
            }
            case CONNECTED: {
                this.processOnConnected(object);
                break;
            }
            case RESULT: {
                this.coreMiddleware.processCallback(Long.valueOf(object.optString("id")), object);
                break;
            }
            case READY: {
                this.coreStreamMiddleware.processSubSuccess(object);
                break;
            }
            case ADDED: {
                this.processCollectionsAdded(object);
                break;
            }
            case CHANGED: {
                this.processCollectionsChanged(object);
                break;
            }
            case REMOVED: {
                this.dbManager.update(object, RPC.MsgType.REMOVED);
                break;
            }
            case NOSUB: {
                this.coreStreamMiddleware.processUnsubSuccess(object);
                break;
            }
            case OTHER: {
                break;
            }
        }
        super.onTextMessage(text);
    }

    private void sendPingFrames() {
        if (this.isPingEnabled()) {
            this.sendPingFramesPeriodically();
        }
    }

    private void processOnConnected(JSONObject object) {
        this.sessionId = object.optString("session");
        this.connectivityManager.publishConnect(this.sessionId);
        this.sendDataInBackground("{\"msg\":\"ping\"}");
    }

    private void processCollectionsAdded(JSONObject object) {
        if (this.userId == null) {
            this.userId = object.optString("id");
        }
        this.dbManager.update(object, RPC.MsgType.ADDED);
    }

    private void processCollectionsChanged(JSONObject object) {
        switch (DbManager.getCollectionType(object)) {
            case STREAM: {
                this.coreStreamMiddleware.processCallback(object);
                break;
            }
            case COLLECTION: {
                this.dbManager.update(object, RPC.MsgType.CHANGED);
            }
        }
    }

    @Override
    protected void onConnectError(Exception websocketException) {
        this.connectivityManager.publishConnectError(websocketException);
        super.onConnectError(websocketException);
    }

    @Override
    protected void onDisconnected(boolean closedByServer) {
        this.connectivityManager.publishDisconnect(closedByServer);
        super.onDisconnected(closedByServer);
    }

    public class ChatRoom {
        Room room;
        private String roomSubId;
        private String typingSubId;

        public ChatRoom(Room room) {
            this.room = room;
        }

        public Boolean isSubscriptionObject() {
            return this.room instanceof SubscriptionObject;
        }

        public Room getRoomData() {
            return this.room;
        }

        public void getRoomRoles(RoomListener.RoomRolesListener listener) {
            RocketChatAPI.this.getRoomRoles(this.room.getRoomId(), listener);
        }

        public void getChatHistory(int limit, Date oldestMessageTimestamp, Date lasttimestamp, HistoryListener listener) {
            RocketChatAPI.this.getChatHistory(this.room.getRoomId(), limit, oldestMessageTimestamp, lasttimestamp, listener);
        }

        public void getMembers(RoomListener.GetMembersListener membersListener) {
            RocketChatAPI.this.getRoomMembers(this.room.getRoomId(), false, membersListener);
        }

        public void sendIsTyping(Boolean istyping) {
            RocketChatAPI.this.sendIsTyping(this.room.getRoomId(), RocketChatAPI.this.getMyUserName(), istyping);
        }

        public void sendMessage(String message) {
            RocketChatAPI.this.sendMessage(Utils.shortUUID(), this.room.getRoomId(), message, null);
        }

        public void sendMessage(String message, MessageListener.MessageAckListener listener) {
            RocketChatAPI.this.sendMessage(Utils.shortUUID(), this.room.getRoomId(), message, listener);
        }

        private void replyMessage(RocketChatMessage msg, String message, MessageListener.MessageAckListener listener) {
            message = "[ ](?msg=" + msg.getMessageId() + ") @" + msg.getSender().getUserName() + " " + message;
            RocketChatAPI.this.sendMessage(Utils.shortUUID(), this.room.getRoomId(), message, listener);
        }

        public void deleteMessage(String msgId, SimpleListener listener) {
            RocketChatAPI.this.deleteMessage(msgId, listener);
        }

        public void updateMessage(String msgId, String message, SimpleListener listener) {
            RocketChatAPI.this.updateMessage(msgId, this.room.getRoomId(), message, listener);
        }

        public void pinMessage(JSONObject message, SimpleListener listener) {
            RocketChatAPI.this.pinMessage(message, listener);
        }

        public void unpinMessage(JSONObject message, SimpleListener listener) {
            RocketChatAPI.this.unpinMessage(message, listener);
        }

        public void starMessage(String msgId, Boolean starred, SimpleListener listener) {
            RocketChatAPI.this.starMessage(msgId, this.room.getRoomId(), starred, listener);
        }

        public void setReaction(String emojiId, String msgId, SimpleListener listener) {
            RocketChatAPI.this.setReaction(emojiId, msgId, listener);
        }

        public void searchMessage(String message, int limit, MessageListener.SearchMessageListener listener) {
            RocketChatAPI.this.searchMessage(message, this.room.getRoomId(), limit, listener);
        }

        public void deleteGroup(SimpleListener listener) {
            RocketChatAPI.this.deleteGroup(this.room.getRoomId(), listener);
        }

        public void archive(SimpleListener listener) {
            RocketChatAPI.this.archiveRoom(this.room.getRoomId(), listener);
        }

        public void unarchive(SimpleListener listener) {
            RocketChatAPI.this.unarchiveRoom(this.room.getRoomId(), listener);
        }

        public void leave(SimpleListener listener) {
            RocketChatAPI.this.leaveGroup(this.room.getRoomId(), listener);
        }

        public void hide(SimpleListener listener) {
            RocketChatAPI.this.hideRoom(this.room.getRoomId(), listener);
        }

        public void open(SimpleListener listener) {
            RocketChatAPI.this.openRoom(this.room.getRoomId(), listener);
        }

        public void setFavourite(Boolean isFavoutite, SimpleListener listener) {
            RocketChatAPI.this.setFavouriteRoom(this.room.getRoomId(), isFavoutite, listener);
        }

        public void subscribeRoomMessageEvent(SubscribeListener subscribeListener, MessageListener.SubscriptionListener listener) {
            if (this.roomSubId == null) {
                this.roomSubId = RocketChatAPI.this.subscribeRoomMessageEvent(this.room.getRoomId(), true, subscribeListener, listener);
            }
        }

        public void subscribeRoomTypingEvent(SubscribeListener subscribeListener, TypingListener listener) {
            if (this.typingSubId == null) {
                this.typingSubId = RocketChatAPI.this.subscribeRoomTypingEvent(this.room.getRoomId(), true, subscribeListener, listener);
            }
        }

        public void unSubscribeRoomMessageEvent(SubscribeListener subscribeListener) {
            if (this.roomSubId != null) {
                RocketChatAPI.this.coreStreamMiddleware.removeSub(this.room.getRoomId(), CoreStreamMiddleware.SubType.SUBSCRIBE_ROOM_MESSAGE);
                RocketChatAPI.this.unsubscribeRoom(this.roomSubId, subscribeListener);
                this.roomSubId = null;
            }
        }

        public void unSubscribeRoomTypingEvent(SubscribeListener subscribeListener) {
            if (this.typingSubId != null) {
                RocketChatAPI.this.coreStreamMiddleware.removeSub(this.room.getRoomId(), CoreStreamMiddleware.SubType.SUBSCRIBE_ROOM_TYPING);
                RocketChatAPI.this.unsubscribeRoom(this.typingSubId, subscribeListener);
                this.typingSubId = null;
            }
        }

        public void unSubscribeAllEvents() {
            RocketChatAPI.this.coreStreamMiddleware.removeAllSub(this.room.getRoomId());
            this.unSubscribeRoomMessageEvent(null);
            this.unSubscribeRoomTypingEvent(null);
        }
    }
}

