/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.common.data.model;

import io.rocketchat.common.data.model.UserObject;
import org.json.JSONException;
import org.json.JSONObject;

public class Room {
    protected String roomId;
    private String roomName;
    private UserObject userInfo;
    private Type roomType;

    public Room(JSONObject object) {
        try {
            this.roomId = object.getString("_id");
            String type = object.getString("t");
            this.roomType = type.equals("d") ? Type.ONE_TO_ONE : (type.equals("c") ? Type.PUBLIC : Type.PRIVATE);
            this.roomName = object.optString("name");
            if (object.optJSONObject("u") != null) {
                this.userInfo = new UserObject(object.optJSONObject("u"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getRoomId() {
        return this.roomId;
    }

    public Type getRoomType() {
        return this.roomType;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public UserObject getUserInfo() {
        return this.userInfo;
    }

    static enum Type {
        PUBLIC,
        PRIVATE,
        ONE_TO_ONE;

    }
}

