/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat.middleware;

import io.rocketchat.common.listener.SubscribeListener;
import io.rocketchat.common.listener.TypingListener;
import io.rocketchat.livechat.callback.AgentListener;
import io.rocketchat.livechat.callback.MessageListener;
import io.rocketchat.livechat.model.AgentObject;
import io.rocketchat.livechat.model.LiveChatMessage;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class LiveChatStreamMiddleware {
    private MessageListener.SubscriptionListener subscriptionListener;
    private AgentListener.AgentConnectListener agentConnectListener;
    private TypingListener typingListener;
    private ConcurrentHashMap<String, SubscribeListener> subcallbacks = new ConcurrentHashMap();

    private static SubType parse(String s) {
        if (s.equals("stream-room-messages")) {
            return SubType.STREAM_ROOM_MESSAGES;
        }
        if (s.equals("stream-livechat-room")) {
            return SubType.STREAM_LIVECHAT_ROOM;
        }
        return SubType.NOTIFY_ROOM;
    }

    public void subscribeRoom(MessageListener.SubscriptionListener subscription) {
        this.subscriptionListener = subscription;
    }

    public void subscribeLiveChatRoom(AgentListener.AgentConnectListener agentConnectListener) {
        this.agentConnectListener = agentConnectListener;
    }

    public void subscribeTyping(TypingListener callback) {
        this.typingListener = callback;
    }

    public void createSubCallbacks(String id, SubscribeListener callback) {
        if (callback != null) {
            this.subcallbacks.put(id, callback);
        }
    }

    public void processCallback(JSONObject object) {
        String s = object.optString("collection");
        JSONArray array = object.optJSONObject("fields").optJSONArray("args");
        switch (LiveChatStreamMiddleware.parse(s)) {
            case STREAM_ROOM_MESSAGES: {
                if (this.subscriptionListener == null) break;
                LiveChatMessage liveChatMessage = new LiveChatMessage(array.optJSONObject(0));
                String roomId = object.optJSONObject("fields").optString("eventName");
                if (liveChatMessage.getMessagetype().equals(LiveChatMessage.MESSAGE_TYPE_CLOSE)) {
                    this.subscriptionListener.onAgentDisconnect(roomId, liveChatMessage);
                    break;
                }
                this.subscriptionListener.onMessage(roomId, liveChatMessage);
                break;
            }
            case STREAM_LIVECHAT_ROOM: {
                if (this.agentConnectListener == null) break;
                this.agentConnectListener.onAgentConnect(new AgentObject(array.optJSONObject(0).optJSONObject("data")));
                break;
            }
            case NOTIFY_ROOM: {
                if (this.typingListener == null) break;
                this.typingListener.onTyping(object.optJSONObject("fields").optString("eventName"), array.optString(0), array.optBoolean(1));
            }
        }
    }

    public void processSubSuccess(JSONObject subObj) {
        String id;
        if (subObj.optJSONArray("subs") != null && this.subcallbacks.containsKey(id = subObj.optJSONArray("subs").optString(0))) {
            SubscribeListener subscribeListener = this.subcallbacks.remove(id);
            subscribeListener.onSubscribe(true, id);
        }
    }

    public static enum SubType {
        STREAM_ROOM_MESSAGES,
        STREAM_LIVECHAT_ROOM,
        NOTIFY_ROOM;

    }
}

