/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.core.factory;

import io.rocketchat.common.data.model.Room;
import io.rocketchat.core.RocketChatAPI;
import java.util.ArrayList;
import java.util.List;

public class ChatRoomFactory {
    private RocketChatAPI api;
    private ArrayList<RocketChatAPI.ChatRoom> rooms;

    public ChatRoomFactory(RocketChatAPI api) {
        this.api = api;
        this.rooms = new ArrayList();
    }

    private RocketChatAPI.ChatRoom createChatRoom(Room room) {
        RocketChatAPI rocketChatAPI = this.api;
        rocketChatAPI.getClass();
        return rocketChatAPI.new RocketChatAPI.ChatRoom(room);
    }

    public ChatRoomFactory createChatRooms(List<? extends Room> roomObjects) {
        this.removeAllChatRooms();
        for (Room room : roomObjects) {
            this.rooms.add(this.createChatRoom(room));
        }
        return this;
    }

    public ChatRoomFactory addChatRoom(Room room) {
        if (this.getChatRoomByName(room.getRoomName()) == null) {
            RocketChatAPI.ChatRoom newRoom = this.createChatRoom(room);
            this.rooms.add(newRoom);
        }
        return this;
    }

    public ArrayList<RocketChatAPI.ChatRoom> getChatRooms() {
        return this.rooms;
    }

    public RocketChatAPI.ChatRoom getChatRoomByName(String roomName) {
        for (RocketChatAPI.ChatRoom room : this.rooms) {
            if (!room.getRoomData().getRoomName().equals(roomName)) continue;
            return room;
        }
        return null;
    }

    public RocketChatAPI.ChatRoom getChatRoomById(String roomId) {
        for (RocketChatAPI.ChatRoom room : this.rooms) {
            if (!room.getRoomData().getRoomId().equals(roomId)) continue;
            return room;
        }
        return null;
    }

    public Boolean removeChatRoomByName(String roomName) {
        for (RocketChatAPI.ChatRoom room : this.rooms) {
            if (!room.getRoomData().getRoomName().equals(roomName)) continue;
            return this.rooms.remove(room);
        }
        return false;
    }

    public Boolean removeChatRoomById(String roomId) {
        for (RocketChatAPI.ChatRoom room : this.rooms) {
            if (!room.getRoomData().getRoomId().equals(roomId)) continue;
            return this.rooms.remove(room);
        }
        return false;
    }

    public Boolean removeChatRoom(RocketChatAPI.ChatRoom room) {
        return this.rooms.remove(room);
    }

    public void removeAllChatRooms() {
        this.rooms.clear();
    }
}

