/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.common.network;

import com.neovisionaries.ws.client.OpeningHandshakeException;
import com.neovisionaries.ws.client.StatusLine;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import io.rocketchat.common.network.ConnectivityManager;
import io.rocketchat.common.network.EventThread;
import io.rocketchat.common.network.ReconnectionStrategy;
import io.rocketchat.common.network.TaskHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Socket {
    public static final Logger LOGGER = Logger.getLogger(Socket.class.getName());
    private String url;
    private WebSocketFactory factory;
    private TaskHandler handler;
    private long pingInterval;
    private WebSocket ws;
    private WebSocketAdapter adapter;
    private ReconnectionStrategy strategy;
    private Timer timer;
    private boolean selfDisconnect;
    private boolean pingEnable;
    protected ConnectivityManager connectivityManager;

    protected Socket(String url) {
        LOGGER.setLevel(Level.INFO);
        this.url = url;
        this.adapter = this.getAdapter();
        this.factory = new WebSocketFactory().setConnectionTimeout(5000);
        this.selfDisconnect = false;
        this.pingEnable = false;
        this.handler = new TaskHandler();
        this.pingInterval = 2000L;
        this.connectivityManager = new ConnectivityManager();
    }

    public void setReconnectionStrategy(ReconnectionStrategy strategy) {
        this.strategy = strategy;
    }

    public void setPingInterval(long pingInterval) {
        this.pingEnable = true;
        if (pingInterval > this.pingInterval) {
            this.pingInterval = pingInterval;
        }
    }

    public void disablePing() {
        this.handler.cancel();
        this.pingEnable = false;
    }

    public boolean isPingEnabled() {
        return this.pingEnable;
    }

    public State getState() {
        switch (this.ws.getState()) {
            case CREATED: {
                return State.CREATED;
            }
            case CONNECTING: {
                return State.CONNECTING;
            }
            case OPEN: {
                return State.CONNECTED;
            }
            case CLOSING: {
                return State.DISCONNECTING;
            }
            case CLOSED: {
                return State.DISCONNECTED;
            }
        }
        return State.DISCONNECTED;
    }

    public ConnectivityManager getConnectivityManager() {
        return this.connectivityManager;
    }

    private WebSocketAdapter getAdapter() {
        return new WebSocketAdapter(){

            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                Socket.this.onConnected();
                super.onConnected(websocket, headers);
            }

            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                Socket.this.onDisconnected(closedByServer);
                super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, closedByServer);
            }

            public void onConnectError(WebSocket websocket, WebSocketException exception) throws Exception {
                Socket.this.onConnectError((Exception)exception);
                super.onConnectError(websocket, exception);
            }

            public void onTextMessage(WebSocket websocket, String text) throws Exception {
                Socket.this.onTextMessage(text);
                super.onTextMessage(websocket, text);
            }
        };
    }

    protected void createSocket() {
        try {
            this.ws = this.factory.createSocket(this.url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.ws.addExtension("permessage-deflate; client_max_window_bits");
        this.ws.addHeader("Accept-Encoding", "gzip, deflate, sdch");
        this.ws.addHeader("Accept-Language", "en-US,en;q=0.8");
        this.ws.addHeader("Pragma", "no-cache");
        this.ws.addHeader("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.87 Safari/537.36");
        this.ws.addListener((WebSocketListener)this.adapter);
    }

    protected void connect() {
        try {
            this.ws.connect();
        }
        catch (OpeningHandshakeException e) {
            StatusLine sl = e.getStatusLine();
            System.out.println("=== Status Line ===");
            System.out.format("HTTP Version  = %s\n", sl.getHttpVersion());
            System.out.format("Status Code   = %d\n", sl.getStatusCode());
            System.out.format("Reason Phrase = %s\n", sl.getReasonPhrase());
            Map headers = e.getHeaders();
            System.out.println("=== HTTP Headers ===");
            for (Map.Entry entry : headers.entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                if (values == null || values.size() == 0) {
                    System.out.println(name);
                    continue;
                }
                for (String value : values) {
                    System.out.format("%s: %s\n", name, value);
                }
            }
        }
        catch (WebSocketException e) {
            System.out.println("Got websocket exception " + e.getMessage());
        }
    }

    protected void connectAsync() {
        this.ws.connectAsynchronously();
    }

    private void sendData(String message) {
        if (this.getState() == State.CONNECTED) {
            this.ws.sendText(message);
        }
    }

    protected void sendDataInBackground(final String message) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                if (Socket.this.getState() == State.CONNECTED) {
                    Socket.this.ws.sendText(message);
                }
            }
        });
    }

    public void reconnect() {
        try {
            this.ws = this.ws.recreate(5000).connectAsynchronously();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        this.ws.disconnect();
        this.selfDisconnect = true;
    }

    protected void onConnected() {
        this.strategy.setNumberOfAttempts(0);
        LOGGER.info("Connected to server");
    }

    protected void onDisconnected(boolean closedByServer) {
        LOGGER.warning("Disconnected from server");
        if (this.strategy != null && !this.selfDisconnect) {
            if (this.strategy.getNumberOfAttempts() < this.strategy.getMaxAttempts()) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Socket.this.reconnect();
                        Socket.this.strategy.processAttempts();
                        Socket.this.timer.cancel();
                        Socket.this.timer.purge();
                    }
                }, this.strategy.getReconnectInterval());
            } else {
                this.handler.cancel();
                LOGGER.info("Number of attempts are complete");
            }
        } else {
            this.handler.cancel();
            this.selfDisconnect = false;
        }
    }

    protected void onConnectError(Exception websocketException) {
        LOGGER.warning("Connect error");
        this.onDisconnected(true);
    }

    protected void onTextMessage(String text) throws Exception {
        LOGGER.info("Message is " + text);
    }

    protected void sendPingFramesPeriodically() {
        this.handler.removeLast();
        this.handler.postDelayed(new TimerTask(){

            @Override
            public void run() {
                Socket.this.sendData("{\"msg\":\"ping\"}");
                LOGGER.info("SENDING PING");
                Socket.this.handler.remove(this);
            }
        }, this.pingInterval);
        this.handler.postDelayed(new TimerTask(){

            @Override
            public void run() {
                if (Socket.this.getState() != State.DISCONNECTING && Socket.this.getState() != State.DISCONNECTED) {
                    Socket.this.ws.disconnect(1005, "PONG RECEIVE FAILED", 0L);
                }
                Socket.this.handler.remove(this);
            }
        }, 2L * this.pingInterval);
    }

    static enum State {
        CREATED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING,
        DISCONNECTED;

    }
}

