/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.common.network;

import io.rocketchat.common.listener.ConnectListener;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConnectivityManager {
    ConcurrentLinkedQueue<ConnectListener> listeners;

    public void register(ConnectListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ConcurrentLinkedQueue();
                this.listeners.add(listener);
            } else if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    public void publishConnect(String sessionId) {
        for (ConnectListener listener : this.listeners) {
            listener.onConnect(sessionId);
        }
    }

    public void publishDisconnect(boolean closedByServer) {
        for (ConnectListener listener : this.listeners) {
            listener.onDisconnect(closedByServer);
        }
    }

    public void publishConnectError(Exception websocketException) {
        for (ConnectListener listener : this.listeners) {
            listener.onConnectError(websocketException);
        }
    }

    public Boolean unRegister(ConnectListener listener) {
        return this.listeners.remove(listener);
    }
}

