/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.common.data.model;

import io.rocketchat.common.data.model.UserObject;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Message {
    private String messageId;
    protected String roomId;
    protected String message;
    private Date msgTimestamp;
    private UserObject sender;
    private Date updatedAt;
    private Date editedAt;
    private UserObject editedBy;
    private String messagetype;
    private String senderAlias;
    private static final String TYPE_MESSAGE_REMOVED = "rm";
    private static final String TYPE_ROOM_NAME_CHANGED = "r";
    private static final String TYPE_ROOM_ARCHIVED = "room-archived";
    private static final String TYPE_ROOM_UNARCHIVED = "room-unarchived";
    private static final String TYPE_USER_ADDED = "au";
    private static final String TYPE_USER_REMOVED = "ru";
    private static final String TYPE_USER_JOINED = "uj";
    private static final String TYPE_USER_LEFT = "ul";
    private static final String TYPE_USER_MUTED = "user-muted";
    private static final String TYPE_USER_UNMUTED = "user-unmuted";
    private static final String TYPE_WELCOME = "wm";
    private static final String TYPE_SUBSCRIPTION_ROLE_ADDED = "subscription-role-added";
    private static final String TYPE_SUBSCRIPTION_ROLE_REMOVED = "subscription-role-removed";

    public Message(JSONObject object) {
        try {
            this.messageId = object.optString("_id");
            this.roomId = object.optString("rid");
            this.message = object.optString("msg");
            if (object.optJSONObject("ts") != null) {
                this.msgTimestamp = new Date(object.getJSONObject("ts").getLong("$date"));
            }
            this.sender = new UserObject(object.optJSONObject("u"));
            this.updatedAt = new Date(object.getJSONObject("_updatedAt").getLong("$date"));
            if (object.optJSONObject("editedAt") != null) {
                this.editedAt = new Date(object.getJSONObject("editedAt").getLong("$date"));
                this.editedBy = new UserObject(object.getJSONObject("editedBy"));
            }
            this.messagetype = object.optString("t");
            this.senderAlias = object.optString("alias");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getMsgTimestamp() {
        return this.msgTimestamp;
    }

    public UserObject getSender() {
        return this.sender;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Date getEditedAt() {
        return this.editedAt;
    }

    public UserObject getEditedBy() {
        return this.editedBy;
    }

    public String getMessagetype() {
        return this.messagetype;
    }

    public String getSenderAlias() {
        return this.senderAlias;
    }

    public static Type getType(String s) {
        if (s.equals(TYPE_MESSAGE_REMOVED)) {
            return Type.MESSAGE_REMOVED;
        }
        if (s.equals(TYPE_ROOM_NAME_CHANGED)) {
            return Type.ROOM_NAME_CHANGED;
        }
        if (s.equals(TYPE_ROOM_ARCHIVED)) {
            return Type.ROOM_ARCHIVED;
        }
        if (s.equals(TYPE_ROOM_UNARCHIVED)) {
            return Type.ROOM_UNARCHIVED;
        }
        if (s.equals(TYPE_USER_ADDED)) {
            return Type.USER_ADDED;
        }
        if (s.equals(TYPE_USER_REMOVED)) {
            return Type.USER_REMOVED;
        }
        if (s.equals(TYPE_USER_JOINED)) {
            return Type.USER_JOINED;
        }
        if (s.equals(TYPE_USER_LEFT)) {
            return Type.USER_LEFT;
        }
        if (s.equals(TYPE_USER_MUTED)) {
            return Type.USER_MUTED;
        }
        if (s.equals(TYPE_USER_UNMUTED)) {
            return Type.USER_UNMUTED;
        }
        if (s.equals(TYPE_WELCOME)) {
            return Type.WELCOME;
        }
        if (s.equals(TYPE_SUBSCRIPTION_ROLE_ADDED)) {
            return Type.SUBSCRIPTION_ROLE_ADDED;
        }
        if (s.equals(TYPE_SUBSCRIPTION_ROLE_REMOVED)) {
            return Type.SUBSCRIPTION_ROLE_REMOVED;
        }
        return Type.OTHER;
    }

    static enum Type {
        TEXT,
        TEXT_ATTACHMENT,
        IMAGE,
        AUDIO,
        VIDEO,
        URL,
        MESSAGE_REMOVED,
        ROOM_NAME_CHANGED,
        ROOM_ARCHIVED,
        ROOM_UNARCHIVED,
        USER_ADDED,
        USER_REMOVED,
        USER_JOINED,
        USER_LEFT,
        USER_MUTED,
        USER_UNMUTED,
        WELCOME,
        SUBSCRIPTION_ROLE_ADDED,
        SUBSCRIPTION_ROLE_REMOVED,
        OTHER;

    }
}

