/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.common.data.lightdb.document;

import io.rocketchat.common.data.model.UserObject;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserDocument
extends UserObject {
    Boolean active;
    private String name;
    private JSONObject services;
    private UserObject.Status status;
    private UserObject.Status statusConnection;
    private UserObject.Status statusDefault;
    private Integer utcOffset;

    public UserDocument(JSONObject object) {
        super(object);
        try {
            this.active = object.optBoolean("active");
            this.name = object.optString("name");
            this.services = object.optJSONObject("services");
            this.status = UserObject.getStatus(object.optString("status"));
            this.statusConnection = UserObject.getStatus(object.optString("statusConnection"));
            this.statusDefault = UserObject.getStatus(object.optString("statusDefault"));
            this.utcOffset = object.optInt("utcOffset");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getName() {
        return this.name;
    }

    public JSONObject getServices() {
        return this.services;
    }

    public UserObject.Status getStatus() {
        return this.status;
    }

    public UserObject.Status getStatusConnection() {
        return this.statusConnection;
    }

    public UserObject.Status getStatusDefault() {
        return this.statusDefault;
    }

    public Integer getUtcOffset() {
        return this.utcOffset;
    }

    public void update(JSONObject object) {
        try {
            if (object.opt("username") != null) {
                this.userName = object.optString("username");
            }
            if (object.opt("roles") != null) {
                if (this.roles != null) {
                    this.roles.clear();
                } else {
                    this.roles = new ArrayList();
                }
                JSONArray array = object.optJSONArray("roles");
                for (int i = 0; i < array.length(); ++i) {
                    this.roles.add(array.optString(i));
                }
            }
            if (object.opt("emails") != null) {
                this.emails = object.optJSONArray("emails");
            }
            if (object.opt("active") != null) {
                this.active = object.optBoolean("active");
            }
            if (object.opt("name") != null) {
                this.name = object.optString("name");
            }
            if (object.opt("services") != null) {
                this.services = object.optJSONObject("services");
            }
            if (object.opt("status") != null) {
                this.status = UserObject.getStatus(object.optString("status"));
            }
            if (object.opt("statusConnection") != null) {
                this.statusConnection = UserObject.getStatus(object.optString("statusConnection"));
            }
            if (object.opt("statusDefault") != null) {
                this.statusDefault = UserObject.getStatus(object.optString("statusDefault"));
            }
            if (object.opt("utcOffset") != null) {
                this.utcOffset = object.optInt("utcOffset");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "UserDocument{active=" + this.active + ", name='" + this.name + '\'' + ", services=" + this.services + ", status=" + (Object)((Object)this.status) + ", statusConnection=" + (Object)((Object)this.statusConnection) + ", statusDefault=" + (Object)((Object)this.statusDefault) + ", utcOffset=" + this.utcOffset + '}';
    }
}

