/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.common.data.lightdb;

import io.rocketchat.common.data.lightdb.collection.Collection;
import io.rocketchat.common.data.lightdb.document.UserDocument;
import io.rocketchat.common.data.model.UserObject;
import io.rocketchat.common.data.rpc.RPC;
import java.util.ArrayList;
import java.util.Observable;
import org.json.JSONObject;

public class DbManager
extends Observable {
    Collection<String, UserDocument> usersCollection = new Collection();
    private static final String TYPE_USERS = "users";
    private static final String TYPE_METEOR_ACCOUNTS_LOGIN_CONF = "meteor_accounts_loginServiceConfiguration";
    private static final String TYPE_ROCKETCHAT_ROLES = "rocketchat_roles";
    private static final String TYPE_METEOR_CLIENT_VERSIONS = "meteor_autoupdate_clientVersions";

    public UserObject getUser(String userId) {
        return this.usersCollection.get(userId);
    }

    public ArrayList<UserDocument> getUserCollection() {
        return this.usersCollection.getData();
    }

    public void update(JSONObject object, RPC.MsgType type) {
        String collectionName = object.optString("collection");
        if (collectionName.equals(TYPE_USERS)) {
            this.updateUsers(object, type);
        }
    }

    private void updateUsers(JSONObject object, RPC.MsgType type) {
        String id = object.optString("id");
        switch (type) {
            case ADDED: {
                UserDocument userDocument = new UserDocument(object.optJSONObject("fields"));
                this.usersCollection.add(id, userDocument);
                this.setChanged();
                this.notifyObservers(userDocument);
                break;
            }
            case CHANGED: {
                this.usersCollection.get(id).update(object.optJSONObject("fields"));
                this.setChanged();
                this.notifyObservers(this.usersCollection.get(id));
                break;
            }
            case REMOVED: {
                this.usersCollection.remove(id);
                this.setChanged();
                this.notifyObservers();
                break;
            }
        }
    }

    public static Type getCollectionType(JSONObject object) {
        String collectionName = object.optString("collection");
        if (collectionName.equals(TYPE_USERS) || collectionName.equals(TYPE_METEOR_ACCOUNTS_LOGIN_CONF) || collectionName.equals(TYPE_METEOR_CLIENT_VERSIONS) || collectionName.equals(TYPE_ROCKETCHAT_ROLES)) {
            return Type.COLLECTION;
        }
        return Type.STREAM;
    }

    public static enum Type {
        STREAM,
        COLLECTION;

    }
}

