/*
 * Decompiled with CFR 0.152.
 */
import io.rocketchat.common.data.lightdb.document.UserDocument;
import io.rocketchat.common.data.model.ErrorObject;
import io.rocketchat.common.listener.SubscribeListener;
import io.rocketchat.core.RocketChatAPI;
import io.rocketchat.core.adapter.CoreAdapter;
import io.rocketchat.core.model.RocketChatMessage;
import io.rocketchat.core.model.SubscriptionObject;
import io.rocketchat.core.model.TokenObject;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class Main
extends CoreAdapter {
    private static String serverurl = "wss://demo.rocket.chat/websocket";
    RocketChatAPI api;

    public static void main(String[] args) {
        new Main().call();
    }

    public void call() {
        this.api = new RocketChatAPI(serverurl);
        this.api.setReconnectionStrategy(null);
        this.api.setPingInterval(3000L);
        this.api.connect(this);
        this.api.getDbManager().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                System.out.println("Got notification for collection change");
                if (arg != null) {
                    UserDocument document = (UserDocument)arg;
                    System.out.println("New status is " + (Object)((Object)document.getStatus()));
                } else {
                    System.out.println("Removed for system");
                }
            }
        });
    }

    @Override
    public void onConnect(String sessionID) {
        System.out.println("Connected to server");
        this.api.login("testuserrocks", "testuserrocks", this);
    }

    @Override
    public void onConnectError(Exception websocketException) {
        System.out.println("Got connect error here");
    }

    @Override
    public void onLogin(TokenObject token, ErrorObject error) {
        System.out.println("My username is " + this.api.getMyUserName());
        this.api.subscribeUserData(new SubscribeListener(){

            @Override
            public void onSubscribe(Boolean isSubscribed, String subId) {
                if (isSubscribed.booleanValue()) {
                    System.out.println("Subscribed successfully");
                }
            }
        });
        this.api.subscribeActiveUsers(new SubscribeListener(){

            @Override
            public void onSubscribe(Boolean isSubscribed, String subId) {
                if (isSubscribed.booleanValue()) {
                    System.out.println("Subscribed for active users");
                }
            }
        });
    }

    @Override
    public void onGetSubscriptions(List<SubscriptionObject> subscriptions, ErrorObject error) {
        RocketChatAPI.ChatRoom room = this.api.getChatRoomFactory().createChatRooms(subscriptions).getChatRoomByName("sachin.shinde");
        room.subscribeRoomTypingEvent(new SubscribeListener(){

            @Override
            public void onSubscribe(Boolean isSubscribed, String subId) {
                System.out.println("subscribed to typing successfully");
            }
        }, this);
        room.subscribeRoomMessageEvent(new SubscribeListener(){

            @Override
            public void onSubscribe(Boolean isSubscribed, String subId) {
                System.out.println("subscribed for receiving messages");
            }
        }, this);
    }

    @Override
    public void onTyping(String roomId, String user, Boolean istyping) {
        System.out.println("got typing from " + user + " " + istyping);
    }

    @Override
    public void onMessage(String roomId, RocketChatMessage message) {
        System.out.println("got message " + message.getMessage());
    }

    @Override
    public void onDisconnect(boolean closedByServer) {
        System.out.println("Disconnect detected");
    }
}

