/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.common.network;

import com.neovisionaries.ws.client.OpeningHandshakeException;
import com.neovisionaries.ws.client.StatusLine;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import io.rocketchat.common.network.EventThread;
import io.rocketchat.common.network.ReconnectionStrategy;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class Socket {
    String url;
    WebSocketFactory factory;
    private WebSocket ws;
    private WebSocketAdapter adapter;
    private ReconnectionStrategy strategy;
    private Timer timer;
    private boolean selfDisconnect;

    protected Socket(String url) {
        this.url = url;
        this.adapter = this.getAdapter();
        this.factory = new WebSocketFactory().setConnectionTimeout(5000);
        this.selfDisconnect = false;
    }

    public void setReconnectionStrategy(ReconnectionStrategy strategy) {
        this.strategy = strategy;
    }

    private WebSocketAdapter getAdapter() {
        return new WebSocketAdapter(){

            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                Socket.this.onConnected();
                super.onConnected(websocket, headers);
            }

            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                Socket.this.onDisconnected(closedByServer);
                super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, closedByServer);
            }

            public void onConnectError(WebSocket websocket, WebSocketException exception) throws Exception {
                Socket.this.onConnectError((Exception)exception);
                super.onConnectError(websocket, exception);
            }

            public void onTextMessage(WebSocket websocket, String text) throws Exception {
                Socket.this.onTextMessage(text);
                super.onTextMessage(websocket, text);
            }
        };
    }

    protected void createSocket() {
        try {
            this.ws = this.factory.createSocket(this.url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.ws.addExtension("permessage-deflate; client_max_window_bits");
        this.ws.addHeader("Accept-Encoding", "gzip, deflate, sdch");
        this.ws.addHeader("Accept-Language", "en-US,en;q=0.8");
        this.ws.addHeader("Pragma", "no-cache");
        this.ws.addHeader("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.87 Safari/537.36");
        this.ws.addListener((WebSocketListener)this.adapter);
    }

    protected void connect() {
        try {
            this.ws.connect();
        }
        catch (OpeningHandshakeException e) {
            StatusLine sl = e.getStatusLine();
            System.out.println("=== Status Line ===");
            System.out.format("HTTP Version  = %s\n", sl.getHttpVersion());
            System.out.format("Status Code   = %d\n", sl.getStatusCode());
            System.out.format("Reason Phrase = %s\n", sl.getReasonPhrase());
            Map headers = e.getHeaders();
            System.out.println("=== HTTP Headers ===");
            for (Map.Entry entry : headers.entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                if (values == null || values.size() == 0) {
                    System.out.println(name);
                    continue;
                }
                for (String value : values) {
                    System.out.format("%s: %s\n", name, value);
                }
            }
        }
        catch (WebSocketException e) {
            System.out.println("Got websocket exception " + e.getMessage());
        }
    }

    protected void connectAsync() {
        this.ws.connectAsynchronously();
    }

    protected void sendData(String message) {
        this.ws.sendText(message);
    }

    protected void sendDataInBackground(final String message) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                Socket.this.ws.sendText(message);
            }
        });
    }

    protected void reconnect() {
        try {
            this.ws = this.ws.recreate(5000).connectAsynchronously();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void disconnect() {
        this.ws.disconnect();
        this.selfDisconnect = true;
    }

    protected void onConnected() {
        this.strategy.setNumberOfAttempts(0);
        System.out.println("Connected");
    }

    protected void onDisconnected(boolean closedByServer) {
        System.out.println("Disconnected");
        if (this.strategy != null && !this.selfDisconnect) {
            if (this.strategy.getNumberOfAttempts() < this.strategy.getMaxAttempts()) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Socket.this.reconnect();
                        Socket.this.strategy.processAttempts();
                        Socket.this.timer.cancel();
                        Socket.this.timer.purge();
                    }
                }, this.strategy.getReconnectInterval());
            } else {
                System.out.println("Number of attempts are complete");
            }
        } else {
            this.selfDisconnect = false;
        }
    }

    protected void onConnectError(Exception websocketException) {
        System.out.println("Onconnect Error");
        this.onDisconnected(true);
    }

    protected void onTextMessage(String text) throws Exception {
        System.out.println("Message is " + text);
    }
}

