/*
 * Decompiled with CFR 0.152.
 */
import io.rocketchat.common.data.model.ErrorObject;
import io.rocketchat.common.network.ReconnectionStrategy;
import io.rocketchat.livechat.LiveChatAPI;
import io.rocketchat.livechat.callback.ConnectListener;
import io.rocketchat.livechat.callback.InitialDataListener;
import io.rocketchat.livechat.model.DepartmentObject;
import io.rocketchat.livechat.model.LiveChatConfigObject;
import java.util.ArrayList;

public class Main
implements ConnectListener,
InitialDataListener {
    private LiveChatAPI liveChat;
    private LiveChatAPI.ChatRoom room;
    private static String serverurl = "wss://livechattest.rocket.chat/websocket";

    public void call() {
        this.liveChat = new LiveChatAPI(serverurl);
        this.liveChat.setReconnectionStrategy(new ReconnectionStrategy(10, 5000));
        this.liveChat.connect(this);
    }

    public static void main(String[] args) {
        new Main().call();
    }

    @Override
    public void onConnect(String sessionID) {
        System.out.println("Connected to server");
        this.liveChat.getInitialData(this);
    }

    @Override
    public void onDisconnect(boolean closedByServer) {
        System.out.println("Disconnected from server");
    }

    @Override
    public void onConnectError(Exception websocketException) {
        System.out.println("Got connect error with the server");
    }

    @Override
    public void onInitialData(LiveChatConfigObject object, ErrorObject error) {
        System.out.println("Got initial data " + object);
        ArrayList<DepartmentObject> departmentObjects = object.getDepartments();
        if (departmentObjects.size() == 0) {
            System.out.println("No departments available");
        } else {
            System.out.println("Departments available " + departmentObjects);
        }
    }
}

