/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import io.rocketchat.common.data.rpc.RPC;
import io.rocketchat.common.network.EventThread;
import io.rocketchat.common.network.ReconnectionStrategy;
import io.rocketchat.common.network.Socket;
import io.rocketchat.common.utils.Utils;
import io.rocketchat.livechat.callback.AgentListener;
import io.rocketchat.livechat.callback.AuthListener;
import io.rocketchat.livechat.callback.ConnectListener;
import io.rocketchat.livechat.callback.InitialDataListener;
import io.rocketchat.livechat.callback.LoadHistoryListener;
import io.rocketchat.livechat.callback.MessageListener;
import io.rocketchat.livechat.callback.SubscribeListener;
import io.rocketchat.livechat.callback.TypingListener;
import io.rocketchat.livechat.middleware.LiveChatMiddleware;
import io.rocketchat.livechat.middleware.LiveChatStreamMiddleware;
import io.rocketchat.livechat.rpc.LiveChatBasicRPC;
import io.rocketchat.livechat.rpc.LiveChatHistoryRPC;
import io.rocketchat.livechat.rpc.LiveChatSendMsgRPC;
import io.rocketchat.livechat.rpc.LiveChatSubRPC;
import io.rocketchat.livechat.rpc.LiveChatTypingRPC;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class LiveChatAPI
extends Socket {
    AtomicInteger integer;
    String sessionId;
    JSONObject userInfo;
    WebSocketAdapter adapter = this.getAdapter();
    LiveChatMiddleware liveChatMiddleware;
    LiveChatStreamMiddleware liveChatStreamMiddleware;
    ConnectListener connectListener;
    ReconnectionStrategy strategy;
    private Timer timer;
    private boolean selfDisconnect = false;

    public LiveChatAPI(String url) {
        super(url);
        this.integer = new AtomicInteger(1);
        this.liveChatMiddleware = LiveChatMiddleware.getInstance();
        this.liveChatStreamMiddleware = LiveChatStreamMiddleware.getInstance();
    }

    public void setReconnectionStrategy(ReconnectionStrategy strategy) {
        this.strategy = strategy;
    }

    public void setConnectListener(ConnectListener connectListener) {
        this.connectListener = connectListener;
    }

    public void getInitialData(final InitialDataListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.GETINITIALDATA);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.getInitialData(uniqueID));
            }
        });
    }

    public void registerGuest(final String name, final String email, final String dept, final AuthListener.RegisterListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.REGISTER);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.registerGuest(uniqueID, name, email, dept));
            }
        });
    }

    public void login(final String token, final AuthListener.LoginListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.LOGIN);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.login(uniqueID, token));
            }
        });
    }

    public void connect(ConnectListener connectListener) {
        this.createSocket();
        this.ws.addListener((WebSocketListener)this.adapter);
        this.connectListener = connectListener;
        super.connectAsync();
    }

    public ChatRoom createRoom(String userID, String authToken) {
        String userName = this.userInfo.optString("username");
        String visitorToken = LiveChatBasicRPC.visitorToken;
        String roomID = Utils.shortUUID();
        return new ChatRoom(userName, roomID, userID, visitorToken, authToken);
    }

    public ChatRoom createRoom(String s) {
        return new ChatRoom(s);
    }

    public void disconnect() {
        this.ws.disconnect();
        this.selfDisconnect = true;
    }

    public void sendOfflineMessage(final String name, final String email, final String message) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.sendOfflineMessage(uniqueID, name, email, message));
            }
        });
    }

    public void sendOfflineMessage(final String name, final String email, final String message, final MessageListener.OfflineMessageListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.SENDOFFLINEMESSAGE);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.sendOfflineMessage(uniqueID, name, email, message));
            }
        });
    }

    private void getChatHistory(final String roomID, final int limit, final Date oldestMessageTimestamp, final Date lasttimestamp, final LoadHistoryListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.GETCHATHISTORY);
                LiveChatAPI.this.ws.sendText(LiveChatHistoryRPC.loadHistory(uniqueID, roomID, oldestMessageTimestamp, limit, lasttimestamp));
            }
        });
    }

    private void getAgentData(final String roomId, final AgentListener.AgentDataListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.GETAGENTDATA);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.getAgentData(uniqueID, roomId));
            }
        });
    }

    private void sendMessage(final String msgId, final String roomID, final String message, final String token) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.ws.sendText(LiveChatSendMsgRPC.sendMessage(uniqueID, msgId, roomID, message, token));
            }
        });
    }

    private void sendMessage(final String msgId, final String roomID, final String message, final String token, final MessageListener.MessageAckListener messageAckListener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, messageAckListener, LiveChatMiddleware.ListenerType.SENDMESSAGE);
                LiveChatAPI.this.ws.sendText(LiveChatSendMsgRPC.sendMessage(uniqueID, msgId, roomID, message, token));
            }
        });
    }

    private void sendIsTyping(final String roomId, final String username, final Boolean istyping) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.ws.sendText(LiveChatTypingRPC.streamNotifyRoom(uniqueID, roomId, username, istyping));
            }
        });
    }

    private void subscribeRoom(final String roomID, final Boolean enable, final SubscribeListener subscribeListener, final MessageListener.SubscriptionListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                String uniqueID = Utils.shortUUID();
                if (subscribeListener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeListener, LiveChatStreamMiddleware.SubType.STREAMROOMMESSAGES);
                }
                if (listener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.subscribeRoom(listener);
                }
                LiveChatAPI.this.ws.sendText(LiveChatSubRPC.streamRoomMessages(uniqueID, roomID, enable));
            }
        });
    }

    private void subscribeLiveChatRoom(final String roomID, final Boolean enable, final SubscribeListener subscribeListener, final AgentListener.AgentConnectListener agentConnectListener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                String uniqueID = Utils.shortUUID();
                if (subscribeListener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeListener, LiveChatStreamMiddleware.SubType.STREAMLIVECHATROOM);
                }
                if (agentConnectListener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.subscribeLiveChatRoom(agentConnectListener);
                }
                LiveChatAPI.this.ws.sendText(LiveChatSubRPC.streamLivechatRoom(uniqueID, roomID, enable));
            }
        });
    }

    private void subscribeTyping(final String roomID, final Boolean enable, final SubscribeListener subscribeListener, final TypingListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                String uniqueID = Utils.shortUUID();
                if (subscribeListener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeListener, LiveChatStreamMiddleware.SubType.NOTIFYROOM);
                }
                if (listener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.subscribeTyping(listener);
                }
                LiveChatAPI.this.ws.sendText(LiveChatSubRPC.subscribeTyping(uniqueID, roomID, enable));
            }
        });
    }

    private void closeConversation(final String roomId) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.closeConversation(uniqueID, roomId));
            }
        });
    }

    WebSocketAdapter getAdapter() {
        return new WebSocketAdapter(){

            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                System.out.println("Connected");
                LiveChatAPI.this.integer.set(1);
                websocket.sendText(LiveChatBasicRPC.ConnectObject());
                super.onConnected(websocket, headers);
            }

            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                System.out.println("Disconnected");
                if (LiveChatAPI.this.connectListener != null) {
                    LiveChatAPI.this.connectListener.onDisconnect(closedByServer);
                }
                if (LiveChatAPI.this.strategy != null && !LiveChatAPI.this.selfDisconnect) {
                    if (LiveChatAPI.this.strategy.getNumberOfAttempts() < LiveChatAPI.this.strategy.getMaxAttempts()) {
                        LiveChatAPI.this.timer = new Timer();
                        LiveChatAPI.this.timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                LiveChatAPI.this.reconnect();
                                LiveChatAPI.this.strategy.processAttempts();
                                LiveChatAPI.this.timer.cancel();
                                LiveChatAPI.this.timer.purge();
                            }
                        }, LiveChatAPI.this.strategy.getReconnectInterval());
                    } else {
                        System.out.println("Number of attempts are complete");
                    }
                } else {
                    LiveChatAPI.this.selfDisconnect = false;
                }
                super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, closedByServer);
            }

            public void onConnectError(WebSocket websocket, WebSocketException exception) throws Exception {
                System.out.println("Onconnect Error");
                if (LiveChatAPI.this.connectListener != null) {
                    LiveChatAPI.this.connectListener.onConnectError((Exception)((Object)exception));
                }
                super.onConnectError(websocket, exception);
            }

            public void onTextMessage(WebSocket websocket, String text) throws Exception {
                System.out.println("Message is " + text);
                JSONObject object = new JSONObject(text);
                switch (RPC.parse(object.optString("msg"))) {
                    case PING: {
                        websocket.sendText("{\"msg\":\"pong\"}");
                        break;
                    }
                    case CONNECTED: {
                        LiveChatAPI.this.sessionId = object.optString("session");
                        if (LiveChatAPI.this.connectListener == null) break;
                        LiveChatAPI.this.connectListener.onConnect(LiveChatAPI.this.sessionId);
                        break;
                    }
                    case ADDED: {
                        if (!object.optString("collection").equals("users")) break;
                        LiveChatAPI.this.userInfo = object.optJSONObject("fields");
                        break;
                    }
                    case RESULT: {
                        LiveChatAPI.this.liveChatMiddleware.processCallback(Long.valueOf(object.optString("id")), object);
                        break;
                    }
                    case READY: {
                        LiveChatAPI.this.liveChatStreamMiddleware.processSubSuccess(object);
                        break;
                    }
                    case CHANGED: {
                        LiveChatAPI.this.liveChatStreamMiddleware.processCallback(object);
                        break;
                    }
                }
                super.onTextMessage(websocket, text);
            }
        };
    }

    public class ChatRoom {
        String userName;
        String roomId;
        String userId;
        String visitorToken;
        String authToken;

        public ChatRoom(String userName, String roomId, String userId, String visitorToken, String authToken) {
            this.userName = userName;
            this.roomId = roomId;
            this.userId = userId;
            this.visitorToken = visitorToken;
            this.authToken = authToken;
        }

        public ChatRoom(String s) {
            try {
                JSONObject object = new JSONObject(s);
                this.userName = object.getString("userName");
                this.roomId = object.getString("roomId");
                this.userId = object.getString("userId");
                this.visitorToken = object.getString("visitorToken");
                this.authToken = object.getString("authToken");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        public void login(AuthListener.LoginListener listener) {
            LiveChatAPI.this.login(this.authToken, listener);
        }

        public void getChatHistory(int limit, Date oldestMessageTimestamp, Date lasttimestamp, LoadHistoryListener listener) {
            LiveChatAPI.this.getChatHistory(this.roomId, limit, oldestMessageTimestamp, lasttimestamp, listener);
        }

        public void getAgentData(AgentListener.AgentDataListener listener) {
            LiveChatAPI.this.getAgentData(this.roomId, listener);
        }

        public String sendMessage(String message) {
            String uuid = Utils.shortUUID();
            LiveChatAPI.this.sendMessage(uuid, this.roomId, message, this.visitorToken);
            return uuid;
        }

        public String sendMessage(String message, MessageListener.MessageAckListener messageAckListener) {
            String uuid = Utils.shortUUID();
            LiveChatAPI.this.sendMessage(uuid, this.roomId, message, this.visitorToken, messageAckListener);
            return uuid;
        }

        public void sendIsTyping(Boolean istyping) {
            LiveChatAPI.this.sendIsTyping(this.roomId, this.userName, istyping);
        }

        public void subscribeRoom(SubscribeListener subscribeListener, MessageListener.SubscriptionListener listener) {
            LiveChatAPI.this.subscribeRoom(this.roomId, false, subscribeListener, listener);
        }

        public void subscribeLiveChatRoom(SubscribeListener subscribeListener, AgentListener.AgentConnectListener agentConnectListener) {
            LiveChatAPI.this.subscribeLiveChatRoom(this.roomId, false, subscribeListener, agentConnectListener);
        }

        public void subscribeTyping(SubscribeListener subscribeListener, TypingListener listener) {
            LiveChatAPI.this.subscribeTyping(this.roomId, false, subscribeListener, listener);
        }

        public void closeConversation() {
            LiveChatAPI.this.closeConversation(this.roomId);
        }

        public String getUserName() {
            return this.userName;
        }

        public String getRoomId() {
            return this.roomId;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getVisitorToken() {
            return this.visitorToken;
        }

        public String getAuthToken() {
            return this.authToken;
        }

        public String toString() {
            return "{\"userName\":\"" + this.userName + '\"' + ",\"roomId\":\"" + this.roomId + '\"' + ",\"userId\":\"" + this.userId + '\"' + ",\"visitorToken\":\"" + this.visitorToken + '\"' + ",\"authToken\":\"" + this.authToken + '\"' + '}';
        }
    }
}

