/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat.middleware;

import io.rocketchat.livechat.callback.AgentListener;
import io.rocketchat.livechat.callback.MessageListener;
import io.rocketchat.livechat.callback.SubscribeListener;
import io.rocketchat.livechat.callback.TypingListener;
import io.rocketchat.livechat.model.AgentObject;
import io.rocketchat.livechat.model.MessageObject;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class LiveChatStreamMiddleware {
    public static LiveChatStreamMiddleware middleware = new LiveChatStreamMiddleware();
    MessageListener.SubscriptionListener subscriptionListener;
    AgentListener.AgentConnectListener agentConnectListener;
    TypingListener typingListener;
    ConcurrentHashMap<String, Object[]> subcallbacks = new ConcurrentHashMap();

    LiveChatStreamMiddleware() {
    }

    public static LiveChatStreamMiddleware getInstance() {
        return middleware;
    }

    public void subscribeRoom(MessageListener.SubscriptionListener subscription) {
        this.subscriptionListener = subscription;
    }

    public void subscribeLiveChatRoom(AgentListener.AgentConnectListener agentConnectListener) {
        this.agentConnectListener = agentConnectListener;
    }

    public void subscribeTyping(TypingListener callback) {
        this.typingListener = callback;
    }

    public void createSubCallbacks(String id, SubscribeListener callback, SubType subscription) {
        this.subcallbacks.put(id, new Object[]{callback, subscription});
    }

    public void processCallback(JSONObject object) {
        String s = object.optString("collection");
        JSONArray array = object.optJSONObject("fields").optJSONArray("args");
        switch (LiveChatStreamMiddleware.parse(s)) {
            case STREAMROOMMESSAGES: {
                if (this.subscriptionListener == null) break;
                MessageObject messageObject = new MessageObject(array.optJSONObject(0));
                String roomId = object.optJSONObject("fields").optString("eventName");
                if (messageObject.getMessagetype().equals(MessageObject.MESSAGE_TYPE_CLOSE)) {
                    this.subscriptionListener.onAgentDisconnect(roomId, messageObject);
                    break;
                }
                this.subscriptionListener.onMessage(roomId, messageObject);
                break;
            }
            case STREAMLIVECHATROOM: {
                if (this.agentConnectListener == null) break;
                this.agentConnectListener.onAgentConnect(new AgentObject(array.optJSONObject(0).optJSONObject("data")));
                break;
            }
            case NOTIFYROOM: {
                if (this.typingListener == null) break;
                this.typingListener.onTyping(object.optJSONObject("fields").optString("eventName"), array.optString(0), array.optBoolean(1));
            }
        }
    }

    public void processSubSuccess(JSONObject subObj) {
        String id;
        if (subObj.optJSONArray("subs") != null && this.subcallbacks.containsKey(id = subObj.optJSONArray("subs").optString(0))) {
            Object[] object = this.subcallbacks.remove(id);
            SubscribeListener subscribeListener = (SubscribeListener)object[0];
            SubType subscription = (SubType)((Object)object[1]);
            subscribeListener.onSubscribe(subscription, id);
        }
    }

    public static SubType parse(String s) {
        if (s.equals("stream-room-messages")) {
            return SubType.STREAMROOMMESSAGES;
        }
        if (s.equals("stream-livechat-room")) {
            return SubType.STREAMLIVECHATROOM;
        }
        return SubType.NOTIFYROOM;
    }

    public static enum SubType {
        STREAMROOMMESSAGES,
        STREAMLIVECHATROOM,
        NOTIFYROOM;

    }
}

