/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.common.network;

import com.neovisionaries.ws.client.OpeningHandshakeException;
import com.neovisionaries.ws.client.StatusLine;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class Socket {
    String url;
    WebSocketFactory factory;
    protected WebSocket ws;

    protected Socket(String url) {
        this.url = url;
        this.factory = new WebSocketFactory().setConnectionTimeout(5000);
    }

    protected void createSocket() {
        try {
            this.ws = this.factory.createSocket(this.url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.ws.addExtension("permessage-deflate; client_max_window_bits");
        this.ws.addHeader("Accept-Encoding", "gzip, deflate, sdch");
        this.ws.addHeader("Accept-Language", "en-US,en;q=0.8");
        this.ws.addHeader("Pragma", "no-cache");
        this.ws.addHeader("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.87 Safari/537.36");
    }

    protected void connect() {
        try {
            this.ws.connect();
        }
        catch (OpeningHandshakeException e) {
            StatusLine sl = e.getStatusLine();
            System.out.println("=== Status Line ===");
            System.out.format("HTTP Version  = %s\n", sl.getHttpVersion());
            System.out.format("Status Code   = %d\n", sl.getStatusCode());
            System.out.format("Reason Phrase = %s\n", sl.getReasonPhrase());
            Map headers = e.getHeaders();
            System.out.println("=== HTTP Headers ===");
            for (Map.Entry entry : headers.entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                if (values == null || values.size() == 0) {
                    System.out.println(name);
                    continue;
                }
                for (String value : values) {
                    System.out.format("%s: %s\n", name, value);
                }
            }
        }
        catch (WebSocketException e) {
            System.out.println("Got websocket exception " + e.getMessage());
        }
    }

    protected void connectAsync() {
        this.ws.connectAsynchronously();
    }

    public void reconnect() {
        try {
            this.ws = this.ws.recreate(5000).connectAsynchronously();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

