/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat.middleware;

import io.rocketchat.livechat.callback.AgentListener;
import io.rocketchat.livechat.callback.AuthListener;
import io.rocketchat.livechat.callback.InitialDataListener;
import io.rocketchat.livechat.callback.Listener;
import io.rocketchat.livechat.callback.LoadHistoryListener;
import io.rocketchat.livechat.model.AgentObject;
import io.rocketchat.livechat.model.GuestObject;
import io.rocketchat.livechat.model.LiveChatConfigObject;
import io.rocketchat.livechat.model.MessageObject;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class LiveChatMiddleware {
    ConcurrentHashMap<Long, Object[]> callbacks = new ConcurrentHashMap();
    private static LiveChatMiddleware middleware = new LiveChatMiddleware();

    private LiveChatMiddleware() {
    }

    public static LiveChatMiddleware getInstance() {
        return middleware;
    }

    public void createCallback(long i, Listener listener, ListenerType type) {
        this.callbacks.put(i, new Object[]{listener, type});
    }

    public void processCallback(long i, JSONObject object) {
        if (this.callbacks.containsKey(i)) {
            Object[] objects = this.callbacks.remove(i);
            Listener listener = (Listener)objects[0];
            ListenerType type = (ListenerType)((Object)objects[1]);
            JSONObject result = object.optJSONObject("result");
            switch (type) {
                case GETINITIALDATA: {
                    InitialDataListener dataListener = (InitialDataListener)listener;
                    LiveChatConfigObject liveChatConfigObject = new LiveChatConfigObject(result);
                    dataListener.onInitialData(liveChatConfigObject);
                    break;
                }
                case REGISTER: {
                    AuthListener.RegisterListener registerListener = (AuthListener.RegisterListener)listener;
                    GuestObject guestObject = new GuestObject(result);
                    registerListener.onRegister(guestObject);
                    break;
                }
                case LOGIN: {
                    AuthListener.LoginListener loginListener = (AuthListener.LoginListener)listener;
                    GuestObject guestObject = new GuestObject(result);
                    loginListener.onLogin(guestObject);
                    break;
                }
                case GETCHATHISTORY: {
                    ArrayList<MessageObject> list = new ArrayList<MessageObject>();
                    LoadHistoryListener historyListener = (LoadHistoryListener)listener;
                    JSONArray array = result.optJSONArray("messages");
                    for (int j = 0; j < array.length(); ++j) {
                        list.add(new MessageObject(array.optJSONObject(j)));
                    }
                    int unreadNotLoaded = object.optJSONObject("result").optInt("unreadNotLoaded");
                    historyListener.onLoadHistory(list, unreadNotLoaded);
                    break;
                }
                case GETAGENTDATA: {
                    AgentListener.AgentDataListener agentDataListener = (AgentListener.AgentDataListener)listener;
                    AgentObject agentObject = new AgentObject(result);
                    agentDataListener.onAgentData(agentObject);
                }
            }
        }
    }

    public static enum ListenerType {
        GETINITIALDATA,
        REGISTER,
        LOGIN,
        GETCHATHISTORY,
        GETAGENTDATA;

    }
}

