/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.core;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketListener;
import io.rocketchat.common.network.Socket;
import io.rocketchat.core.rpc.BasicRPC;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class RocketChatAPI
extends Socket {
    AtomicInteger integer;
    String sessionId;
    WebSocketAdapter adapter = this.getAdapter();

    public RocketChatAPI(String url) {
        super(url);
        this.integer = new AtomicInteger(1);
    }

    @Override
    public void connect() {
        this.createSocket();
        this.ws.addListener((WebSocketListener)this.adapter);
        super.connect();
    }

    WebSocketAdapter getAdapter() {
        return new WebSocketAdapter(){

            public void onTextMessage(WebSocket websocket, String text) throws Exception {
                JSONObject object = new JSONObject(text);
                if (object.has("server_id")) {
                    websocket.sendText(BasicRPC.ConnectObject());
                } else {
                    if (object.optString("msg").equals("ping")) {
                        websocket.sendText("{\"msg\":\"pong\"}");
                    } else if (object.optString("msg").equals("connected")) {
                        RocketChatAPI.this.sessionId = object.optString("session");
                        System.out.println("session id is " + RocketChatAPI.this.sessionId);
                    }
                    System.out.println("Message is " + text);
                }
                super.onTextMessage(websocket, text);
            }
        };
    }
}

