/*
 * Decompiled with CFR 0.152.
 */
import io.rocketchat.livechat.LiveChatAPI;
import io.rocketchat.livechat.callback.AuthListener;
import io.rocketchat.livechat.callback.ConnectListener;
import io.rocketchat.livechat.model.GuestObject;

public class Main
implements ConnectListener,
AuthListener.LoginListener,
AuthListener.RegisterListener {
    private LiveChatAPI liveChat;
    private LiveChatAPI.ChatRoom room;
    private static String serverurl = "wss://livechattest.rocket.chat/websocket";
    private static String localurl = "wss://localhost:3000/websocket";

    public void call() {
        this.liveChat = new LiveChatAPI(serverurl);
        this.liveChat.setReconnectionStrategy(null);
        this.liveChat.connect(this);
    }

    public static void main(String[] args) {
        new Main().call();
    }

    @Override
    public void onConnect(String sessionID) {
        System.out.println("Connected to server");
        this.liveChat.registerGuest("shreyash", "shreyash@gmail.com", null, this);
    }

    @Override
    public void onDisconnect(boolean closedByServer) {
        System.out.println("Disconnected from server");
    }

    @Override
    public void onConnectError(Exception websocketException) {
        System.out.println("Got connect error with the server");
    }

    @Override
    public void onLogin(GuestObject object) {
        System.out.println("login is successful");
        this.room = this.liveChat.createRoom(object.getUserID(), object.getToken());
        this.room.sendMessage("Hi there");
    }

    @Override
    public void onRegister(GuestObject object) {
        this.liveChat.login(object.getToken(), this);
    }
}

