/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import com.neovisionaries.ws.client.WebSocketState;
import io.rocketchat.common.network.EventThread;
import io.rocketchat.common.network.Socket;
import io.rocketchat.common.utils.Utils;
import io.rocketchat.livechat.callback.AgentListener;
import io.rocketchat.livechat.callback.AuthListener;
import io.rocketchat.livechat.callback.ConnectListener;
import io.rocketchat.livechat.callback.InitialDataListener;
import io.rocketchat.livechat.callback.LoadHistoryListener;
import io.rocketchat.livechat.callback.MessageListener;
import io.rocketchat.livechat.callback.SubscribeListener;
import io.rocketchat.livechat.callback.TypingListener;
import io.rocketchat.livechat.middleware.LiveChatMiddleware;
import io.rocketchat.livechat.middleware.LiveChatStreamMiddleware;
import io.rocketchat.livechat.rpc.LiveChatBasicRPC;
import io.rocketchat.livechat.rpc.LiveChatHistoryRPC;
import io.rocketchat.livechat.rpc.LiveChatSendMsgRPC;
import io.rocketchat.livechat.rpc.LiveChatSubRPC;
import io.rocketchat.livechat.rpc.LiveChatTypingRPC;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class LiveChatAPI
extends Socket {
    AtomicInteger integer;
    String sessionId;
    public JSONObject userInfo;
    WebSocketListener listener = this.getListener();
    LiveChatMiddleware liveChatMiddleware;
    LiveChatStreamMiddleware liveChatStreamMiddleware;
    ConnectListener connectListener;

    public LiveChatAPI(String url) {
        super(url);
        this.integer = new AtomicInteger(1);
        this.liveChatMiddleware = LiveChatMiddleware.getInstance();
        this.liveChatStreamMiddleware = LiveChatStreamMiddleware.getInstance();
    }

    public void getInitialData(final InitialDataListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.GETINITIALDATA);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.getInitialData(uniqueID));
            }
        });
    }

    public void registerGuest(final String name, final String email, final String dept, final AuthListener.RegisterListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.REGISTER);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.registerGuest(uniqueID, name, email, dept));
            }
        });
    }

    public void login(final String token, final AuthListener.LoginListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.LOGIN);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.login(uniqueID, token));
            }
        });
    }

    private void getChatHistory(final String roomID, final int limit, final Date oldestMessageTimestamp, final Date lasttimestamp, final LoadHistoryListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.GETCHATHISTORY);
                LiveChatAPI.this.ws.sendText(LiveChatHistoryRPC.loadHistory(uniqueID, roomID, oldestMessageTimestamp, limit, lasttimestamp));
            }
        });
    }

    private void getAgentData(final String roomId, final AgentListener.AgentDataListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, listener, LiveChatMiddleware.ListenerType.GETAGENTDATA);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.getAgentData(uniqueID, roomId));
            }
        });
    }

    private void sendMessage(final String msgId, final String roomID, final String message, final String token) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.ws.sendText(LiveChatSendMsgRPC.sendMessage(uniqueID, msgId, roomID, message, token));
            }
        });
    }

    private void sendIsTyping(final String roomId, final String username, final Boolean istyping) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.ws.sendText(LiveChatTypingRPC.streamNotifyRoom(uniqueID, roomId, username, istyping));
            }
        });
    }

    private void subscribeRoom(final String roomID, final Boolean enable, final SubscribeListener subscribeListener, final MessageListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                String uniqueID = Utils.shortUUID();
                if (subscribeListener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeListener, LiveChatStreamMiddleware.SubType.STREAMROOMMESSAGES);
                }
                if (listener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.subscribeRoom(listener);
                }
                LiveChatAPI.this.ws.sendText(LiveChatSubRPC.streamRoomMessages(uniqueID, roomID, enable));
            }
        });
    }

    private void subscribeLiveChatRoom(final String roomID, final Boolean enable, final SubscribeListener subscribeListener, final AgentListener.AgentConnectListener agentConnectListener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                String uniqueID = Utils.shortUUID();
                if (subscribeListener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeListener, LiveChatStreamMiddleware.SubType.STREAMLIVECHATROOM);
                }
                if (agentConnectListener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.subscribeLiveChatRoom(agentConnectListener);
                }
                LiveChatAPI.this.ws.sendText(LiveChatSubRPC.streamLivechatRoom(uniqueID, roomID, enable));
            }
        });
    }

    private void subscribeTyping(final String roomID, final Boolean enable, final SubscribeListener subscribeListener, final TypingListener listener) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                String uniqueID = Utils.shortUUID();
                if (subscribeListener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeListener, LiveChatStreamMiddleware.SubType.NOTIFYROOM);
                }
                if (listener != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.subscribeTyping(listener);
                }
                LiveChatAPI.this.ws.sendText(LiveChatSubRPC.subscribeTyping(uniqueID, roomID, enable));
            }
        });
    }

    private void closeConversation(final String roomId) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.closeConversation(uniqueID, roomId));
            }
        });
    }

    @Override
    public void connect() {
        this.createWebsocketfactory();
        this.ws.addListener(this.listener);
        super.connect();
    }

    public void connectAsync(ConnectListener connectListener) {
        this.createWebsocketfactory();
        this.ws.addListener(this.listener);
        this.connectListener = connectListener;
        super.connectAsync();
    }

    WebSocketListener getListener() {
        return new WebSocketListener(){

            public void onStateChanged(WebSocket websocket, WebSocketState newState) throws Exception {
            }

            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                LiveChatAPI.this.integer.set(1);
                websocket.sendText(LiveChatBasicRPC.ConnectObject());
                System.out.println("Connected to server");
            }

            public void onConnectError(WebSocket websocket, WebSocketException cause) throws Exception {
                System.out.println("got connect error");
            }

            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                System.out.println("Disconnected to server");
                if (LiveChatAPI.this.connectListener != null) {
                    LiveChatAPI.this.connectListener.onDisconnect(closedByServer);
                }
            }

            public void onFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onContinuationFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("on continuation frame");
            }

            public void onTextFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onBinaryFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("on binary frame");
            }

            public void onCloseFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("On close frame");
            }

            public void onPingFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("On ping frame" + frame.getPayloadText());
            }

            public void onPongFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("on pong frame");
            }

            public void onTextMessage(WebSocket websocket, String text) throws Exception {
                System.out.println("Message is " + text);
                JSONObject object = new JSONObject(text);
                if (object.optString("msg").equals("ping")) {
                    websocket.sendText("{\"msg\":\"pong\"}");
                } else if (object.optString("msg").equals("connected")) {
                    LiveChatAPI.this.sessionId = object.optString("session");
                    if (LiveChatAPI.this.connectListener != null) {
                        LiveChatAPI.this.connectListener.onConnect(LiveChatAPI.this.sessionId);
                    }
                } else if (object.optString("msg").equals("added")) {
                    if (object.optString("collection") != null && object.optString("collection").equals("users")) {
                        LiveChatAPI.this.userInfo = object.optJSONObject("fields");
                    }
                } else if (Utils.isInteger(object.optString("id"))) {
                    LiveChatAPI.this.liveChatMiddleware.processCallback(Long.valueOf(object.optString("id")), object);
                } else if (object.optString("msg").equals("ready")) {
                    LiveChatAPI.this.liveChatStreamMiddleware.processSubSuccess(object);
                } else if (object.optString("msg").equals("changed")) {
                    LiveChatAPI.this.liveChatStreamMiddleware.processCallback(object);
                }
            }

            public void onBinaryMessage(WebSocket websocket, byte[] binary) throws Exception {
                System.out.println("on binary message");
            }

            public void onSendingFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onFrameSent(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onFrameUnsent(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("on frame unsent");
            }

            public void onError(WebSocket websocket, WebSocketException cause) throws Exception {
                System.out.println("On error");
            }

            public void onFrameError(WebSocket websocket, WebSocketException cause, WebSocketFrame frame) throws Exception {
                System.out.println("On frame error");
            }

            public void onMessageError(WebSocket websocket, WebSocketException cause, List<WebSocketFrame> frames) throws Exception {
                System.out.println("On message error");
            }

            public void onMessageDecompressionError(WebSocket websocket, WebSocketException cause, byte[] compressed) throws Exception {
                System.out.println("on message decompression error");
            }

            public void onTextMessageError(WebSocket websocket, WebSocketException cause, byte[] data) throws Exception {
                System.out.println("on text message error");
            }

            public void onSendError(WebSocket websocket, WebSocketException cause, WebSocketFrame frame) throws Exception {
                System.out.println("on send error");
            }

            public void onUnexpectedError(WebSocket websocket, WebSocketException cause) throws Exception {
                System.out.println("on unexpected error");
            }

            public void handleCallbackError(WebSocket websocket, Throwable cause) throws Exception {
                System.out.println("handle callback error");
            }

            public void onSendingHandshake(WebSocket websocket, String requestLine, List<String[]> headers) throws Exception {
            }
        };
    }

    public ChatRoom createRoom(String userID, String authToken) {
        String userName = this.userInfo.optString("username");
        String visitorToken = LiveChatBasicRPC.visitorToken;
        String roomID = Utils.shortUUID();
        return new ChatRoom(userName, roomID, userID, visitorToken, authToken);
    }

    public class ChatRoom {
        String userName;
        String roomId;
        String userId;
        String visitorToken;
        String authToken;

        public ChatRoom(String userName, String roomId, String userId, String visitorToken, String authToken) {
            this.userName = userName;
            this.roomId = roomId;
            this.userId = userId;
            this.visitorToken = visitorToken;
            this.authToken = authToken;
        }

        public void login(AuthListener.LoginListener listener) {
            LiveChatAPI.this.login(this.authToken, listener);
        }

        public void getChatHistory(int limit, Date oldestMessageTimestamp, Date lasttimestamp, LoadHistoryListener listener) {
            LiveChatAPI.this.getChatHistory(this.roomId, limit, oldestMessageTimestamp, lasttimestamp, listener);
        }

        public void getAgentData(AgentListener.AgentDataListener listener) {
            LiveChatAPI.this.getAgentData(this.roomId, listener);
        }

        public void sendMessage(String message) {
            LiveChatAPI.this.sendMessage(Utils.shortUUID(), this.roomId, message, this.visitorToken);
        }

        public void sendIsTyping(Boolean istyping) {
            LiveChatAPI.this.sendIsTyping(this.roomId, this.userName, istyping);
        }

        public void subscribeRoom(SubscribeListener subscribeListener, MessageListener listener) {
            LiveChatAPI.this.subscribeRoom(this.roomId, false, subscribeListener, listener);
        }

        public void subscribeLiveChatRoom(SubscribeListener subscribeListener, AgentListener.AgentConnectListener agentConnectListener) {
            LiveChatAPI.this.subscribeLiveChatRoom(this.roomId, false, subscribeListener, agentConnectListener);
        }

        public void subscribeTyping(SubscribeListener subscribeListener, TypingListener listener) {
            LiveChatAPI.this.subscribeTyping(this.roomId, false, subscribeListener, listener);
        }

        public void closeConversation() {
            LiveChatAPI.this.closeConversation(this.roomId);
        }

        public String toString() {
            return "ChatRoom{userName='" + this.userName + '\'' + ", roomId='" + this.roomId + '\'' + ", userId='" + this.userId + '\'' + ", visitorToken='" + this.visitorToken + '\'' + ", authToken='" + this.authToken + '\'' + '}';
        }

        public String getUserName() {
            return this.userName;
        }

        public String getRoomId() {
            return this.roomId;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getVisitorToken() {
            return this.visitorToken;
        }

        public String getAuthToken() {
            return this.authToken;
        }
    }
}

