/*
 * Decompiled with CFR 0.152.
 */
import io.rocketchat.livechat.LiveChatAPI;
import io.rocketchat.livechat.callback.AgentListener;
import io.rocketchat.livechat.callback.AuthListener;
import io.rocketchat.livechat.callback.ConnectListener;
import io.rocketchat.livechat.callback.InitialDataListener;
import io.rocketchat.livechat.callback.LoadHistoryListener;
import io.rocketchat.livechat.callback.MessageListener;
import io.rocketchat.livechat.model.AgentObject;
import io.rocketchat.livechat.model.GuestObject;
import io.rocketchat.livechat.model.LiveChatConfigObject;
import io.rocketchat.livechat.model.MessageObject;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class Main
implements ConnectListener,
AuthListener.LoginListener,
LoadHistoryListener,
InitialDataListener,
AuthListener.RegisterListener,
AgentListener.AgentConnectListener,
MessageListener {
    private LiveChatAPI liveChat;
    private LiveChatAPI.ChatRoom chatRoom;

    public void call() {
        this.liveChat = new LiveChatAPI("ws://localhost:3000/websocket");
        this.liveChat.connectAsync(this);
    }

    public static void main(String[] args) {
        new Main().call();
    }

    @Override
    public void onConnect(String sessionID) {
        this.liveChat.getInitialData(this);
        this.liveChat.registerGuest("ironman", "ironman@gmail.com", null, this);
    }

    @Override
    public void onDisconnect(boolean closedByServer) {
    }

    @Override
    public void onLoadHistory(ArrayList<MessageObject> list, int unreadNotLoaded) {
        System.out.println("Messages received");
    }

    @Override
    public void onLogin(GuestObject object) {
        this.chatRoom = this.liveChat.createRoom(object.getUserID(), object.getToken());
        this.chatRoom.subscribeLiveChatRoom(null, this);
        System.out.println("Chatroom is " + this.chatRoom);
        this.chatRoom.sendMessage("Hi, anyone there please?");
    }

    @Override
    public void onInitialData(LiveChatConfigObject object) {
        System.out.println("Initial data is " + object);
    }

    @Override
    public void onRegister(GuestObject object) {
        System.out.println("Registration success " + object);
        this.liveChat.login(object.getToken(), this);
    }

    @Override
    public void onAgentConnect(AgentObject agentObject) {
        System.out.println("New agent got connected" + agentObject.getUsername());
        this.chatRoom.subscribeRoom(null, this);
    }

    @Override
    public void onMessage(String roomId, MessageObject object) {
        System.out.println("got message " + object.getMessage());
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Main.this.chatRoom.closeConversation();
            }
        }, 2000L);
    }

    @Override
    public void onAgentDisconnect(String roomId, MessageObject object) {
        System.out.println("Agent got disconnected");
    }
}

