/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat.model;

import io.rocketchat.common.data.model.UserObject;
import java.sql.Timestamp;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageObject {
    String messageId;
    String roomId;
    String message;
    String visitorToken;
    String senderAlias;
    Date msgTimestamp;
    UserObject sender;
    Date updatedAt;
    Boolean newRoom;
    Boolean showConnecting;
    String sandstormSessionId;
    Date editedAt;
    UserObject editedBy;
    String messagetype;

    public MessageObject(JSONObject object) {
        try {
            this.messageId = object.optString("_id");
            this.roomId = object.optString("rid");
            this.message = object.optString("msg");
            this.visitorToken = object.optString("token");
            this.senderAlias = object.optString("alias");
            if (object.optJSONObject("ts") != null) {
                this.msgTimestamp = new Date(new Timestamp(object.getJSONObject("ts").getLong("$date")).getTime());
            }
            this.sender = new UserObject(object.optJSONObject("u"));
            this.updatedAt = new Date(new Timestamp(object.getJSONObject("_updatedAt").getLong("$date")).getTime());
            this.newRoom = object.optBoolean("newRoom");
            this.showConnecting = object.optBoolean("showConnecting");
            this.sandstormSessionId = object.optString("sandstormSessionId");
            if (object.optJSONObject("editedAt") != null) {
                this.editedAt = new Date(new Timestamp(object.getJSONObject("editedAt").getLong("$date")).getTime());
                this.editedBy = new UserObject(object.getJSONObject("editedBy"));
            }
            this.messagetype = object.optString("t");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getVisitorToken() {
        return this.visitorToken;
    }

    public void setVisitorToken(String visitorToken) {
        this.visitorToken = visitorToken;
    }

    public String getSenderAlias() {
        return this.senderAlias;
    }

    public void setSenderAlias(String senderAlias) {
        this.senderAlias = senderAlias;
    }

    public Date getMsgTimestamp() {
        return this.msgTimestamp;
    }

    public void setMsgTimestamp(Date msgTimestamp) {
        this.msgTimestamp = msgTimestamp;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Boolean getNewRoom() {
        return this.newRoom;
    }

    public void setNewRoom(Boolean newRoom) {
        this.newRoom = newRoom;
    }

    public Boolean getShowConnecting() {
        return this.showConnecting;
    }

    public void setShowConnecting(Boolean showConnecting) {
        this.showConnecting = showConnecting;
    }

    public String getSandstormSessionId() {
        return this.sandstormSessionId;
    }

    public void setSandstormSessionId(String sandstormSessionId) {
        this.sandstormSessionId = sandstormSessionId;
    }

    public Date getEditedAt() {
        return this.editedAt;
    }

    public void setEditedAt(Date editedAt) {
        this.editedAt = editedAt;
    }

    public UserObject getSender() {
        return this.sender;
    }

    public void setSender(UserObject sender) {
        this.sender = sender;
    }

    public UserObject getEditedBy() {
        return this.editedBy;
    }

    public void setEditedBy(UserObject editedBy) {
        this.editedBy = editedBy;
    }

    public String getMessagetype() {
        return this.messagetype;
    }

    public void setMessagetype(String messagetype) {
        this.messagetype = messagetype;
    }

    public String toString() {
        return "MessageObject{messageId='" + this.messageId + '\'' + ", roomId='" + this.roomId + '\'' + ", message='" + this.message + '\'' + ", visitorToken='" + this.visitorToken + '\'' + ", senderAlias='" + this.senderAlias + '\'' + ", msgTimestamp=" + this.msgTimestamp + ", sender=" + this.sender + ", updatedAt=" + this.updatedAt + ", newRoom=" + this.newRoom + ", showConnecting=" + this.showConnecting + ", sandstormSessionId='" + this.sandstormSessionId + '\'' + ", editedAt=" + this.editedAt + ", editedBy=" + this.editedBy + ", messagetype='" + this.messagetype + '\'' + '}';
    }
}

