/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat.middleware;

import io.rocketchat.livechat.callback.AgentCallback;
import io.rocketchat.livechat.callback.MessageCallback;
import io.rocketchat.livechat.callback.SubscribeCallback;
import io.rocketchat.livechat.callback.TypingCallback;
import io.rocketchat.livechat.middleware.LiveChatMiddleware;
import io.rocketchat.livechat.model.AgentObject;
import io.rocketchat.livechat.model.MessageObject;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class LiveChatStreamMiddleware {
    public static LiveChatStreamMiddleware middleware = new LiveChatStreamMiddleware();
    MessageCallback messageCallback;
    AgentCallback agentCallback;
    TypingCallback typingCallback;
    ConcurrentHashMap<String, Object[]> subcallbacks = new ConcurrentHashMap();

    LiveChatStreamMiddleware() {
    }

    public static LiveChatStreamMiddleware getInstance() {
        return middleware;
    }

    public void subscribeRoom(MessageCallback messageCallback) {
        this.messageCallback = messageCallback;
    }

    public void subscribeLiveChatRoom(AgentCallback agentCallback) {
        this.agentCallback = agentCallback;
    }

    public void subscribeTyping(TypingCallback callback) {
        this.typingCallback = callback;
    }

    public void createSubCallbacks(String id, SubscribeCallback callback, subscriptiontype subscription) {
        this.subcallbacks.put(id, new Object[]{callback, subscription});
    }

    public void processCallback(JSONObject object) {
        String s = object.optString("collection");
        JSONArray array = object.optJSONObject("fields").optJSONArray("args");
        if (s.equals("stream-room-messages")) {
            if (this.messageCallback != null) {
                this.messageCallback.call(object.optJSONObject("fields").optString("eventName"), new MessageObject(array.optJSONObject(0)));
            }
        } else if (s.equals("stream-livechat-room")) {
            if (this.agentCallback != null) {
                this.agentCallback.call(LiveChatMiddleware.AgentCallbackType.STREAMLIVECHATROOM, new AgentObject(array.optJSONObject(0)));
            }
        } else if (this.typingCallback != null) {
            this.typingCallback.call(object.optJSONObject("fields").optString("eventName"), array.optString(0), array.optBoolean(1));
        }
    }

    public void processSubSuccess(JSONObject subObj) {
        String id;
        if (subObj.optJSONArray("subs") != null && this.subcallbacks.containsKey(id = subObj.optJSONArray("subs").optString(0))) {
            Object[] object = this.subcallbacks.remove(id);
            SubscribeCallback subscribeCallback = (SubscribeCallback)object[0];
            subscriptiontype subscription = (subscriptiontype)((Object)object[1]);
            subscribeCallback.onSubscribe(subscription, id);
        }
    }

    public static enum subscriptiontype {
        STREAMROOMMESSAGES,
        STREAMLIVECHATROOM,
        NOTIFYROOM;

    }
}

