/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat.middleware;

import io.rocketchat.livechat.callback.AgentCallback;
import io.rocketchat.livechat.callback.Callback;
import io.rocketchat.livechat.callback.GuestCallback;
import io.rocketchat.livechat.callback.HistoryCallback;
import io.rocketchat.livechat.callback.InitialDataCallback;
import io.rocketchat.livechat.model.AgentObject;
import io.rocketchat.livechat.model.GuestObject;
import io.rocketchat.livechat.model.LiveChatConfigObject;
import io.rocketchat.livechat.model.MessageObject;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class LiveChatMiddleware {
    ConcurrentHashMap<Long, Object[]> callbacks = new ConcurrentHashMap();
    private static LiveChatMiddleware middleware = new LiveChatMiddleware();

    private LiveChatMiddleware() {
    }

    public static LiveChatMiddleware getInstance() {
        return middleware;
    }

    public void createCallback(long i, Callback callback, CallbackType type) {
        this.callbacks.put(i, new Object[]{callback, type});
    }

    public void processCallback(long i, JSONObject object) {
        if (this.callbacks.containsKey(i)) {
            Object[] objects = this.callbacks.remove(i);
            Callback callback = (Callback)objects[0];
            CallbackType type = (CallbackType)((Object)objects[1]);
            switch (type) {
                case GETINITIALDATA: {
                    InitialDataCallback dataCallback = (InitialDataCallback)callback;
                    LiveChatConfigObject liveChatConfigObject = new LiveChatConfigObject(object.optJSONObject("result"));
                    dataCallback.call(liveChatConfigObject);
                    break;
                }
                case REGISTER: {
                    GuestCallback guestCallback = (GuestCallback)callback;
                    GuestObject guestObject = new GuestObject(object.optJSONObject("result"));
                    guestCallback.call(CallbackType.REGISTER, guestObject);
                    break;
                }
                case LOGIN: {
                    GuestCallback guestCallback = (GuestCallback)callback;
                    GuestObject guestObject = new GuestObject(object.optJSONObject("result"));
                    guestCallback.call(CallbackType.LOGIN, guestObject);
                    break;
                }
                case GETCHATHISTORY: {
                    ArrayList<MessageObject> list = new ArrayList<MessageObject>();
                    HistoryCallback historymessages = (HistoryCallback)callback;
                    JSONArray array = object.optJSONObject("result").optJSONArray("messages");
                    for (int j = 0; j < array.length(); ++j) {
                        list.add(new MessageObject(array.optJSONObject(j)));
                    }
                    int unreadNotLoaded = object.optJSONObject("result").optInt("unreadNotLoaded");
                    historymessages.call(list, unreadNotLoaded);
                    break;
                }
                case GETAGENTDATA: {
                    AgentCallback agentCallback = (AgentCallback)callback;
                    AgentObject agentObject = new AgentObject(object.optJSONObject("result"));
                    agentCallback.call(AgentCallbackType.GETAGENTDATA, agentObject);
                }
            }
        }
    }

    public static enum CallbackType {
        GETINITIALDATA,
        REGISTER,
        LOGIN,
        GETCHATHISTORY,
        GETAGENTDATA;

    }

    public static enum AgentCallbackType {
        GETAGENTDATA,
        STREAMLIVECHATROOM;

    }
}

