/*
 * Decompiled with CFR 0.152.
 */
package io.rocketchat.livechat;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import com.neovisionaries.ws.client.WebSocketState;
import io.rocketchat.common.network.EventThread;
import io.rocketchat.common.network.Socket;
import io.rocketchat.common.utils.Utils;
import io.rocketchat.livechat.callback.AgentCallback;
import io.rocketchat.livechat.callback.ConnectCallback;
import io.rocketchat.livechat.callback.GuestCallback;
import io.rocketchat.livechat.callback.HistoryCallback;
import io.rocketchat.livechat.callback.InitialDataCallback;
import io.rocketchat.livechat.callback.MessageCallback;
import io.rocketchat.livechat.callback.SubscribeCallback;
import io.rocketchat.livechat.callback.TypingCallback;
import io.rocketchat.livechat.middleware.LiveChatMiddleware;
import io.rocketchat.livechat.middleware.LiveChatStreamMiddleware;
import io.rocketchat.livechat.rpc.LiveChatBasicRPC;
import io.rocketchat.livechat.rpc.LiveChatHistoryRPC;
import io.rocketchat.livechat.rpc.LiveChatSendMsgRPC;
import io.rocketchat.livechat.rpc.LiveChatSubRPC;
import io.rocketchat.livechat.rpc.LiveChatTypingRPC;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class LiveChatAPI
extends Socket {
    AtomicInteger integer;
    String sessionId;
    JSONObject userInfo;
    WebSocketListener listener = this.getListener();
    LiveChatMiddleware liveChatMiddleware;
    LiveChatStreamMiddleware liveChatStreamMiddleware;
    ConnectCallback connectCallback;

    public LiveChatAPI(String url) {
        super(url);
        this.integer = new AtomicInteger(1);
        this.liveChatMiddleware = LiveChatMiddleware.getInstance();
        this.liveChatStreamMiddleware = LiveChatStreamMiddleware.getInstance();
    }

    public void getInitialData(final InitialDataCallback callback) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, callback, LiveChatMiddleware.CallbackType.GETINITIALDATA);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.getInitialData(uniqueID));
            }
        });
    }

    public void registerGuest(final String name, final String email, final String dept, final GuestCallback callback) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, callback, LiveChatMiddleware.CallbackType.REGISTER);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.registerGuest(uniqueID, name, email, dept));
            }
        });
    }

    public void login(final String token, final GuestCallback callback) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, callback, LiveChatMiddleware.CallbackType.LOGIN);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.login(uniqueID, token));
            }
        });
    }

    public void getChatHistory(final String roomID, final int limit, final Date lasttimestamp, final HistoryCallback callback) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, callback, LiveChatMiddleware.CallbackType.GETCHATHISTORY);
                LiveChatAPI.this.ws.sendText(LiveChatHistoryRPC.loadHistory(uniqueID, roomID, limit, lasttimestamp));
            }
        });
    }

    public void getAgentData(final String roomId, final AgentCallback callback) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.liveChatMiddleware.createCallback(uniqueID, callback, LiveChatMiddleware.CallbackType.GETAGENTDATA);
                LiveChatAPI.this.ws.sendText(LiveChatBasicRPC.getAgentData(uniqueID, roomId));
            }
        });
    }

    public void sendMessage(final String msgId, final String roomID, final String message, final String token) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                int uniqueID = LiveChatAPI.this.integer.getAndIncrement();
                LiveChatAPI.this.ws.sendText(LiveChatSendMsgRPC.sendMessage(uniqueID, msgId, roomID, message, token));
            }
        });
    }

    public void sendIsTyping(String roomId, String username, Boolean istyping) {
        int uniqueID = this.integer.getAndIncrement();
        this.ws.sendText(LiveChatTypingRPC.streamNotifyRoom(uniqueID, roomId, username, istyping));
    }

    public void subscribeRoom(final String roomID, final Boolean enable, final SubscribeCallback subscribeCallback, final MessageCallback callback) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                String uniqueID = Utils.shortUUID();
                if (subscribeCallback != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeCallback, LiveChatStreamMiddleware.subscriptiontype.STREAMROOMMESSAGES);
                }
                if (callback != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.subscribeRoom(callback);
                }
                LiveChatAPI.this.ws.sendText(LiveChatSubRPC.streamRoomMessages(uniqueID, roomID, enable));
            }
        });
    }

    public void subscribeLiveChatRoom(final String roomID, final Boolean enable, final SubscribeCallback subscribeCallback, final AgentCallback callback) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                String uniqueID = Utils.shortUUID();
                if (subscribeCallback != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeCallback, LiveChatStreamMiddleware.subscriptiontype.STREAMLIVECHATROOM);
                }
                if (callback != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.subscribeLiveChatRoom(callback);
                }
                LiveChatAPI.this.ws.sendText(LiveChatSubRPC.streamLivechatRoom(uniqueID, roomID, enable));
            }
        });
    }

    public void subscribeTyping(final String roomID, final Boolean enable, final SubscribeCallback subscribeCallback, final TypingCallback callback) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                String uniqueID = Utils.shortUUID();
                if (subscribeCallback != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.createSubCallbacks(uniqueID, subscribeCallback, LiveChatStreamMiddleware.subscriptiontype.NOTIFYROOM);
                }
                if (callback != null) {
                    LiveChatAPI.this.liveChatStreamMiddleware.subscribeTyping(callback);
                }
                LiveChatAPI.this.ws.sendText(LiveChatSubRPC.subscribeTyping(uniqueID, roomID, enable));
            }
        });
    }

    @Override
    public void connect() {
        this.createWebsocketfactory();
        this.ws.addListener(this.listener);
        super.connect();
    }

    public void connectAsync(ConnectCallback connectCallback) {
        this.createWebsocketfactory();
        this.ws.addListener(this.listener);
        this.connectCallback = connectCallback;
        super.connectAsync();
    }

    WebSocketListener getListener() {
        return new WebSocketListener(){

            public void onStateChanged(WebSocket websocket, WebSocketState newState) throws Exception {
            }

            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                LiveChatAPI.this.integer.set(1);
                websocket.sendText(LiveChatBasicRPC.ConnectObject());
                System.out.println("Connected to server");
            }

            public void onConnectError(WebSocket websocket, WebSocketException cause) throws Exception {
                System.out.println("got connect error");
            }

            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                System.out.println("Disconnected to server");
            }

            public void onFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onContinuationFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("on continuation frame");
            }

            public void onTextFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onBinaryFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("on binary frame");
            }

            public void onCloseFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("On close frame");
            }

            public void onPingFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("On ping frame" + frame.getPayloadText());
            }

            public void onPongFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("on pong frame");
            }

            public void onTextMessage(WebSocket websocket, String text) throws Exception {
                System.out.println("Message is " + text);
                JSONObject object = new JSONObject(text);
                if (object.optString("msg").equals("ping")) {
                    websocket.sendText("{\"msg\":\"pong\"}");
                } else if (object.optString("msg").equals("connected")) {
                    LiveChatAPI.this.sessionId = object.optString("session");
                    if (LiveChatAPI.this.connectCallback != null) {
                        LiveChatAPI.this.connectCallback.onConnect(LiveChatAPI.this.sessionId);
                    }
                } else if (object.optString("msg").equals("added")) {
                    if (object.optString("collection") != null && object.optString("collection").equals("users")) {
                        LiveChatAPI.this.userInfo = object.optJSONObject("fields");
                    }
                } else if (Utils.isInteger(object.optString("id"))) {
                    LiveChatAPI.this.liveChatMiddleware.processCallback(Long.valueOf(object.optString("id")), object);
                } else if (object.optString("msg").equals("ready")) {
                    LiveChatAPI.this.liveChatStreamMiddleware.processSubSuccess(object);
                } else if (object.optString("msg").equals("changed")) {
                    LiveChatAPI.this.liveChatStreamMiddleware.processCallback(object);
                }
            }

            public void onBinaryMessage(WebSocket websocket, byte[] binary) throws Exception {
                System.out.println("on binary message");
            }

            public void onSendingFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onFrameSent(WebSocket websocket, WebSocketFrame frame) throws Exception {
            }

            public void onFrameUnsent(WebSocket websocket, WebSocketFrame frame) throws Exception {
                System.out.println("on frame unsent");
            }

            public void onError(WebSocket websocket, WebSocketException cause) throws Exception {
                System.out.println("On error");
            }

            public void onFrameError(WebSocket websocket, WebSocketException cause, WebSocketFrame frame) throws Exception {
                System.out.println("On frame error");
            }

            public void onMessageError(WebSocket websocket, WebSocketException cause, List<WebSocketFrame> frames) throws Exception {
                System.out.println("On message error");
            }

            public void onMessageDecompressionError(WebSocket websocket, WebSocketException cause, byte[] compressed) throws Exception {
                System.out.println("on message decompression error");
            }

            public void onTextMessageError(WebSocket websocket, WebSocketException cause, byte[] data) throws Exception {
                System.out.println("on text message error");
            }

            public void onSendError(WebSocket websocket, WebSocketException cause, WebSocketFrame frame) throws Exception {
                System.out.println("on send error");
            }

            public void onUnexpectedError(WebSocket websocket, WebSocketException cause) throws Exception {
                System.out.println("on unexpected error");
            }

            public void handleCallbackError(WebSocket websocket, Throwable cause) throws Exception {
                System.out.println("handle callback error");
            }

            public void onSendingHandshake(WebSocket websocket, String requestLine, List<String[]> headers) throws Exception {
            }
        };
    }
}

