/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="phosphor-ext")
public class PhosphorLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    public static final String RAW_CONFIG_SUFFIX = ".rawReruns";
    public static final String PROCESSED_CONFIG_SUFFIX = ".reruns";
    static String PATH_TO_AGENT_BOOTPATH_JAR;
    static String PATH_TO_AGENT;
    static String SNAPSHOT_REPO;
    static String PATH_TO_RIVULET_CORE_JAR;
    private static final String PHOSPHOR_VERSION = "0.0.4-SNAPSHOT";
    private static final String RIVULET_VERSION = "1.0.0";
    String instrumentedJVMDir;
    private static final String VIOLATION_REPORT_DIR = "phosphor-reports";
    private static final String RERUN_CONFIG_DIR = "phosphor-rerun-configs";
    private static final String CRITICAL_REPRODUCTION_DIR = "phosphor-critical-reproduction";
    MavenSession session;
    private String sourcesFile;
    private String sinksFile;
    private String taintThroughFile;
    private boolean isSkipTests;
    private boolean isSkipReruns;
    private boolean reportRerunFailures;
    private boolean stopRerunsWhenVerified;
    private boolean forceForkInTests;
    private String rerunsFilePath;
    private boolean disableViolationPrinting;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        session.getRequest().getPluginArtifactRepositories().add(new MavenArtifactRepository("phosphor.snapshots", SNAPSHOT_REPO, (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(true, "always", "ignore"), new ArtifactRepositoryPolicy(true, "daily", "ignore")));
        super.afterSessionStart(session);
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.session = session;
        if (((MavenProject)session.getProjects().get(0)).getProperties().containsKey("phosphor.config")) {
            System.setProperty("phosphor.config", ((MavenProject)session.getProjects().get(0)).getProperties().getProperty("phosphor.config"));
        }
        this.instrumentedJVMDir = System.getProperty("instrumentedJVMDir", System.getProperty("user.home") + File.separator + ".phosphor-jvm");
        this.sourcesFile = this.readAutoTaintFileProperty("sources", "phosphor.sources");
        this.sinksFile = this.readAutoTaintFileProperty("sinks", "phosphor.sinks");
        this.taintThroughFile = this.readAutoTaintFileProperty("taintThrough", "phosphor.taintThrough");
        this.isSkipReruns = Boolean.parseBoolean(session.getUserProperties().getProperty("ifc.skipReruns", "false"));
        this.isSkipTests = Boolean.parseBoolean(session.getUserProperties().getProperty("ifc.skipTests", "false"));
        this.reportRerunFailures = Boolean.parseBoolean(session.getUserProperties().getProperty("ifc.reportRerunFailures", "false"));
        this.stopRerunsWhenVerified = Boolean.parseBoolean(session.getUserProperties().getProperty("ifc.stopRerunsWhenVerified", "false"));
        this.forceForkInTests = Boolean.parseBoolean(session.getUserProperties().getProperty("ifc.isolation", "false"));
        boolean createCriticalReproductionFiles = Boolean.parseBoolean(session.getUserProperties().getProperty("ifc.criticalReproductionFiles", "false"));
        this.disableViolationPrinting = Boolean.parseBoolean(session.getUserProperties().getProperty("ifc.disableViolationPrinting", "false"));
        this.rerunsFilePath = session.getUserProperties().getProperty("ifc.reruns");
        if (this.rerunsFilePath != null) {
            if (!this.rerunsFilePath.endsWith(RAW_CONFIG_SUFFIX) || !Files.isRegularFile(Paths.get(this.rerunsFilePath, new String[0]), new LinkOption[0])) {
                String msg = String.format("Invalid value for property ifc.reruns: %s. Value must specify apath to a file containing unprocessed reruns", this.rerunsFilePath);
                throw new RuntimeException(msg);
            }
            this.isSkipTests = true;
        }
        for (MavenProject p : session.getProjects()) {
            String violationReportsPath = p.getBuild().getDirectory() + File.separator + VIOLATION_REPORT_DIR;
            String rerunConfigsPath = p.getBuild().getDirectory() + File.separator + RERUN_CONFIG_DIR;
            String criticalReproductionPath = null;
            if (!this.isSkipTests) {
                PhosphorLifecycleParticipant.makeClearedDirectory(rerunConfigsPath, null, RAW_CONFIG_SUFFIX);
                PhosphorLifecycleParticipant.makeClearedDirectory(violationReportsPath, "RUN-", null);
            }
            if (this.rerunsFilePath != null) {
                File rerunsFile = new File(this.rerunsFilePath);
                String baseName = rerunsFile.getName().substring(0, rerunsFile.getName().length() - RAW_CONFIG_SUFFIX.length());
                PhosphorLifecycleParticipant.makeClearedDirectory(rerunsFile.getParent(), baseName, PROCESSED_CONFIG_SUFFIX);
            } else if (!this.isSkipReruns) {
                PhosphorLifecycleParticipant.makeClearedDirectory(rerunConfigsPath, null, PROCESSED_CONFIG_SUFFIX);
                PhosphorLifecycleParticipant.makeClearedDirectory(violationReportsPath, "RERUN-", null);
                if (createCriticalReproductionFiles || session.getUserProperties().getProperty("ifc.criticalReproductionFiles") == null && Boolean.parseBoolean(p.getProperties().getProperty("ifc.criticalReproductionFiles", "false"))) {
                    criticalReproductionPath = p.getBuild().getDirectory() + File.separator + CRITICAL_REPRODUCTION_DIR;
                    this.makeDeepClearedDirectory(criticalReproductionPath);
                }
            }
            if (this.rerunsFilePath == null) {
                this.addPhosphorPlugin(p, violationReportsPath);
            }
            this.addPhosphorToSurefireOrFailsafe(p, false, violationReportsPath, rerunConfigsPath, criticalReproductionPath);
            this.addPhosphorToSurefireOrFailsafe(p, true, violationReportsPath, rerunConfigsPath, criticalReproductionPath);
        }
        super.afterProjectsRead(session);
    }

    private String readAutoTaintFileProperty(String autoTaintTypeDesc, String autoTaintPropertyName) {
        String autoTaintFile = System.getProperty(autoTaintPropertyName);
        if (autoTaintFile == null) {
            autoTaintFile = System.getProperty("phosphor.config", "eval");
            try {
                int n;
                File tempFile = File.createTempFile("rivulet", autoTaintPropertyName);
                tempFile.deleteOnExit();
                InputStream input = PhosphorLifecycleParticipant.class.getResourceAsStream("/config-files/" + autoTaintFile + "/" + autoTaintTypeDesc);
                if (input == null) {
                    String capitalizedDesc = autoTaintTypeDesc.substring(0, 1).toUpperCase() + autoTaintTypeDesc.substring(1);
                    String msg = String.format("%s configuration resource %s does not exist! (If you are trying to specify a non-standard %s file, please use a full path)", capitalizedDesc, autoTaintFile, capitalizedDesc);
                    throw new IllegalStateException(msg);
                }
                System.out.printf("[Phosphor]: Using %s config: %s\n", autoTaintTypeDesc, autoTaintFile);
                FileOutputStream out = new FileOutputStream(tempFile);
                byte[] buf = new byte[4096];
                while ((n = input.read(buf)) > 0) {
                    out.write(buf, 0, n);
                }
                input.close();
                out.close();
                autoTaintFile = tempFile.getAbsolutePath();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            System.out.printf("[Phosphor]: Using %s file: %s\n", autoTaintTypeDesc, autoTaintFile);
        }
        if (!Files.exists(Paths.get(autoTaintFile, new String[0]), new LinkOption[0])) {
            String capitalizedDesc = autoTaintTypeDesc.substring(0, 1).toUpperCase() + autoTaintTypeDesc.substring(1);
            String msg = String.format("%s file %s does not exist!", capitalizedDesc, autoTaintFile);
            throw new IllegalStateException(msg);
        }
        return autoTaintFile;
    }

    private void addPhosphorPlugin(MavenProject project, String violationReportsPath) {
        Plugin phosphorPlugin = new Plugin();
        phosphorPlugin.setArtifactId("rivulet-maven-plugin");
        phosphorPlugin.setGroupId("io.rivulet");
        phosphorPlugin.setVersion(RIVULET_VERSION);
        project.getBuild().addPlugin(phosphorPlugin);
        PluginExecution phosphorExec = new PluginExecution();
        phosphorExec.setId("phosphor-instrument");
        phosphorExec.setPhase("process-test-resources");
        phosphorExec.setGoals(Collections.singletonList("instrument"));
        Xpp3Dom phosphorMavenConfig = new Xpp3Dom("configuration");
        Xpp3Dom jvm = new Xpp3Dom("jvm");
        jvm.setValue(this.instrumentedJVMDir);
        phosphorMavenConfig.addChild(jvm);
        phosphorExec.setConfiguration((Object)phosphorMavenConfig);
        phosphorPlugin.addExecution(phosphorExec);
        PluginExecution phosphorCleanExec = new PluginExecution();
        phosphorCleanExec.setId("phosphor-clean");
        phosphorCleanExec.setPhase("clean");
        phosphorCleanExec.setGoals(Collections.singletonList("clean"));
        phosphorPlugin.addExecution(phosphorCleanExec);
        PluginExecution phosphorReportExec = new PluginExecution();
        phosphorReportExec.setId("phosphor-report");
        phosphorReportExec.setPhase("test");
        phosphorReportExec.setGoals(Collections.singletonList("report"));
        Xpp3Dom reportMavenConfig = new Xpp3Dom("configuration");
        Xpp3Dom violationReportsPathChild = new Xpp3Dom("violationReportDirPath");
        violationReportsPathChild.setValue(violationReportsPath);
        reportMavenConfig.addChild(violationReportsPathChild);
        String phosphorReportFilePath = project.getBuild().getDirectory() + File.separator + "phosphor-report.json";
        if (new File(phosphorReportFilePath).exists() && !new File(phosphorReportFilePath).delete()) {
            System.err.println("Failed to delete existing phosphor report file: " + phosphorReportFilePath);
        }
        Xpp3Dom phosphorReportFile = new Xpp3Dom("phosphorReportFile");
        phosphorReportFile.setValue(phosphorReportFilePath);
        reportMavenConfig.addChild(phosphorReportFile);
        phosphorReportExec.setConfiguration((Object)reportMavenConfig);
        phosphorPlugin.addExecution(phosphorReportExec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void makeClearedDirectory(String dirName, String prefixToDelete, String suffixToDelete) {
        File dir = new File(dirName);
        if (dir.isDirectory()) {
            try {
                File[] files = dir.listFiles();
                if (files == null) return;
                for (File file : files) {
                    if (suffixToDelete != null && !file.getName().endsWith(suffixToDelete) || prefixToDelete != null && !file.getName().startsWith(prefixToDelete) || file.delete()) continue;
                    throw new IOException();
                }
                return;
            }
            catch (IOException e) {
                System.err.println("Failed to create or clear directory: " + dirName);
                return;
            }
        } else if (dir.exists()) {
            if (dir.delete() && dir.mkdirs()) return;
            System.err.println("Failed to create or clear directory: " + dirName);
            return;
        } else {
            if (dir.mkdirs()) return;
            System.err.println("Failed to create or clear directory: " + dirName);
        }
    }

    private void makeDeepClearedDirectory(String dirName) {
        final File targetDir = new File(dirName);
        if (targetDir.isDirectory()) {
            try {
                SimpleFileVisitor<Path> deletingVisitor = new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                        if (!dir.equals(targetDir.toPath())) {
                            Files.delete(dir);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }
                };
                Files.walkFileTree(new File(dirName).toPath(), (FileVisitor<? super Path>)deletingVisitor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (targetDir.exists()) {
            if (!targetDir.delete() || !targetDir.mkdirs()) {
                System.err.println("Failed to create or clear directory: " + dirName);
            }
        } else if (!targetDir.mkdirs()) {
            System.err.println("Failed to create or clear directory: " + dirName);
        }
    }

    private void addPhosphorToSurefireOrFailsafe(MavenProject project, boolean doFailsafe, String violationReportsPath, String rerunConfigsPath, String criticalReproductionPath) {
        Object p = null;
        for (Object o : project.getBuildPlugins()) {
            if (!doFailsafe && o.getArtifactId().equals("maven-surefire-plugin") && o.getGroupId().equals("org.apache.maven.plugins")) {
                p = o;
                continue;
            }
            if (!doFailsafe || !o.getArtifactId().equals("maven-failsafe-plugin") || !o.getGroupId().equals("org.apache.maven.plugins")) continue;
            p = o;
        }
        if (p == null) {
            return;
        }
        p.setVersion("2.20.1");
        LinkedList<PluginExecution> newExecutions = new LinkedList<PluginExecution>();
        for (PluginExecution pe : p.getExecutions()) {
            Xpp3Dom failIfNoTests;
            Xpp3Dom config = (Xpp3Dom)pe.getConfiguration();
            if (config == null) {
                config = new Xpp3Dom("configuration");
            }
            Xpp3Dom config2 = new Xpp3Dom(config);
            boolean disableViolationPrintingExecution = this.disableViolationPrinting || Boolean.parseBoolean(project.getProperties().getProperty("ifc.disableViolationPrinting", "false"));
            this.injectConfig(project, config, violationReportsPath, rerunConfigsPath, null, this.forceForkInTests, this.isSkipTests, disableViolationPrintingExecution);
            p.setConfiguration((Object)config);
            pe.setConfiguration((Object)config);
            PluginExecution pe2 = new PluginExecution();
            pe2.getGoals().addAll(pe.getGoals());
            pe2.setPhase(pe.getPhase());
            pe2.setId(pe.getId() + "-reruntaints");
            this.injectConfig(project, config2, violationReportsPath, rerunConfigsPath, criticalReproductionPath, this.forceForkInTests, this.isSkipReruns, disableViolationPrintingExecution);
            Xpp3Dom prop = new Xpp3Dom("property");
            Xpp3Dom n = new Xpp3Dom("name");
            n.setValue("isReruns");
            Xpp3Dom v = new Xpp3Dom("value");
            v.setValue("true");
            prop.addChild(n);
            prop.addChild(v);
            config2.getChild("properties").addChild(prop);
            boolean projectReportRerunFailures = Boolean.parseBoolean(project.getProperties().getProperty("ifc.reportRerunFailures", "false"));
            if (this.reportRerunFailures || projectReportRerunFailures) {
                Xpp3Dom prop2 = new Xpp3Dom("property");
                Xpp3Dom name2 = new Xpp3Dom("name");
                name2.setValue("reportRerunFailures");
                Xpp3Dom value2 = new Xpp3Dom("value");
                v.setValue("true");
                prop2.addChild(name2);
                prop2.addChild(value2);
                config2.getChild("properties").addChild(prop2);
                Xpp3Dom testFailureIgnore = config2.getChild("testFailureIgnore");
                if (testFailureIgnore == null) {
                    testFailureIgnore = new Xpp3Dom("testFailureIgnore");
                    config2.addChild(testFailureIgnore);
                }
                testFailureIgnore.setValue("true");
            }
            boolean projectStopRerunsWhenVerified = Boolean.parseBoolean(project.getProperties().getProperty("ifc.stopRerunsWhenVerified", "false"));
            if (this.stopRerunsWhenVerified || projectStopRerunsWhenVerified) {
                Xpp3Dom prop2 = new Xpp3Dom("property");
                Xpp3Dom name2 = new Xpp3Dom("name");
                name2.setValue("stopRerunsWhenVerified");
                Xpp3Dom value2 = new Xpp3Dom("value");
                v.setValue("true");
                prop2.addChild(name2);
                prop2.addChild(value2);
                config2.getChild("properties").addChild(prop2);
            }
            if ((failIfNoTests = config2.getChild("failIfNoTests")) == null) {
                failIfNoTests = new Xpp3Dom("failIfNoTests");
                config2.addChild(failIfNoTests);
            }
            failIfNoTests.setValue("false");
            pe2.setConfiguration((Object)config2);
            newExecutions.add(pe);
            newExecutions.add(pe2);
        }
        p.setExecutions(newExecutions);
        p.getDependencies().clear();
        Dependency rivulet = new Dependency();
        rivulet.setArtifactId("rivulet-surefire-provider");
        rivulet.setGroupId("io.rivulet");
        rivulet.setVersion("2.20.1");
        p.addDependency(rivulet);
    }

    private void injectConfig(MavenProject project, Xpp3Dom config, String violationReportsPath, String rerunConfigsPath, String criticalReproductionPath, boolean forceFork, boolean skipTests, boolean disableViolationPrintingExecution) {
        Xpp3Dom jvm;
        Xpp3Dom skipTestsDom;
        Xpp3Dom reuseForksDom;
        Xpp3Dom forkMode = config.getChild("forkMode");
        boolean isSetToFork = false;
        boolean isReuseForks = true;
        if (forkMode != null && forceFork) {
            forkMode.setValue("always");
            isReuseForks = false;
            isSetToFork = true;
        } else if (forkMode != null && (forkMode.getValue().equalsIgnoreCase("never") || forkMode.getValue().equalsIgnoreCase("perthread"))) {
            forkMode.setValue("once");
            isReuseForks = true;
            isSetToFork = true;
        }
        Xpp3Dom forkCount = config.getChild("forkCount");
        if (forkCount != null && !forkCount.getValue().equals("1")) {
            isSetToFork = true;
        }
        if (!isSetToFork) {
            forkCount = new Xpp3Dom("forkCount");
            forkCount.setValue("1");
            config.addChild(forkCount);
            if (forceFork) {
                Xpp3Dom reuseForks = new Xpp3Dom("reuseForks");
                reuseForks.setValue("false");
                config.addChild(reuseForks);
            }
        }
        if (this.session.getUserProperties().getProperty("maven.surefire.debug") != null) {
            forkCount.setValue("1");
        }
        if ((reuseForksDom = config.getChild("reuseForks")) != null) {
            isReuseForks = Boolean.valueOf(reuseForksDom.getValue());
        }
        if ((skipTestsDom = config.getChild("skipTests")) == null) {
            skipTestsDom = new Xpp3Dom("skipTests");
            config.addChild(skipTestsDom);
        }
        skipTestsDom.setValue(skipTests ? "true" : "false");
        Xpp3Dom argLine = config.getChild("argLine");
        if (argLine == null) {
            argLine = new Xpp3Dom("argLine");
            argLine.setValue("");
            config.addChild(argLine);
        }
        argLine.setValue(argLine.getValue().replace("${surefireArgLine}", ""));
        if (argLine != null && argLine.getValue().equals("${argLine}")) {
            argLine.setValue("");
        } else if (argLine != null) {
            argLine.setValue(argLine.getValue().replace("@{argLine}", "").replace("${argLine}", "").replace("${test.opts.coverage}", ""));
        }
        if (!argLine.getValue().contains("-Xmx")) {
            argLine.setValue(argLine.getValue() + " -Xmx2g");
        }
        String taintFileConfig = "";
        if (this.sourcesFile != null) {
            taintFileConfig = taintFileConfig + ",taintSources=" + this.sourcesFile;
        }
        if (this.sinksFile != null) {
            taintFileConfig = taintFileConfig + ",taintSinks=" + this.sinksFile;
        }
        if (this.taintThroughFile != null) {
            taintFileConfig = taintFileConfig + ",taintThrough=" + this.taintThroughFile;
        }
        String cacheConfig = "-DphosphorCacheDirectory='" + project.getBuild().getDirectory() + File.separatorChar + "cached-phosphor-${surefire.forkNumber}'";
        String jvmArgs = "-Xbootclasspath/p:" + this.session.getLocalRepository().getBasedir() + PATH_TO_AGENT_BOOTPATH_JAR + ":" + this.session.getLocalRepository().getBasedir() + PATH_TO_RIVULET_CORE_JAR + " -javaagent:" + this.session.getLocalRepository().getBasedir() + PATH_TO_AGENT + "='taintSourceWrapper=io.rivulet.internal.RivuletAutoTaintWrapper,ignore=io/rivulet/internal/,arrayindex,priorClassVisitor=io.rivulet.internal.RivuletCV,ignoredMethod=org/mindrot/jbcrypt/BCrypt.encipher([II)V" + taintFileConfig + "'";
        Map<String, String> env = System.getenv();
        try {
            Field field = env.getClass().getDeclaredField("m");
            field.setAccessible(true);
            ((Map)field.get(env)).put("JAVA_TOOL_OPTIONS", jvmArgs);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        argLine.setValue(cacheConfig + " " + argLine.getValue());
        Xpp3Dom parallel = config.getChild("parallel");
        if (parallel != null) {
            parallel.setValue("none");
        }
        if ((jvm = config.getChild("jvm")) == null) {
            jvm = new Xpp3Dom("jvm");
            config.addChild(jvm);
        }
        jvm.setValue(this.instrumentedJVMDir + "/bin/java");
        Xpp3Dom properties = config.getChild("properties");
        if (properties == null) {
            properties = new Xpp3Dom("properties");
            config.addChild(properties);
        }
        properties.addChild(this.makeProperty("rerunConfigsPath", rerunConfigsPath));
        properties.addChild(this.makeProperty("violationReportsPath", violationReportsPath));
        properties.addChild(this.makeProperty("reuseForks", Boolean.toString(isReuseForks)));
        if (criticalReproductionPath != null) {
            properties.addChild(this.makeProperty("criticalReproductionPath", criticalReproductionPath));
        }
        if (this.rerunsFilePath != null) {
            properties.addChild(this.makeProperty("rerunsFilePath", this.rerunsFilePath));
        }
        if (disableViolationPrintingExecution) {
            properties.addChild(this.makeProperty("disableViolationPrinting", "true"));
        }
        if (System.getProperty("ifc.port") != null) {
            properties.addChild(this.makeProperty("ifc.port", System.getProperty("ifc.port")));
        }
    }

    private Xpp3Dom makeProperty(String name, String value) {
        Xpp3Dom property = new Xpp3Dom("property");
        Xpp3Dom propertyName = new Xpp3Dom("name");
        propertyName.setValue(name);
        Xpp3Dom propertyValue = new Xpp3Dom("value");
        propertyValue.setValue(value);
        property.addChild(propertyName);
        property.addChild(propertyValue);
        return property;
    }

    static {
        SNAPSHOT_REPO = "https://oss.sonatype.org/content/repositories/snapshots/";
        PATH_TO_AGENT_BOOTPATH_JAR = "/edu/gmu/swe/phosphor/Phosphor/0.0.4-SNAPSHOT/Phosphor-0.0.4-SNAPSHOT.jar";
        PATH_TO_RIVULET_CORE_JAR = "/io/rivulet/rivulet-core/1.0.0/rivulet-core-1.0.0.jar";
        PATH_TO_AGENT = PATH_TO_AGENT_BOOTPATH_JAR;
    }
}

