/*
 * Decompiled with CFR 0.152.
 */
package io.rhizomatic.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import io.rhizomatic.api.Monitor;
import io.rhizomatic.api.annotations.EndpointPath;
import io.rhizomatic.api.web.WebApp;
import io.rhizomatic.kernel.spi.inject.InstanceManager;
import io.rhizomatic.kernel.spi.reload.ReloadListener;
import io.rhizomatic.kernel.spi.reload.RzReloader;
import io.rhizomatic.kernel.spi.scan.Introspector;
import io.rhizomatic.kernel.spi.subsystem.Subsystem;
import io.rhizomatic.kernel.spi.subsystem.SubsystemContext;
import io.rhizomatic.web.http.JettyTransport;
import io.rhizomatic.web.http.RewriteHandler;
import io.rhizomatic.web.jersey.RzInjectionManager;
import io.rhizomatic.web.jersey.RzInjectionManagerFactory;
import io.rhizomatic.web.scan.WebIntrospector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.message.internal.MessagingBinders;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.servlet.internal.Utils;

public class WebSubsystem
extends Subsystem {
    private static final Set<String> OPENS = Set.of("jersey.common", "jersey.server", "jetty.server", "jetty.util", "io.rhizomatic.web");
    private static final String RHIZOMATIC_REST = "RhizomaticRest";
    protected Monitor monitor;
    protected JettyTransport jettyTransport;
    private Map<Object, Holder> instanceToContainers = new ConcurrentHashMap<Object, Holder>();
    private Map<Object, Holder> pathToContainers = new ConcurrentHashMap<Object, Holder>();

    public WebSubsystem() {
        super("rhizomatic.web");
    }

    public Set<String> openModulesTo() {
        return OPENS;
    }

    public void instantiate(SubsystemContext context) {
        this.monitor = context.getMonitor();
        RzInjectionManagerFactory.INSTANCE = new RzInjectionManager(this.monitor);
        RzInjectionManagerFactory.INSTANCE.register((Binder)new MessagingBinders.MessageBodyProviders(Collections.emptyMap(), RuntimeType.SERVER));
        this.jettyTransport = new JettyTransport();
        this.jettyTransport.initialize(context);
        context.registerService(JettyTransport.class, (Object)this.jettyTransport);
        WebIntrospector introspector = new WebIntrospector();
        context.registerService(Introspector.class, (Object)introspector);
        this.monitor.info(() -> "Web subsystem enabled", new Throwable[0]);
    }

    public void assemble(SubsystemContext context) {
        ((RzReloader)context.resolve(RzReloader.class)).register((ReloadListener)new WebReloadListener());
    }

    public void applicationInitialize(SubsystemContext context) {
        InstanceManager instanceManager = (InstanceManager)context.resolve(InstanceManager.class);
        Map<String, ResourceConfig> resourceConfiguration = this.configureResources(instanceManager);
        this.configureProviders(resourceConfiguration, instanceManager);
        this.exportResources(resourceConfiguration);
        this.createWebApps(context);
    }

    public void start(SubsystemContext context) {
        this.jettyTransport.start(context);
    }

    public void shutdown() {
        if (this.jettyTransport != null) {
            this.jettyTransport.shutdown();
            this.jettyTransport = null;
        }
        this.monitor = null;
    }

    protected void configureProviders(Map<String, ResourceConfig> resourceConfiguration, InstanceManager instanceManager) {
        Set providers = instanceManager.resolveQualifiedTypes(Provider.class);
        for (ResourceConfig resourceConfig : resourceConfiguration.values()) {
            for (Object provider : providers) {
                resourceConfig.register(provider);
            }
        }
    }

    protected Map<String, ResourceConfig> configureResources(InstanceManager instanceManager) {
        Set endpoints = instanceManager.resolveQualifiedTypes(Path.class);
        HashMap<String, ResourceConfig> resourceConfigs = new HashMap<String, ResourceConfig>();
        for (Object endpoint : endpoints) {
            EndpointPath endpointPath = endpoint.getClass().getModule().getAnnotation(EndpointPath.class);
            String rootPath = endpointPath != null ? endpointPath.value() : "api";
            ResourceConfig resourceConfig = resourceConfigs.computeIfAbsent(rootPath, k -> new ResourceConfig());
            JacksonJsonProvider jacksonJsonProvider = this.createJacksonProvider(instanceManager);
            resourceConfig.registerInstances(new Object[]{jacksonJsonProvider});
            resourceConfig.register(endpoint);
        }
        return resourceConfigs;
    }

    protected void exportResources(Map<String, ResourceConfig> configurations) {
        for (Map.Entry<String, ResourceConfig> entry : configurations.entrySet()) {
            String rootPath = entry.getKey();
            ResourceConfig resourceConfig = entry.getValue();
            ServletContainer servletContainer = new ServletContainer();
            Holder holder = new Holder(rootPath, servletContainer, resourceConfig);
            this.pathToContainers.put(rootPath, holder);
            for (Object instance : resourceConfig.getSingletons()) {
                this.instanceToContainers.put(instance, holder);
            }
            ServletHolder servletHolder = new ServletHolder(Source.EMBEDDED);
            servletHolder.setName("RhizomaticRest_" + rootPath);
            servletHolder.setServlet((Servlet)servletContainer);
            servletHolder.setInitOrder(1);
            ServletContextHandler handler = new ServletContextHandler(0);
            handler.setContextPath("/");
            this.jettyTransport.registerHandler((Handler)handler);
            handler.getServletHandler().addServletWithMapping(servletHolder, "/" + rootPath + "/*");
            Utils.store((ResourceConfig)resourceConfig, (ServletContext)handler.getServletContext(), (String)("RhizomaticRest_" + rootPath));
            this.monitor.info(() -> "Endpoint context at: " + (String)(rootPath.startsWith("/") ? rootPath : "/" + rootPath), new Throwable[0]);
        }
    }

    protected void createWebApps(SubsystemContext context) {
        for (WebApp webApp : context.getWebApps()) {
            java.nio.file.Path[] contentRoots = webApp.getContentRoots();
            String[] rootStrings = (String[])Arrays.stream(contentRoots).map(java.nio.file.Path::toString).toArray(String[]::new);
            ResourceCollection resources = new ResourceCollection(rootStrings);
            String contextPath = webApp.getContextPath();
            RewriteHandler rewriteHandler = new RewriteHandler();
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setBaseResource((Resource)resources);
            rewriteHandler.setHandler((Handler)resourceHandler);
            ContextHandler ctx = new ContextHandler(contextPath);
            ctx.setHandler((Handler)rewriteHandler);
            this.jettyTransport.registerHandler((Handler)ctx);
            this.monitor.info(() -> "Web app at: " + (String)(contextPath.startsWith("/") ? contextPath : "/" + contextPath), new Throwable[0]);
        }
    }

    private JacksonJsonProvider createJacksonProvider(final InstanceManager instanceManager) {
        return new JacksonJsonProvider(){

            protected ObjectMapper _locateMapperViaProvider(Class<?> type, MediaType mediaType) {
                Set providers = instanceManager.resolveQualifiedTypes(Provider.class);
                for (Object provider : providers) {
                    if (!(provider instanceof ContextResolver)) continue;
                    for (Type interfaze : provider.getClass().getGenericInterfaces()) {
                        ParameterizedType parameterizedType;
                        if (!(interfaze instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)interfaze).getRawType().equals(ContextResolver.class) || !parameterizedType.getActualTypeArguments()[0].equals(ObjectMapper.class)) continue;
                        return (ObjectMapper)((ContextResolver)provider).getContext(Object.class);
                    }
                }
                return super._locateMapperViaProvider(type, mediaType);
            }
        };
    }

    private boolean notJaxRS(Object instance) {
        Class<?> clazz = instance.getClass();
        return clazz.getAnnotation(Path.class) == null && clazz.getAnnotation(Provider.class) == null;
    }

    private String getRootPath(Object instance) {
        Class<?> clazz = instance.getClass();
        Module module = clazz.getModule();
        String rootPath = "api";
        if (module != null && module.getAnnotation(EndpointPath.class) != null) {
            rootPath = module.getAnnotation(EndpointPath.class).value();
        }
        return rootPath;
    }

    private class Holder {
        String rootPath;
        ServletContainer servletContainer;
        ResourceConfig resourceConfig;

        public Holder(String rootPath, ServletContainer servletContainer, ResourceConfig resourceConfig) {
            this.rootPath = rootPath;
            this.servletContainer = servletContainer;
            this.resourceConfig = resourceConfig;
        }
    }

    private class WebReloadListener
    implements ReloadListener {
        private WebReloadListener() {
        }

        public void onInstanceChanged(Object instance) {
            if (WebSubsystem.this.notJaxRS(instance)) {
                return;
            }
            Holder holder = WebSubsystem.this.instanceToContainers.get(instance);
            if (holder == null) {
                this.onInstanceAdded(instance);
                return;
            }
            this.setContext(holder);
        }

        public void onInstanceAdded(Object instance) {
            if (WebSubsystem.this.notJaxRS(instance)) {
                return;
            }
            String rootPath = WebSubsystem.this.getRootPath(instance);
            Holder holder = WebSubsystem.this.pathToContainers.get(rootPath);
            if (holder == null) {
                return;
            }
            this.setContext(holder);
            if (!holder.resourceConfig.isRegistered(instance)) {
                holder.resourceConfig.register(instance);
                holder.servletContainer.reload(null);
            }
        }

        private void setContext(Holder holder) {
            Utils.store((ResourceConfig)holder.resourceConfig, (ServletContext)holder.servletContainer.getServletContext(), (String)("RhizomaticRest_" + holder.rootPath));
        }
    }
}

