/*
 * Decompiled with CFR 0.152.
 */
package io.rhizomatic.web.http;

import io.rhizomatic.api.Monitor;
import io.rhizomatic.kernel.spi.SystemConfiguration;
import io.rhizomatic.kernel.spi.subsystem.SubsystemContext;
import io.rhizomatic.web.http.RzErrorHandler;
import io.rhizomatic.web.http.RzJettyLogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class JettyTransport {
    @SystemConfiguration
    private static final String HTTP_PORT = "http.port";
    @SystemConfiguration
    private static final String HTTPS_PORT = "https.port";
    @SystemConfiguration
    private static final String HTTPS_ENABLED = "https.enabled";
    private static final String LOG_CLASS = "org.eclipse.jetty.util.log.class";
    private static final String ANNOUNCE = "org.eclipse.jetty.util.log.announce";
    private int httpPort;
    private Server server;
    private Monitor monitor;
    private List<Handler> handlers = new ArrayList<Handler>();

    public JettyTransport() {
        System.setProperty(LOG_CLASS, RzJettyLogger.class.getName());
        System.setProperty(ANNOUNCE, "false");
    }

    public void initialize(SubsystemContext context) {
        this.httpPort = this.getHttp(context);
        this.server = new Server(this.httpPort);
    }

    public void start(SubsystemContext context) {
        RzJettyLogger.MONITOR = this.monitor = context.getMonitor();
        this.server.setErrorHandler((ErrorHandler)new RzErrorHandler());
        try {
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
            this.server.setHandler((Handler)contexts);
            this.server.start();
            this.monitor.info(() -> "Listening on HTTP " + this.httpPort, new Throwable[0]);
        }
        catch (Exception e) {
            this.monitor.severe(() -> "Error starting HTTP transport", new Throwable[]{e});
        }
    }

    public void shutdown() {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop();
        }
        catch (Exception e) {
            this.monitor.severe(() -> "Error stopping HTTP transport", new Throwable[]{e});
        }
    }

    public void registerHandler(Handler handler) {
        this.handlers.add(handler);
    }

    private int getHttp(SubsystemContext context) {
        Integer httpPort = (Integer)context.getConfiguration(Integer.class, HTTP_PORT);
        if (httpPort == null) {
            httpPort = 8080;
        }
        return httpPort;
    }
}

